/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.InfinispanCollections;
import org.jgroups.protocols.DISCARD;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferRestartTest")
@CleanupAfterMethod
public class StateTransferRestartTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder cfgBuilder;
    private GlobalConfigurationBuilder gcfgBuilder;
    private MockTransport mockTransport = new MockTransport();

    private void waitForStateTransfer(Cache ... caches) throws InterruptedException {
        StateTransferManager[] stm = new StateTransferManager[caches.length];
        for (int i = 0; i < stm.length; ++i) {
            stm[i] = TestingUtil.extractComponent(caches[i], StateTransferManager.class);
        }
        while (true) {
            boolean inProgress = false;
            for (StateTransferManager aStm : stm) {
                if (!aStm.isStateTransferInProgress()) continue;
                inProgress = true;
                break;
            }
            if (!inProgress) break;
            this.wait(100L);
        }
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.cfgBuilder = StateTransferRestartTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.cfgBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.cfgBuilder.clustering().hash().numOwners(2);
        this.cfgBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        this.cfgBuilder.clustering().stateTransfer().timeout(20000L);
        this.gcfgBuilder = new GlobalConfigurationBuilder();
        this.gcfgBuilder.transport().transport((Transport)this.mockTransport);
    }

    public void testStateTransferRestart() throws Throwable {
        int numKeys = 100;
        this.addClusterEnabledCacheManager(this.cfgBuilder, new TransportFlags().withFD(true));
        this.addClusterEnabledCacheManager(this.gcfgBuilder, this.cfgBuilder, new TransportFlags().withFD(true));
        this.log.info((Object)"waiting for cluster { c0, c1 }");
        this.waitForClusterToForm();
        this.log.info((Object)"putting in data");
        final Cache c0 = this.cache(0);
        final Cache c1 = this.cache(1);
        for (int k = 0; k < 100; ++k) {
            c0.put((Object)k, (Object)k);
        }
        this.waitForStateTransfer(c0, c1);
        Assert.assertEquals((long)100L, (long)c0.entrySet().size());
        Assert.assertEquals((long)100L, (long)c1.entrySet().size());
        this.mockTransport.callOnStateResponseCommand = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                StateTransferRestartTest.this.fork(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        StateTransferRestartTest.this.log.info((Object)"KILLING the c1 cache");
                        try {
                            DISCARD d3 = TestingUtil.getDiscardForCache(c1);
                            d3.setDiscardAll(true);
                            d3.setExcludeItself(true);
                            TestingUtil.killCacheManagers(StateTransferRestartTest.this.manager(c1));
                        }
                        catch (Exception e) {
                            StateTransferRestartTest.this.log.info((Object)"there was some exception while killing cache");
                        }
                        return null;
                    }
                });
                try {
                    Thread.sleep(25000L);
                }
                catch (InterruptedException e) {
                    StateTransferRestartTest.this.log.info((Object)"Interrupted as expected.");
                    Thread.currentThread().interrupt();
                }
                return null;
            }
        };
        this.log.info((Object)"adding cache c2");
        this.addClusterEnabledCacheManager(this.cfgBuilder, new TransportFlags().withFD(true));
        this.log.info((Object)"get c2");
        final Cache c2 = this.cache(2);
        this.log.info((Object)"waiting for cluster { c0, c2 }");
        TestingUtil.blockUntilViewsChanged(10000L, 2, c0, c2);
        this.log.infof("c0 entrySet size before : %d", (Object)c0.entrySet().size());
        this.log.infof("c2 entrySet size before : %d", (Object)c2.entrySet().size());
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return c0.entrySet().size() == 100 && c2.entrySet().size() == 100;
            }
        });
        this.log.info((Object)"Ending the test");
    }

    private class MockTransport
    extends JGroupsTransport {
        volatile Callable<Void> callOnStateResponseCommand;

        private MockTransport() {
        }

        public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) throws Exception {
            if (this.callOnStateResponseCommand != null && rpcCommand.getClass() == StateResponseCommand.class) {
                StateTransferRestartTest.this.log.trace((Object)"Ignoring StateResponseCommand");
                try {
                    this.callOnStateResponseCommand.call();
                }
                catch (Exception e) {
                    StateTransferRestartTest.this.log.error((Object)"Error in callOnStateResponseCommand", (Throwable)e);
                }
                return InfinispanCollections.emptyMap();
            }
            return super.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
        }
    }
}

