/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.AbstractDelegatingMarshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.ExternalizerTable;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.DefaultRebalancePolicy;
import org.infinispan.topology.RebalancePolicy;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.Channel;
import org.jgroups.protocols.DELAY;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.testng.AssertJUnit;

public class TestingUtil {
    private static final Log log = LogFactory.getLog(TestingUtil.class);
    private static final Random random = new Random();
    public static final String TEST_PATH = "infinispanTempFiles";
    public static final String INFINISPAN_START_TAG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.2 http://www.infinispan.org/schemas/infinispan-config-5.2.xsd\"\n      xmlns=\"urn:infinispan:config:5.2\">";
    public static final String INFINISPAN_START_TAG_51 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.1 http://www.infinispan.org/schemas/infinispan-config-5.1.xsd\"\n      xmlns=\"urn:infinispan:config:5.1\">";
    public static final String INFINISPAN_START_TAG_40 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:4.0 http://www.infinispan.org/schemas/infinispan-config-4.0.xsd\"\n      xmlns=\"urn:infinispan:config:4.0\">";
    public static final String INFINISPAN_END_TAG = "</infinispan>";
    public static final String INFINISPAN_START_TAG_NO_SCHEMA = "<infinispan>";

    public static Object extractField(Object target, String fieldName) {
        return TestingUtil.extractField(target.getClass(), target, fieldName);
    }

    public static void replaceField(Object newValue, String fieldName, Object owner, Class baseType) {
        try {
            Field field = baseType.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(owner, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object extractField(Class type, Object target, String fieldName) {
        while (true) {
            try {
                Field field = type.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(target);
            }
            catch (Exception e) {
                if (type.equals(Object.class)) {
                    e.printStackTrace();
                    return null;
                }
                type = type.getSuperclass();
                continue;
            }
            break;
        }
    }

    public static <T extends CommandInterceptor> T findInterceptor(Cache<?, ?> cache, Class<T> interceptorToFind) {
        for (CommandInterceptor i : cache.getAdvancedCache().getInterceptorChain()) {
            if (!interceptorToFind.isInstance(i)) continue;
            return (T)((CommandInterceptor)interceptorToFind.cast(i));
        }
        return null;
    }

    public static void waitForRehashToComplete(Cache ... caches) {
        int gracetime = 90000;
        long giveup = System.currentTimeMillis() + (long)gracetime;
        for (Cache c : caches) {
            StateTransferManager stateTransferManager = TestingUtil.extractComponent(c, StateTransferManager.class);
            DefaultRebalancePolicy rebalancePolicy = (DefaultRebalancePolicy)TestingUtil.extractGlobalComponent((CacheContainer)c.getCacheManager(), RebalancePolicy.class);
            Address cacheAddress = c.getAdvancedCache().getRpcManager().getAddress();
            while (true) {
                boolean chContainsAllMembers;
                CacheTopology cacheTopology = stateTransferManager.getCacheTopology();
                boolean rebalanceInProgress = stateTransferManager.isStateTransferInProgress();
                boolean chIsBalanced = !rebalanceInProgress && rebalancePolicy.isBalanced(cacheTopology.getCurrentCH());
                boolean bl = chContainsAllMembers = cacheTopology.getCurrentCH().getMembers().size() == caches.length;
                if (chIsBalanced && chContainsAllMembers) break;
                if (System.currentTimeMillis() > giveup) {
                    String message;
                    if (!chContainsAllMembers) {
                        Object[] addresses = new Address[caches.length];
                        for (int i = 0; i < caches.length; ++i) {
                            addresses[i] = caches[i].getCacheManager().getAddress();
                        }
                        message = String.format("Timed out waiting for rebalancing to complete on node %s, expected member list is %s, current member list is %s!", cacheAddress, Arrays.toString(addresses), cacheTopology.getCurrentCH().getMembers());
                    } else {
                        message = String.format("Timed out waiting for rebalancing to complete on node %s, current topology is %s", c.getCacheManager().getAddress(), cacheTopology);
                    }
                    log.error((Object)message);
                    throw new RuntimeException(message);
                }
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
            }
            log.trace((Object)("Node " + cacheAddress + " finished state transfer."));
        }
    }

    public static void waitForRehashToComplete(Collection<? extends Cache> caches) {
        TestingUtil.waitForRehashToComplete(caches.toArray(new Cache[caches.size()]));
    }

    public static void blockUntilViewsReceived(Cache[] caches, long timeout) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches)) continue;
            return;
        }
        TestingUtil.viewsTimedOut(caches);
    }

    private static void viewsTimedOut(Cache[] caches) {
        CacheContainer[] cacheContainers = new CacheContainer[caches.length];
        for (int i = 0; i < caches.length; ++i) {
            cacheContainers[i] = caches[i].getCacheManager();
        }
        TestingUtil.viewsTimedOut(cacheContainers);
    }

    private static void viewsTimedOut(CacheContainer[] cacheContainers) {
        int length = cacheContainers.length;
        ArrayList<List> allViews = new ArrayList<List>(length);
        for (int i = 0; i < length; ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)cacheContainers[i];
            allViews.add(cm.getMembers());
        }
        throw new RuntimeException(String.format("Timed out before caches had complete views.  Expected %d members in each view.  Views are as follows: %s", cacheContainers.length, allViews));
    }

    public static void blockUntilViewsReceivedInt(Cache[] caches, long timeout) throws InterruptedException {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThreadInt(100L, null);
            if (!TestingUtil.areCacheViewsComplete(caches)) continue;
            return;
        }
        TestingUtil.viewsTimedOut(caches);
    }

    public static void blockUntilViewsReceived(long timeout, Cache ... caches) {
        TestingUtil.blockUntilViewsReceived(caches, timeout);
    }

    public static void blockUntilViewsReceivedInt(long timeout, Cache ... caches) throws InterruptedException {
        TestingUtil.blockUntilViewsReceivedInt(caches, timeout);
    }

    public static void blockUntilViewsReceived(long timeout, CacheContainer ... cacheContainers) {
        TestingUtil.blockUntilViewsReceived(timeout, true, cacheContainers);
    }

    public static void blockForMemberToFail(long timeout, CacheContainer ... cacheContainers) {
        TestingUtil.blockUntilViewsReceived(timeout, false, cacheContainers);
        TestingUtil.areCacheViewsComplete(true, cacheContainers);
    }

    public static void blockUntilViewsReceived(long timeout, boolean barfIfTooManyMembers, CacheContainer ... cacheContainers) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            if (TestingUtil.areCacheViewsComplete(barfIfTooManyMembers, cacheContainers)) {
                return;
            }
            TestingUtil.sleepThread(100L);
        }
        TestingUtil.viewsTimedOut(cacheContainers);
    }

    public static void blockUntilViewsReceived(long timeout, boolean barfIfTooManyMembers, Cache ... caches) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsComplete(caches, barfIfTooManyMembers)) continue;
            return;
        }
        TestingUtil.viewsTimedOut(caches);
    }

    public static void blockUntilViewReceived(Cache cache, int groupSize, long timeout) {
        TestingUtil.blockUntilViewReceived(cache, groupSize, timeout, true);
    }

    public static void blockUntilViewReceived(Cache cache, int groupSize) {
        TestingUtil.blockUntilViewReceived(cache, groupSize, 10000L, true);
    }

    public static void blockUntilViewReceived(Cache cache, int groupSize, long timeout, boolean barfIfTooManyMembersInView) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            if (!TestingUtil.isCacheViewComplete(cacheManager.getMembers(), cacheManager.getAddress(), groupSize, barfIfTooManyMembersInView)) continue;
            return;
        }
        throw new RuntimeException(String.format("Timed out before cache had %d members.  View is %s", groupSize, cache.getCacheManager().getMembers()));
    }

    public static boolean areCacheViewsComplete(Cache[] caches) {
        return TestingUtil.areCacheViewsComplete(caches, true);
    }

    public static boolean areCacheViewsComplete(Cache[] caches, boolean barfIfTooManyMembers) {
        int memberCount = caches.length;
        for (int i = 0; i < memberCount; ++i) {
            EmbeddedCacheManager cacheManager = caches[i].getCacheManager();
            if (TestingUtil.isCacheViewComplete(cacheManager.getMembers(), cacheManager.getAddress(), memberCount, barfIfTooManyMembers)) continue;
            return false;
        }
        return true;
    }

    public static boolean areCacheViewsComplete(boolean barfIfTooManyMembers, CacheContainer ... cacheContainers) {
        if (cacheContainers == null) {
            throw new NullPointerException("Cache Manager array is null");
        }
        int memberCount = cacheContainers.length;
        for (int i = 0; i < memberCount; ++i) {
            EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)cacheContainers[i];
            if (TestingUtil.isCacheViewComplete(cacheManager.getMembers(), cacheManager.getAddress(), memberCount, barfIfTooManyMembers)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCacheViewComplete(Cache c, int memberCount) {
        EmbeddedCacheManager cacheManager = c.getCacheManager();
        return TestingUtil.isCacheViewComplete(cacheManager.getMembers(), cacheManager.getAddress(), memberCount, true);
    }

    public static boolean isCacheViewComplete(List members, Address address, int memberCount, boolean barfIfTooManyMembers) {
        if (members == null || memberCount > members.size()) {
            return false;
        }
        if (memberCount < members.size()) {
            if (barfIfTooManyMembers) {
                StringBuilder sb = new StringBuilder("Cache at address ");
                sb.append(address);
                sb.append(" had ");
                sb.append(members.size());
                sb.append(" members; expecting ");
                sb.append(memberCount);
                sb.append(". Members were (");
                for (int j = 0; j < members.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    sb.append(members.get(j));
                }
                sb.append(')');
                throw new IllegalStateException(sb.toString());
            }
            return false;
        }
        return true;
    }

    public static void blockUntilViewsChanged(long timeout, int finalViewSize, Cache ... caches) {
        TestingUtil.blockUntilViewsChanged(caches, timeout, finalViewSize);
    }

    private static void blockUntilViewsChanged(Cache[] caches, long timeout, int finalViewSize) {
        long failTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < failTime) {
            TestingUtil.sleepThread(100L);
            if (!TestingUtil.areCacheViewsChanged(caches, finalViewSize)) continue;
            return;
        }
        ArrayList<List> allViews = new ArrayList<List>(caches.length);
        for (int i = 0; i < caches.length; ++i) {
            allViews.add(caches[i].getCacheManager().getMembers());
        }
        throw new RuntimeException(String.format("Timed out before caches had changed views (%s) to contain %d members", allViews, finalViewSize));
    }

    private static boolean areCacheViewsChanged(Cache[] caches, int finalViewSize) {
        int memberCount = caches.length;
        for (int i = 0; i < memberCount; ++i) {
            EmbeddedCacheManager cacheManager = caches[i].getCacheManager();
            if (TestingUtil.isCacheViewChanged(cacheManager.getMembers(), finalViewSize)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCacheViewChanged(List members, int finalViewSize) {
        return members != null && finalViewSize == members.size();
    }

    public static void sleepThread(long sleeptime) {
        TestingUtil.sleepThread(sleeptime, null);
    }

    public static void sleepThread(long sleeptime, String messageOnInterrupt) {
        block2: {
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException ie) {
                if (messageOnInterrupt == null) break block2;
                log.error((Object)messageOnInterrupt);
            }
        }
    }

    public static void sleepThreadInt(long sleeptime, String messageOnInterrupt) throws InterruptedException {
        try {
            Thread.sleep(sleeptime);
        }
        catch (InterruptedException ie) {
            if (messageOnInterrupt != null) {
                log.error((Object)messageOnInterrupt);
            }
            throw ie;
        }
    }

    public static void sleepRandom(int maxTime) {
        TestingUtil.sleepThread(random.nextInt(maxTime));
    }

    public static void recursiveFileRemove(String directoryName) {
        File file = new File(directoryName);
        TestingUtil.recursiveFileRemove(file);
    }

    public static void recursiveFileRemove(File file) {
        if (file.exists()) {
            System.out.println("Deleting file " + file);
            TestingUtil.recursiveDelete(file);
        }
    }

    private static void recursiveDelete(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                TestingUtil.recursiveDelete(file);
            }
        }
        f.delete();
    }

    public static void killCacheManagers(CacheContainer ... cacheContainers) {
        EmbeddedCacheManager[] cms = new EmbeddedCacheManager[cacheContainers.length];
        for (int i = 0; i < cacheContainers.length; ++i) {
            cms[i] = (EmbeddedCacheManager)cacheContainers[i];
        }
        TestingUtil.killCacheManagers(cms);
    }

    public static void killCacheManagers(List<? extends CacheContainer> cacheContainers) {
        EmbeddedCacheManager[] cms = new EmbeddedCacheManager[cacheContainers.size()];
        for (int i = 0; i < cacheContainers.size(); ++i) {
            cms[i] = (EmbeddedCacheManager)cacheContainers.get(i);
        }
        TestingUtil.killCacheManagers(cms);
    }

    public static void killCacheManagers(EmbeddedCacheManager ... cacheManagers) {
        for (EmbeddedCacheManager cm : cacheManagers) {
            try {
                TestingUtil.killCaches(TestingUtil.getRunningCaches(cm));
            }
            catch (Throwable e) {
                log.warn((Object)("Problems stopping cache manager " + cm), e);
            }
        }
        for (EmbeddedCacheManager cm : cacheManagers) {
            try {
                if (cm == null) continue;
                cm.stop();
            }
            catch (Throwable e) {
                log.warn((Object)("Problems killing cache manager " + cm), e);
            }
        }
    }

    public static void clearContent(EmbeddedCacheManager ... cacheManagers) {
        TestingUtil.clearContent(Arrays.asList(cacheManagers));
    }

    public static void clearContent(List<? extends EmbeddedCacheManager> cacheManagers) {
        for (EmbeddedCacheManager embeddedCacheManager : cacheManagers) {
            try {
                TestingUtil.clearContent(embeddedCacheManager);
            }
            catch (Throwable e) {
                log.warn((Object)("Problems clearing cache manager " + embeddedCacheManager), e);
            }
        }
    }

    public static void clearContent(EmbeddedCacheManager cacheContainer) {
        if (cacheContainer != null && cacheContainer.getStatus().allowInvocations()) {
            Set<Cache> runningCaches = TestingUtil.getRunningCaches(cacheContainer);
            for (Cache cache : runningCaches) {
                TestingUtil.clearRunningTx(cache);
            }
            if (!cacheContainer.getStatus().allowInvocations()) {
                return;
            }
            for (Cache cache : runningCaches) {
                TestingUtil.clearReplicationQueues(cache);
                TestingUtil.clearCacheLoader(cache);
                TestingUtil.removeInMemoryData(cache);
            }
        }
    }

    protected static Set<Cache> getRunningCaches(EmbeddedCacheManager cacheContainer) {
        Cache defaultCache;
        HashSet<Cache> running = new HashSet<Cache>();
        if (cacheContainer == null || !cacheContainer.getStatus().allowInvocations()) {
            return running;
        }
        for (String cacheName : cacheContainer.getCacheNames()) {
            Cache c;
            if (!cacheContainer.isRunning(cacheName) || !(c = cacheContainer.getCache(cacheName)).getStatus().allowInvocations()) continue;
            running.add(c);
        }
        if (cacheContainer.isDefaultRunning() && (defaultCache = cacheContainer.getCache()).getStatus().allowInvocations()) {
            running.add(defaultCache);
        }
        return running;
    }

    private static void clearRunningTx(Cache cache) {
        if (cache != null) {
            TransactionManager txm = TestingUtil.getTransactionManager(cache);
            if (txm == null) {
                return;
            }
            try {
                txm.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void clearReplicationQueues(Cache cache) {
        ReplicationQueue queue = TestingUtil.extractComponent(cache, ReplicationQueue.class);
        if (queue != null) {
            queue.reset();
        }
    }

    public static void clearCacheLoader(Cache cache) {
        CacheLoaderManager cacheLoaderManager = TestingUtil.extractComponent(cache, CacheLoaderManager.class);
        if (cacheLoaderManager != null && cacheLoaderManager.getCacheStore() != null) {
            try {
                cacheLoaderManager.getCacheStore().clear();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <K, V> List<CacheStore> cachestores(List<Cache<K, V>> caches) {
        LinkedList<CacheStore> l = new LinkedList<CacheStore>();
        for (Cache<K, V> c : caches) {
            l.add(TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore());
        }
        return l;
    }

    private static void removeInMemoryData(Cache cache) {
        EmbeddedCacheManager mgr = cache.getCacheManager();
        Address a = mgr.getAddress();
        String str = a == null ? "a non-clustered cache manager" : "a cache manager at address " + a;
        log.debugf("Cleaning data for cache '%s' on %s", (Object)cache.getName(), (Object)str);
        DataContainer dataContainer = TestingUtil.extractComponent(cache, DataContainer.class);
        if (log.isDebugEnabled()) {
            log.debugf("removeInMemoryData(): dataContainerBefore == %s", (Object)dataContainer.entrySet());
        }
        dataContainer.clear();
        if (log.isDebugEnabled()) {
            log.debugf("removeInMemoryData(): dataContainerAfter == %s", (Object)dataContainer.entrySet());
        }
    }

    public static void killCaches(Cache ... caches) {
        TestingUtil.killCaches(Arrays.asList(caches));
    }

    public static void killCaches(Collection<Cache> caches) {
        for (Cache c : caches) {
            try {
                if (c == null || c.getStatus() != ComponentStatus.RUNNING) continue;
                TransactionManager tm = TestingUtil.getTransactionManager(c);
                if (tm != null) {
                    try {
                        tm.rollback();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (c.getAdvancedCache().getRpcManager() != null) {
                    log.tracef("Cache contents on %s before stopping: %s", (Object)c.getAdvancedCache().getRpcManager().getAddress(), (Object)c.entrySet());
                } else {
                    log.tracef("Cache contents before stopping: %s", (Object)c.entrySet());
                }
                c.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void killTransaction(TransactionManager txManager) {
        if (txManager != null) {
            try {
                txManager.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void killTransactions(Cache ... caches) {
        for (Cache c : caches) {
            TransactionManager tm;
            if (c == null || c.getStatus() != ComponentStatus.RUNNING || (tm = TestingUtil.getTransactionManager(c)) == null) continue;
            try {
                tm.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static ComponentRegistry extractComponentRegistry(Cache cache) {
        ComponentRegistry cr = (ComponentRegistry)TestingUtil.extractField(cache, "componentRegistry");
        if (cr == null) {
            cr = cache.getAdvancedCache().getComponentRegistry();
        }
        return cr;
    }

    public static GlobalComponentRegistry extractGlobalComponentRegistry(CacheContainer cacheContainer) {
        return (GlobalComponentRegistry)TestingUtil.extractField(cacheContainer, "globalComponentRegistry");
    }

    public static LockManager extractLockManager(Cache cache) {
        return (LockManager)TestingUtil.extractComponentRegistry(cache).getComponent(LockManager.class);
    }

    public static ComponentRegistry extractComponentRegistry(InterceptorChain ci) {
        return (ComponentRegistry)TestingUtil.extractField(ci, "componentRegistry");
    }

    public static AbstractDelegatingMarshaller extractCacheMarshaller(Cache cache) {
        ComponentRegistry cr = (ComponentRegistry)TestingUtil.extractField(cache, "componentRegistry");
        StreamingMarshaller marshaller = (StreamingMarshaller)cr.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        return (AbstractDelegatingMarshaller)marshaller;
    }

    public static AbstractDelegatingMarshaller extractGlobalMarshaller(EmbeddedCacheManager cm) {
        GlobalComponentRegistry gcr = (GlobalComponentRegistry)TestingUtil.extractField(cm, "globalComponentRegistry");
        return (AbstractDelegatingMarshaller)gcr.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.global");
    }

    public static ExternalizerTable extractExtTable(CacheContainer cacheContainer) {
        GlobalComponentRegistry gcr = (GlobalComponentRegistry)TestingUtil.extractField(cacheContainer, "globalComponentRegistry");
        return (ExternalizerTable)gcr.getComponent(ExternalizerTable.class);
    }

    public static void replaceInterceptorChain(Cache cache, CommandInterceptor interceptor) {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache);
        CommandInterceptor i = interceptor;
        do {
            cr.wireDependencies((Object)i);
        } while ((i = i.getNext()) != null);
        InterceptorChain inch = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        inch.setFirstInChain(interceptor);
    }

    public static boolean replaceInterceptor(Cache cache, CommandInterceptor replacingInterceptor, Class<? extends CommandInterceptor> toBeReplacedInterceptorType) {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache);
        CommandInterceptor i = replacingInterceptor;
        do {
            cr.wireDependencies((Object)i);
        } while ((i = i.getNext()) != null);
        InterceptorChain inch = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        return inch.replaceInterceptor(replacingInterceptor, toBeReplacedInterceptorType);
    }

    public static CacheImpl getInvocationDelegate(Cache cache) {
        return (CacheImpl)cache;
    }

    public static void blockUntilCacheStatusAchieved(Cache cache, ComponentStatus cacheStatus, long timeout) {
        AdvancedCache spi = cache.getAdvancedCache();
        long killTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < killTime) {
            if (spi.getStatus() == cacheStatus) {
                return;
            }
            TestingUtil.sleepThread(50L);
        }
        throw new RuntimeException("Timed out waiting for condition");
    }

    public static void replicateCommand(Cache cache, VisitableCommand command) throws Throwable {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache);
        InterceptorChain ic = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        InvocationContextContainer icc = (InvocationContextContainer)cr.getComponent(InvocationContextContainer.class);
        InvocationContext ctxt = icc.createInvocationContext(true, -1);
        ic.invoke(ctxt, command);
    }

    public static void blockUntilViewsReceived(int timeout, Collection caches) {
        Object first = caches.iterator().next();
        if (first instanceof Cache) {
            TestingUtil.blockUntilViewsReceived((long)timeout, caches.toArray(new Cache[0]));
        } else {
            TestingUtil.blockUntilViewsReceived((long)timeout, caches.toArray(new CacheContainer[0]));
        }
    }

    public static void blockUntilViewsReceived(int timeout, boolean barfIfTooManyMembers, Collection caches) {
        Object first = caches.iterator().next();
        if (first instanceof Cache) {
            TestingUtil.blockUntilViewsReceived((long)timeout, barfIfTooManyMembers, caches.toArray(new Cache[0]));
        } else {
            TestingUtil.blockUntilViewsReceived((long)timeout, barfIfTooManyMembers, caches.toArray(new CacheContainer[0]));
        }
    }

    public static CommandsFactory extractCommandsFactory(Cache<Object, Object> cache) {
        return (CommandsFactory)TestingUtil.extractField(cache, "commandsFactory");
    }

    public static void dumpCacheContents(List caches) {
        System.out.println("**** START: Cache Contents ****");
        int count = 1;
        for (Object o : caches) {
            Cache c = (Cache)o;
            if (c == null) {
                System.out.println("  ** Cache " + count + " is null!");
            } else {
                EmbeddedCacheManager cacheManager = c.getCacheManager();
                System.out.println("  ** Cache " + count + " is " + cacheManager.getAddress());
            }
            ++count;
        }
        System.out.println("**** END: Cache Contents ****");
    }

    public static void dumpCacheContents(Cache ... caches) {
        TestingUtil.dumpCacheContents(Arrays.asList(caches));
    }

    public static <T> T extractComponent(Cache cache, Class<T> componentType) {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache);
        return (T)cr.getComponent(componentType);
    }

    public static <T> T extractGlobalComponent(CacheContainer cacheContainer, Class<T> componentType) {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry(cacheContainer);
        return (T)gcr.getComponent(componentType);
    }

    public static TransactionManager getTransactionManager(Cache cache) {
        return cache == null ? null : TestingUtil.extractComponent(cache, TransactionManager.class);
    }

    public static <T> T replaceComponent(Cache<?, ?> cache, Class<T> componentType, T replacementComponent, boolean rewire) {
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(cache);
        Object old = cr.getComponent(componentType);
        cr.registerComponent(replacementComponent, componentType);
        if (rewire) {
            cr.rewire();
        }
        return (T)old;
    }

    public static <T> T replaceComponent(CacheContainer cacheContainer, Class<T> componentType, T replacementComponent, boolean rewire) {
        GlobalComponentRegistry cr = TestingUtil.extractGlobalComponentRegistry(cacheContainer);
        Object old = cr.getComponent(componentType);
        cr.registerComponent(replacementComponent, componentType);
        if (rewire) {
            cr.rewire();
            cr.rewireNamedRegistries();
        }
        return (T)old;
    }

    public static CacheLoader getCacheLoader(Cache cache) {
        CacheLoaderManager clm = TestingUtil.extractComponent(cache, CacheLoaderManager.class);
        if (clm != null && clm.isEnabled()) {
            return clm.getCacheLoader();
        }
        return null;
    }

    public static String printCache(Cache cache) {
        DataContainer dataContainer = TestingUtil.extractComponent(cache, DataContainer.class);
        Iterator it = dataContainer.iterator();
        StringBuilder builder = new StringBuilder(cache.getName() + "[");
        while (it.hasNext()) {
            CacheEntry ce = (CacheEntry)it.next();
            builder.append(ce.getKey() + "=" + ce.getValue() + ",l=" + ce.getLifespan() + "; ");
        }
        builder.append("]");
        return builder.toString();
    }

    public static Set getInternalKeys(Cache cache) {
        DataContainer dataContainer = TestingUtil.extractComponent(cache, DataContainer.class);
        HashSet<Object> keys = new HashSet<Object>();
        for (CacheEntry entry : dataContainer) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    public static Collection getInternalValues(Cache cache) {
        DataContainer dataContainer = TestingUtil.extractComponent(cache, DataContainer.class);
        ArrayList<Object> values = new ArrayList<Object>();
        for (CacheEntry entry : dataContainer) {
            values.add(entry.getValue());
        }
        return values;
    }

    public static DISCARD getDiscardForCache(Cache<?, ?> c) throws Exception {
        JGroupsTransport jgt = (JGroupsTransport)TestingUtil.extractComponent(c, Transport.class);
        Channel ch = jgt.getChannel();
        ProtocolStack ps = ch.getProtocolStack();
        DISCARD discard = new DISCARD();
        ps.insertProtocol((Protocol)discard, 1, TP.class);
        return discard;
    }

    public static DELAY setDelayForCache(Cache<?, ?> cache, int in_delay_millis, int out_delay_millis) throws Exception {
        JGroupsTransport jgt = (JGroupsTransport)TestingUtil.extractComponent(cache, Transport.class);
        Channel ch = jgt.getChannel();
        ProtocolStack ps = ch.getProtocolStack();
        DELAY delay = new DELAY();
        delay.setInDelay(in_delay_millis);
        delay.setOutDelay(out_delay_millis);
        ps.insertProtocol((Protocol)delay, 1, TP.class);
        return delay;
    }

    public static String tmpDirectory(AbstractInfinispanTest test) {
        String prefix = System.getProperty("infinispan.test.tmpdir", System.getProperty("java.io.tmpdir"));
        return prefix + File.separator + TEST_PATH + File.separator + test.getClass().getSimpleName();
    }

    public static String k(Method method, int index) {
        return "k" + index + '-' + method.getName();
    }

    public static String v(Method method, int index) {
        return "v" + index + '-' + method.getName();
    }

    public static String k(Method method) {
        return TestingUtil.k(method, 0);
    }

    public static String v(Method method) {
        return TestingUtil.v(method, 0);
    }

    public static String k(Method m, String prefix) {
        return prefix + m.getName();
    }

    public static String v(Method m, String prefix) {
        return prefix + m.getName();
    }

    public static TransactionTable getTransactionTable(Cache<Object, Object> cache) {
        return (TransactionTable)cache.getAdvancedCache().getComponentRegistry().getComponent(TransactionTable.class);
    }

    public static String getMethodSpecificJmxDomain(Method m, String jmxDomain) {
        return jmxDomain + '.' + m.getName();
    }

    public static ObjectName getCacheManagerObjectName(String jmxDomain) {
        return TestingUtil.getCacheManagerObjectName(jmxDomain, "DefaultCacheManager");
    }

    public static ObjectName getCacheManagerObjectName(String jmxDomain, String cacheManagerName) {
        try {
            return new ObjectName(jmxDomain + ":type=CacheManager,name=" + ObjectName.quote(cacheManagerName) + ",component=CacheManager");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectName getCacheObjectName(String jmxDomain) {
        return TestingUtil.getCacheObjectName(jmxDomain, "___defaultcache(local)");
    }

    public static ObjectName getCacheObjectName(String jmxDomain, String cacheName) {
        return TestingUtil.getCacheObjectName(jmxDomain, cacheName, "Cache");
    }

    public static ObjectName getCacheObjectName(String jmxDomain, String cacheName, String component) {
        return TestingUtil.getCacheObjectName(jmxDomain, cacheName, component, "DefaultCacheManager");
    }

    public static ObjectName getCacheObjectName(String jmxDomain, String cacheName, String component, String cacheManagerName) {
        try {
            return new ObjectName(jmxDomain + ":type=Cache,manager=" + ObjectName.quote(cacheManagerName) + ",name=" + ObjectName.quote(cacheName) + ",component=" + component);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectName getJGroupsChannelObjectName(String jmxDomain, String clusterName) throws Exception {
        return new ObjectName(String.format("%s:type=channel,cluster=%s", jmxDomain, ObjectName.quote(clusterName)));
    }

    public static boolean existsObject(ObjectName objectName) {
        return PerThreadMBeanServerLookup.getThreadMBeanServer().isRegistered(objectName);
    }

    public static boolean existsDomains(String ... domains) {
        MBeanServer mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        HashSet<String> domainSet = new HashSet<String>(Arrays.asList(domains));
        for (String domain : mBeanServer.getDomains()) {
            if (!domainSet.contains(domain)) continue;
            return true;
        }
        return false;
    }

    public static void checkMBeanOperationParameterNaming(ObjectName objectName) throws Exception {
        MBeanServer mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(objectName);
        for (MBeanOperationInfo op : mBeanInfo.getOperations()) {
            for (MBeanParameterInfo param : op.getSignature()) {
                AssertJUnit.assertFalse((boolean)param.getName().matches("p[0-9]+"));
            }
        }
    }

    public static String generateRandomString(int numberOfChars) {
        Random r = new Random(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfChars; ++i) {
            sb.append((char)(64 + r.nextInt(26)));
        }
        return sb.toString();
    }

    public static void assertNoLocks(Cache<?, ?> cache) {
        LockManager lm = TestingUtil.extractLockManager(cache);
        for (Object key : cache.keySet()) {
            assert (!lm.isLocked(key));
        }
    }

    public static <T> T withTx(TransactionManager tm, Callable<T> c) throws Exception {
        tm.begin();
        try {
            T t = c.call();
            return t;
        }
        catch (Exception e) {
            tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (tm.getStatus() == 0) {
                tm.commit();
            } else {
                tm.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withCacheManager(CacheManagerCallable c) {
        try {
            c.call();
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(c.cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(c.cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withCacheManagers(MultiCacheManagerCallable c) {
        try {
            c.call();
        }
        finally {
            TestingUtil.killCacheManagers(c.cms);
        }
    }
}

