/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.CountDownLatch;
import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.PrepareProcessedAfterOriginatorCrashTest")
public class PrepareProcessedAfterOriginatorCrashTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = PrepareProcessedAfterOriginatorCrashTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.clustering().hash().numOwners(1);
        this.createClusteredCaches(2, dcc);
    }

    public void testBelatedTransactionDoesntLeak() throws Throwable {
        final ControlledCommandFactory ccf = ControlledCommandFactory.registerControlledCommandFactory(this.advancedCache(1), PrepareCommand.class);
        ccf.gate.close();
        Cache receiver = this.cache(1);
        BlockingPrepareInterceptor interceptor = new BlockingPrepareInterceptor();
        this.advancedCache(1).addInterceptor((CommandInterceptor)interceptor, 1);
        final Object key = this.getKeyForCache(1);
        this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    PrepareProcessedAfterOriginatorCrashTest.this.cache(0).put(key, (Object)"v");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return ccf.blockTypeCommandsReceived.get() == 1;
            }
        });
        this.killMember(0);
        Thread.sleep(5000L);
        ccf.gate.open();
        interceptor.prepareExecuted.await();
        this.log.trace((Object)"Finished waiting for belated prepare to complete");
        TransactionTable transactionTable = TestingUtil.getTransactionTable(receiver);
        AssertJUnit.assertEquals((int)0, (int)transactionTable.getRemoteTxCount());
        AssertJUnit.assertEquals((int)0, (int)transactionTable.getLocalTxCount());
        AssertJUnit.assertFalse((boolean)receiver.getAdvancedCache().getLockManager().isLocked(key));
    }

    private static class BlockingPrepareInterceptor
    extends CommandInterceptor {
        public final CountDownLatch prepareExecuted = new CountDownLatch(1);

        private BlockingPrepareInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            try {
                this.getLog().trace((Object)"Processing belated prepare");
                Object object = super.visitPrepareCommand(ctx, command);
                return object;
            }
            finally {
                this.prepareExecuted.countDown();
            }
        }
    }
}

