/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CountingRpcManager
implements RpcManager {
    private static final Log log = LogFactory.getLog(CountingRpcManager.class);
    public volatile int lockCount;
    public volatile int clusterGet;
    public volatile int otherCount;
    protected final RpcManager realOne;

    public static CountingRpcManager replaceRpcManager(Cache c) {
        AdvancedCache advancedCache = c.getAdvancedCache();
        CountingRpcManager crm = new CountingRpcManager(advancedCache.getRpcManager());
        advancedCache.getComponentRegistry().registerComponent((Object)crm, RpcManager.class);
        advancedCache.getComponentRegistry().rewire();
        assert (advancedCache.getRpcManager().equals(crm));
        return crm;
    }

    public CountingRpcManager(RpcManager realOne) {
        this.realOne = realOne;
    }

    protected void aboutToInvokeRpc(ReplicableCommand rpcCommand) {
        System.out.println("rpcCommand = " + rpcCommand);
        if (rpcCommand instanceof LockControlCommand) {
            ++this.lockCount;
        } else if (rpcCommand instanceof ClusteredGetCommand) {
            ++this.clusterGet;
        } else {
            ++this.otherCount;
        }
    }

    public void resetStats() {
        this.lockCount = 0;
        this.clusterGet = 0;
        this.otherCount = 0;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) {
        log.trace((Object)"invokeRemotely1");
        this.aboutToInvokeRpc(rpcCommand);
        return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue) {
        log.trace((Object)"invokeRemotely2");
        this.aboutToInvokeRpc(rpcCommand);
        return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout) {
        log.trace((Object)"invokeRemotely3");
        this.aboutToInvokeRpc(rpcCommand);
        return this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout);
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync) throws RpcException {
        log.trace((Object)"invokeRemotely4");
        this.aboutToInvokeRpc(rpc);
        this.realOne.invokeRemotely(recipients, rpc, sync);
        return null;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
        log.trace((Object)"invokeRemotely5");
        this.aboutToInvokeRpc(rpc);
        Map responses = this.realOne.invokeRemotely(recipients, rpc, sync, usePriorityQueue);
        return responses;
    }

    public void broadcastRpcCommand(ReplicableCommand rpc, boolean sync) throws RpcException {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommand1");
        this.aboutToInvokeRpc(rpc);
        this.realOne.broadcastRpcCommand(rpc, sync);
    }

    public void broadcastRpcCommand(ReplicableCommand rpc, boolean sync, boolean usePriorityQueue) throws RpcException {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommand2");
        this.aboutToInvokeRpc(rpc);
        this.realOne.broadcastRpcCommand(rpc, sync, usePriorityQueue);
    }

    public void broadcastRpcCommandInFuture(ReplicableCommand rpc, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture1");
        this.aboutToInvokeRpc(rpc);
        this.realOne.broadcastRpcCommandInFuture(rpc, future);
    }

    public void broadcastRpcCommandInFuture(ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture2");
        this.aboutToInvokeRpc(rpc);
        this.realOne.broadcastRpcCommandInFuture(rpc, usePriorityQueue, future);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture1");
        this.aboutToInvokeRpc(rpc);
        this.realOne.invokeRemotelyInFuture(recipients, rpc, future);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture2");
        this.aboutToInvokeRpc(rpc);
        this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture3");
        this.aboutToInvokeRpc(rpc);
        this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future, timeout);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpc, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout, boolean ignoreLeavers) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture4");
        this.aboutToInvokeRpc(rpc);
        this.realOne.invokeRemotelyInFuture(recipients, rpc, usePriorityQueue, future, timeout, ignoreLeavers);
    }

    public Transport getTransport() {
        return this.realOne.getTransport();
    }

    public Address getAddress() {
        return this.realOne.getAddress();
    }

    public int getTopologyId() {
        return this.realOne.getTopologyId();
    }

    public List<Address> getMembers() {
        return this.realOne.getMembers();
    }
}

