/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.concurrent.locks.DeadlockDetectedException;
import org.infinispan.util.concurrent.locks.DeadlockDetectingLockManager;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="util.DeadlockDetectingLockManagerTest")
public class DeadlockDetectingLockManagerTest
extends AbstractInfinispanTest {
    DeadlockDetectingLockManagerMock lockManager;
    Configuration config = new ConfigurationBuilder().build();
    private LockContainer lc;
    private static final int SPIN_DURATION = 1000;
    private DldGlobalTransaction lockOwner;

    @BeforeMethod
    public void setUp() {
        this.lc = (LockContainer)Mockito.mock(LockContainer.class);
        this.lockManager = new DeadlockDetectingLockManagerMock(1000L, true, this.lc, this.config);
        this.lockOwner = (DldGlobalTransaction)TransactionFactory.TxFactoryEnum.DLD_NORECOVERY_XA.newGlobalTransaction();
    }

    public void testNoTransaction() throws Exception {
        NonTxInvocationContext nonTx = new NonTxInvocationContext();
        Lock mockLock = (Lock)Mockito.mock(Lock.class);
        Mockito.when((Object)this.lc.acquireLock(nonTx.getLockOwner(), (Object)"k", this.config.locking().lockAcquisitionTimeout(), TimeUnit.MILLISECONDS)).thenReturn((Object)mockLock).thenReturn(null);
        assert (this.lockManager.lockAndRecord("k", (InvocationContext)nonTx, this.config.locking().lockAcquisitionTimeout()));
        assert (!this.lockManager.lockAndRecord("k", (InvocationContext)nonTx, this.config.locking().lockAcquisitionTimeout()));
    }

    public void testLockHeldByThread() throws Exception {
        InvocationContext localTxContext = this.buildLocalTxIc(new DldGlobalTransaction());
        Lock mockLock = (Lock)Mockito.mock(Lock.class);
        Mockito.when((Object)this.lc.acquireLock(localTxContext.getLockOwner(), (Object)"k", 1000L, TimeUnit.MILLISECONDS)).thenReturn(null).thenReturn((Object)mockLock);
        this.lockManager.setOwner(Thread.currentThread());
        assert (this.lockManager.lockAndRecord("k", localTxContext, this.config.locking().lockAcquisitionTimeout()));
        assert (this.lockManager.getOverlapWithNotDeadlockAwareLockOwners() == 1L);
    }

    public void testLocalDeadlock() throws Exception {
        DldGlobalTransaction ddgt = (DldGlobalTransaction)TransactionFactory.TxFactoryEnum.DLD_NORECOVERY_XA.newGlobalTransaction();
        InvocationContext localTxContext = this.buildLocalTxIc(ddgt);
        ddgt.setCoinToss(0L);
        this.lockOwner.setCoinToss(1L);
        assert (ddgt.wouldLose(this.lockOwner));
        Lock mockLock = (Lock)Mockito.mock(Lock.class);
        Mockito.when((Object)this.lc.acquireLock(localTxContext.getLockOwner(), (Object)"k", 1000L, TimeUnit.MILLISECONDS)).thenReturn(null).thenReturn((Object)mockLock);
        this.lockOwner.setRemote(false);
        this.lockOwner.setLockIntention((Object)"k");
        this.lockManager.setOwner(this.lockOwner);
        this.lockManager.setOwnsLock(true);
        try {
            this.lockManager.lockAndRecord("k", localTxContext, this.config.locking().lockAcquisitionTimeout());
            assert (false);
        }
        catch (DeadlockDetectedException e) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.lockManager.getDetectedLocalDeadlocks());
    }

    private InvocationContext buildLocalTxIc(final DldGlobalTransaction ddgt) {
        LocalTxInvocationContext localTxContext = new LocalTxInvocationContext(){

            public Object getLockOwner() {
                return ddgt;
            }
        };
        return localTxContext;
    }

    public static class DeadlockDetectingLockManagerMock
    extends DeadlockDetectingLockManager {
        private Object owner;
        private boolean ownsLock;

        public DeadlockDetectingLockManagerMock(long spinDuration, boolean exposeJmxStats, LockContainer lockContainer, Configuration configuration) {
            this.spinDuration = spinDuration;
            this.exposeJmxStats = exposeJmxStats;
            this.lockContainer = lockContainer;
            this.configuration = configuration;
        }

        public void setOwner(Object owner) {
            this.owner = owner;
        }

        public void setOwnsLock(boolean ownsLock) {
            this.ownsLock = ownsLock;
        }

        public Object getOwner(Object key) {
            return this.owner;
        }

        public boolean ownsLock(Object key, Object owner) {
            return this.ownsLock;
        }
    }
}

