/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.BackupSenderImpl;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.XSiteAdminOperations;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.admin.XSiteAdminOperationsTest")
public class XSiteAdminOperationsTest
extends AbstractTwoSitesTest {
    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return XSiteAdminOperationsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return XSiteAdminOperationsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
    }

    public void testSiteStatus() {
        AssertJUnit.assertEquals((String)this.admin("LON", 0).siteStatus("NYC"), (String)"online");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).siteStatus("NYC"), (String)"online");
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON", 1).takeSiteOffline("NYC"));
        AssertJUnit.assertEquals((String)this.admin("LON", 0).siteStatus("NYC"), (String)"offline");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).siteStatus("NYC"), (String)"offline");
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON", 1).bringSiteOnline("NYC"));
        AssertJUnit.assertEquals((String)this.admin("LON", 0).siteStatus("NYC"), (String)"online");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).siteStatus("NYC"), (String)"online");
    }

    public void amendTakeOffline() {
        AssertJUnit.assertEquals((String)this.admin("LON", 0).siteStatus("NYC"), (String)"online");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).siteStatus("NYC"), (String)"online");
        BackupSenderImpl bs = this.backupSender("LON", 0);
        OfflineStatus offlineStatus = bs.getOfflineStatus("NYC");
        AssertJUnit.assertEquals((Object)offlineStatus.getTakeOffline(), (Object)new TakeOfflineConfiguration(0, 0L));
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON", 1).amendTakeOffline("NYC", 7, 12L));
        AssertJUnit.assertEquals((Object)offlineStatus.getTakeOffline(), (Object)new TakeOfflineConfiguration(7, 12L));
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON", 1).setTakeOfflineAfterFailures("NYC", 8));
        AssertJUnit.assertEquals((Object)offlineStatus.getTakeOffline(), (Object)new TakeOfflineConfiguration(8, 12L));
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON", 1).setTakeOfflineMinTimeToWait("NYC", 13L));
        AssertJUnit.assertEquals((Object)offlineStatus.getTakeOffline(), (Object)new TakeOfflineConfiguration(8, 13L));
        AssertJUnit.assertEquals((String)this.admin("LON", 0).getTakeOfflineAfterFailures("NYC"), (String)"8");
        AssertJUnit.assertEquals((String)this.admin("LON", 0).getTakeOfflineMinTimeToWait("NYC"), (String)"13");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).getTakeOfflineAfterFailures("NYC"), (String)"8");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).getTakeOfflineMinTimeToWait("NYC"), (String)"13");
    }

    public void testStatus() {
        AssertJUnit.assertEquals((String)this.admin("LON", 0).status(), (String)"NYC[ONLINE]");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).status(), (String)"NYC[ONLINE]");
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON", 1).takeSiteOffline("NYC"));
        AssertJUnit.assertEquals((String)this.admin("LON", 0).status(), (String)"NYC[OFFLINE]");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).status(), (String)"NYC[OFFLINE]");
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON", 1).bringSiteOnline("NYC"));
        AssertJUnit.assertEquals((String)this.admin("LON", 0).status(), (String)"NYC[ONLINE]");
        AssertJUnit.assertEquals((String)this.admin("LON", 1).status(), (String)"NYC[ONLINE]");
    }

    private BackupSenderImpl backupSender(String site, int cache) {
        return (BackupSenderImpl)this.cache(site, cache).getAdvancedCache().getComponentRegistry().getComponent(BackupSender.class);
    }

    private XSiteAdminOperations admin(String site, int cache) {
        return (XSiteAdminOperations)this.cache(site, cache).getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
    }
}

