/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.security.auth.login.AppConfigurationEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.auth.container.config.AuthModuleEntry;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.login.LoginModuleStackHolder;
import org.jboss.security.config.Attribute;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.Element;
import org.jboss.security.config.parser.AuthenticationConfigParser;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;

public class AuthenticationJASPIConfigParser
implements XMLStreamConstants {
    public JASPIAuthenticationInfo parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        JASPIAuthenticationInfo authInfo = new JASPIAuthenticationInfo();
        HashMap<String, LoginModuleStackHolder> holders = new HashMap<String, LoginModuleStackHolder>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            String peekedStartElementName = StaxParserUtil.getStartElementName(peekedStartElement);
            if ("login-module-stack".equals(peekedStartElementName)) {
                StartElement lmshEvent = (StartElement)xmlEventReader.nextEvent();
                javax.xml.stream.events.Attribute nameAttribute = lmshEvent.getAttributes().next();
                String nameAttributeValue = StaxParserUtil.getAttributeValue(nameAttribute);
                LoginModuleStackHolder holder = new LoginModuleStackHolder(nameAttributeValue, null);
                holders.put(nameAttributeValue, holder);
                authInfo.add(holder);
                while ("login-module".equals(peekedStartElementName = StaxParserUtil.getStartElementName(peekedStartElement = (StartElement)(xmlEvent = xmlEventReader.peek())))) {
                    holder.addAppConfigurationEntry(this.getJAASEntry(xmlEventReader));
                }
                continue;
            }
            if (!"auth-module".equals(peekedStartElementName)) break;
            AuthModuleEntry entry = this.getJaspiEntry(xmlEventReader);
            String stackHolderRefName = entry.getLoginModuleStackHolderName();
            if (stackHolderRefName != null) {
                if (!holders.containsKey(stackHolderRefName)) {
                    throw new RuntimeException("PB00016: Wrong Type:auth-module references a login module stack that doesn't exist: " + stackHolderRefName);
                }
                entry.setLoginModuleStackHolder((LoginModuleStackHolder)holders.get(stackHolderRefName));
            }
            authInfo.add(entry);
        }
        return authInfo;
    }

    private AppConfigurationEntry getJAASEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        StartElement loginModuleElement = (StartElement)xmlEvent;
        Iterator<javax.xml.stream.events.Attribute> attrs = loginModuleElement.getAttributes();
        while (attrs.hasNext()) {
            javax.xml.stream.events.Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"flag".equals(attQName.getLocalPart())) continue;
            controlFlag = this.getControlFlag(attributeValue);
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        return new AppConfigurationEntry(codeName, controlFlag, options);
    }

    private AuthModuleEntry getJaspiEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        String loginModuleStackRef = null;
        ControlFlag flag = ControlFlag.REQUIRED;
        StartElement authModuleElement = (StartElement)xmlEvent;
        Iterator<javax.xml.stream.events.Attribute> attrs = authModuleElement.getAttributes();
        while (attrs.hasNext()) {
            javax.xml.stream.events.Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if ("flag".equals(attQName.getLocalPart())) {
                flag = ControlFlag.valueOf((String)attributeValue);
                continue;
            }
            if (!"login-module-stack-ref".equals(attQName.getLocalPart())) continue;
            loginModuleStackRef = attributeValue;
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        AuthModuleEntry entry = new AuthModuleEntry(codeName, options, loginModuleStackRef);
        entry.setControlFlag(flag);
        return entry;
    }

    private AppConfigurationEntry.LoginModuleControlFlag getControlFlag(String flag) {
        if ("required".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if ("sufficient".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if ("optional".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if ("requisite".equalsIgnoreCase(flag)) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        throw new RuntimeException("PB00016: Wrong Type:" + flag + " is not recognized");
    }

    public JASPIAuthenticationInfo parse(XMLStreamReader reader) throws XMLStreamException {
        JASPIAuthenticationInfo authInfo = new JASPIAuthenticationInfo();
        HashMap<String, LoginModuleStackHolder> holders = new HashMap<String, LoginModuleStackHolder>();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGIN_MODULE_STACK: {
                    int count = reader.getAttributeCount();
                    if (count < 1) {
                        throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.NAME));
                    }
                    LoginModuleStackHolder holder = null;
                    block8: for (int i = 0; i < count; ++i) {
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                String name = value;
                                holder = new LoginModuleStackHolder(name, null);
                                holders.put(name, holder);
                                authInfo.add(holder);
                                continue block8;
                            }
                            default: {
                                throw StaxParserUtil.unexpectedAttribute(reader, i);
                            }
                        }
                    }
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        Element element2 = Element.forName(reader.getLocalName());
                        if (!element2.equals((Object)Element.LOGIN_MODULE)) continue;
                        holder.addAppConfigurationEntry(this.getJAASEntry(reader));
                    }
                    continue block7;
                }
                case AUTH_MODULE: {
                    AuthModuleEntry entry = this.getJaspiEntry(reader);
                    String stackHolderRefName = entry.getLoginModuleStackHolderName();
                    if (stackHolderRefName != null) {
                        if (!holders.containsKey(stackHolderRefName)) {
                            throw new RuntimeException("PB00016: Wrong Type:auth-module references a login module stack that doesn't exist: " + stackHolderRefName);
                        }
                        entry.setLoginModuleStackHolder((LoginModuleStackHolder)holders.get(stackHolderRefName));
                    }
                    authInfo.add(entry);
                    continue block7;
                }
            }
            throw StaxParserUtil.unexpectedElement(reader);
        }
        return authInfo;
    }

    private AppConfigurationEntry getJAASEntry(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        int count = reader.getAttributeCount();
        if (count < 2) {
            HashSet<Attribute> set = new HashSet<Attribute>();
            set.add(Attribute.CODE);
            set.add(Attribute.FLAG);
            throw StaxParserUtil.missingRequired(reader, set);
        }
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    if (AuthenticationConfigParser.loginModulesMap.containsKey(value)) {
                        codeName = AuthenticationConfigParser.loginModulesMap.get(value);
                        continue block4;
                    }
                    codeName = value;
                    continue block4;
                }
                case FLAG: {
                    controlFlag = this.getControlFlag(value);
                    continue block4;
                }
                default: {
                    throw StaxParserUtil.unexpectedAttribute(reader, i);
                }
            }
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(reader));
        return new AppConfigurationEntry(codeName, controlFlag, options);
    }

    private AuthModuleEntry getJaspiEntry(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        String loginModuleStackRef = null;
        ControlFlag flag = ControlFlag.REQUIRED;
        int count = reader.getAttributeCount();
        if (count == 0) {
            throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.CODE));
        }
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CODE: {
                    codeName = value;
                    continue block5;
                }
                case FLAG: {
                    flag = ControlFlag.valueOf((String)value);
                    continue block5;
                }
                case LOGIN_MODULE_STACK_REF: {
                    loginModuleStackRef = value;
                    continue block5;
                }
                default: {
                    throw StaxParserUtil.unexpectedAttribute(reader, i);
                }
            }
        }
        if (codeName == null) {
            throw StaxParserUtil.missingRequired(reader, Collections.singleton(Attribute.CODE));
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(reader));
        AuthModuleEntry entry = new AuthModuleEntry(codeName, options, loginModuleStackRef);
        entry.setControlFlag(flag);
        return entry;
    }
}

