/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.impl.ServerVersion;
import org.apache.chemistry.opencmis.server.impl.atompub.AclService;
import org.apache.chemistry.opencmis.server.impl.atompub.DiscoveryService;
import org.apache.chemistry.opencmis.server.impl.atompub.MultiFilingService;
import org.apache.chemistry.opencmis.server.impl.atompub.NavigationService;
import org.apache.chemistry.opencmis.server.impl.atompub.ObjectService;
import org.apache.chemistry.opencmis.server.impl.atompub.PolicyService;
import org.apache.chemistry.opencmis.server.impl.atompub.RelationshipService;
import org.apache.chemistry.opencmis.server.impl.atompub.RepositoryService;
import org.apache.chemistry.opencmis.server.impl.atompub.VersioningService;
import org.apache.chemistry.opencmis.server.shared.CallContextHandler;
import org.apache.chemistry.opencmis.server.shared.Dispatcher;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.QueryStringHttpServletRequestWrapper;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisAtomPubServlet
extends HttpServlet {
    public static final String PARAM_CALL_CONTEXT_HANDLER = "callContextHandler";
    public static final String PARAM_CMIS_VERSION = "cmisVersion";
    private static final Logger LOG = LoggerFactory.getLogger((String)CmisAtomPubServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private CmisVersion cmisVersion;
    private File tempDir;
    private int memoryThreshold;
    private long maxContentSize;
    private boolean encrypt;
    private Dispatcher dispatcher;
    private CallContextHandler callContextHandler;

    public void init(ServletConfig config) throws ServletException {
        String cmisVersionStr;
        super.init(config);
        this.callContextHandler = null;
        String callContextHandlerClass = config.getInitParameter(PARAM_CALL_CONTEXT_HANDLER);
        if (callContextHandlerClass != null) {
            try {
                this.callContextHandler = (CallContextHandler)Class.forName(callContextHandlerClass).newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Could not load call context handler: " + e, (Throwable)e);
            }
        }
        if ((cmisVersionStr = config.getInitParameter(PARAM_CMIS_VERSION)) != null) {
            try {
                this.cmisVersion = CmisVersion.fromValue((String)cmisVersionStr);
                this.cmisVersion = CmisVersion.CMIS_1_0;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("CMIS version is invalid! Setting it to CMIS 1.0.");
                this.cmisVersion = CmisVersion.CMIS_1_0;
            }
        } else {
            LOG.warn("CMIS version is not defined! Setting it to CMIS 1.0.");
            this.cmisVersion = CmisVersion.CMIS_1_0;
        }
        CmisServiceFactory factory = (CmisServiceFactory)config.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory");
        if (factory == null) {
            throw new CmisRuntimeException("Service factory not available! Configuration problem?");
        }
        this.tempDir = factory.getTempDirectory();
        this.memoryThreshold = factory.getMemoryThreshold();
        this.maxContentSize = factory.getMaxContentSize();
        this.encrypt = factory.encryptTempFiles();
        this.dispatcher = new Dispatcher();
        try {
            this.dispatcher.addResource("types", "GET", RepositoryService.class, "getTypeChildren");
            this.dispatcher.addResource("typedesc", "GET", RepositoryService.class, "getTypeDescendants");
            this.dispatcher.addResource("type", "GET", RepositoryService.class, "getTypeDefinition");
            this.dispatcher.addResource("children", "GET", NavigationService.class, "getChildren");
            this.dispatcher.addResource("descendants", "GET", NavigationService.class, "getDescendants");
            this.dispatcher.addResource("foldertree", "GET", NavigationService.class, "getFolderTree");
            this.dispatcher.addResource("parents", "GET", NavigationService.class, "getObjectParents");
            this.dispatcher.addResource("checkedout", "GET", NavigationService.class, "getCheckedOutDocs");
            this.dispatcher.addResource("entry", "GET", ObjectService.class, "getObject");
            this.dispatcher.addResource("id", "GET", ObjectService.class, "getObject");
            this.dispatcher.addResource("path", "GET", ObjectService.class, "getObjectByPath");
            this.dispatcher.addResource("allowableactions", "GET", ObjectService.class, "getAllowableActions");
            this.dispatcher.addResource("content", "GET", ObjectService.class, "getContentStream");
            this.dispatcher.addResource("content", "PUT", ObjectService.class, "setContentStream");
            this.dispatcher.addResource("content", "DELETE", ObjectService.class, "deleteContentStream");
            this.dispatcher.addResource("children", "POST", ObjectService.class, "create");
            this.dispatcher.addResource("relationships", "POST", ObjectService.class, "createRelationship");
            this.dispatcher.addResource("entry", "PUT", ObjectService.class, "updateProperties");
            this.dispatcher.addResource("entry", "DELETE", ObjectService.class, "deleteObject");
            this.dispatcher.addResource("children", "DELETE", ObjectService.class, "deleteTree");
            this.dispatcher.addResource("descendants", "DELETE", ObjectService.class, "deleteTree");
            this.dispatcher.addResource("foldertree", "DELETE", ObjectService.class, "deleteTree");
            this.dispatcher.addResource("checkedout", "POST", VersioningService.class, "checkOut");
            this.dispatcher.addResource("versions", "GET", VersioningService.class, "getAllVersions");
            this.dispatcher.addResource("versions", "DELETE", VersioningService.class, "deleteAllVersions");
            this.dispatcher.addResource("query", "GET", DiscoveryService.class, "query");
            this.dispatcher.addResource("query", "POST", DiscoveryService.class, "query");
            this.dispatcher.addResource("changes", "GET", DiscoveryService.class, "getContentChanges");
            this.dispatcher.addResource("relationships", "GET", RelationshipService.class, "getObjectRelationships");
            this.dispatcher.addResource("unfiled", "POST", MultiFilingService.class, "removeObjectFromFolder");
            this.dispatcher.addResource("acl", "GET", AclService.class, "getAcl");
            this.dispatcher.addResource("acl", "PUT", AclService.class, "applyAcl");
            this.dispatcher.addResource("policies", "GET", PolicyService.class, "getAppliedPolicies");
            this.dispatcher.addResource("policies", "POST", PolicyService.class, "applyPolicy");
            this.dispatcher.addResource("policies", "DELETE", PolicyService.class, "removePolicy");
        }
        catch (NoSuchMethodException e) {
            LOG.error("Cannot initialize dispatcher!", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        QueryStringHttpServletRequestWrapper qsRequest = new QueryStringHttpServletRequestWrapper(request);
        response.addHeader("Cache-Control", "private, max-age=0");
        response.addHeader("Server", ServerVersion.OPENCMIS_SERVER);
        CallContext context = null;
        try {
            context = HttpUtils.createContext((HttpServletRequest)qsRequest, response, this.getServletContext(), "atompub", this.cmisVersion, this.callContextHandler, this.tempDir, this.memoryThreshold, this.maxContentSize, this.encrypt);
            this.dispatch(context, (HttpServletRequest)qsRequest, response);
        }
        catch (Exception e) {
            if (e instanceof CmisPermissionDeniedException) {
                if (context == null || context.getUsername() == null) {
                    response.setHeader("WWW-Authenticate", "Basic realm=\"CMIS\"");
                    response.sendError(401, "Authorization Required");
                } else {
                    response.sendError(CmisAtomPubServlet.getErrorCode((CmisBaseException)((CmisPermissionDeniedException)e)), e.getMessage());
                }
            }
            CmisAtomPubServlet.printError(e, response);
        }
        response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(CallContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CmisService service = null;
        try {
            String repositoryId;
            CmisServiceFactory factory = (CmisServiceFactory)this.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory");
            if (factory == null) {
                throw new CmisRuntimeException("Service factory not available! Configuration problem?");
            }
            service = factory.getService(context);
            String[] pathFragments = HttpUtils.splitPath(request);
            if (pathFragments.length < 2) {
                RepositoryService.getRepositories(context, service, request, response);
                return;
            }
            String resource = pathFragments[1];
            String method = request.getMethod();
            boolean methodFound = this.dispatcher.dispatch(resource, method, context, service, repositoryId = pathFragments[0], request, response);
            if (!methodFound) {
                response.sendError(405, "Unknown operation");
            }
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    private static int getErrorCode(CmisBaseException ex) {
        if (ex instanceof CmisConstraintException) {
            return 409;
        }
        if (ex instanceof CmisContentAlreadyExistsException) {
            return 409;
        }
        if (ex instanceof CmisFilterNotValidException) {
            return 400;
        }
        if (ex instanceof CmisInvalidArgumentException) {
            return 400;
        }
        if (ex instanceof CmisNameConstraintViolationException) {
            return 409;
        }
        if (ex instanceof CmisNotSupportedException) {
            return 405;
        }
        if (ex instanceof CmisObjectNotFoundException) {
            return 404;
        }
        if (ex instanceof CmisPermissionDeniedException) {
            return 403;
        }
        if (ex instanceof CmisStorageException) {
            return 500;
        }
        if (ex instanceof CmisStreamNotSupportedException) {
            return 403;
        }
        if (ex instanceof CmisUpdateConflictException) {
            return 409;
        }
        if (ex instanceof CmisVersioningException) {
            return 409;
        }
        return 500;
    }

    private static void printError(Exception ex, HttpServletResponse response) {
        int statusCode = 500;
        String exceptionName = "runtime";
        if (ex instanceof CmisRuntimeException) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        } else if (ex instanceof CmisBaseException) {
            statusCode = CmisAtomPubServlet.getErrorCode((CmisBaseException)ex);
            exceptionName = ((CmisBaseException)ex).getExceptionName();
        } else {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            PrintWriter pw = response.getWriter();
            response.setStatus(statusCode);
            response.setContentType("text/html");
            pw.print("<html><head><title>Apache Chemistry OpenCMIS - " + exceptionName + " error</title>" + "<style><!--H1 {font-size:24px;line-height:normal;font-weight:bold;background-color:#f0f0f0;color:#003366;border-bottom:1px solid #3c78b5;padding:2px;} " + "BODY {font-family:Verdana,arial,sans-serif;color:black;font-size:14px;} " + "HR {color:#3c78b5;height:1px;}--></style></head><body>");
            pw.print("<h1>HTTP Status " + statusCode + " - <!--exception-->" + exceptionName + "<!--/exception--></h1>");
            pw.print("<p><!--message-->" + StringEscapeUtils.escapeHtml((String)ex.getMessage()) + "<!--/message--></p>");
            String st = ExceptionHelper.getStacktraceAsString(ex);
            if (st != null) {
                pw.print("<hr noshade='noshade'/><!--stacktrace--><pre>\n" + st + "\n</pre><!--/stacktrace--><hr noshade='noshade'/>");
            }
            pw.print("</body></html>");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                response.sendError(statusCode, ex.getMessage());
            }
            catch (Exception en) {
                // empty catch block
            }
        }
    }
}

