/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.RenditionInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public final class NavigationService {
    private NavigationService() {
    }

    public static void getChildren(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger skipCount;
        BigInteger maxItems;
        Boolean includePathSegment;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String orderBy;
        String filter;
        String folderId = HttpUtils.getStringParameter(request, "id");
        ObjectInFolderList children = service.getChildren(repositoryId, folderId, filter = HttpUtils.getStringParameter(request, "filter"), orderBy = HttpUtils.getStringParameter(request, "orderBy"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment"), maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount"), null);
        if (children == null) {
            throw new CmisRuntimeException("Children are null!");
        }
        ObjectInfo folderInfo = service.getObjectInfo(repositoryId, folderId);
        if (folderInfo == null) {
            throw new CmisRuntimeException("Folder Object Info is missing!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, children.getNumItems());
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, "children", folderInfo.getId()), null);
        feed.writeDescribedByLink(AtomPubUtils.compileUrl(baseUrl, "type", folderInfo.getTypeId()));
        feed.writeAllowableActionsLink(AtomPubUtils.compileUrl(baseUrl, "allowableactions", folderInfo.getId()));
        feed.writeDownLink(AtomPubUtils.compileUrl(baseUrl, "children", folderInfo.getId()), "application/atom+xml;type=feed");
        if (folderInfo.supportsDescendants()) {
            feed.writeDownLink(AtomPubUtils.compileUrl(baseUrl, "descendants", folderInfo.getId()), "application/cmistree+xml");
        }
        if (folderInfo.supportsFolderTree()) {
            feed.writeFolderTreeLink(AtomPubUtils.compileUrl(baseUrl, "foldertree", folderInfo.getId()));
        }
        if (folderInfo.hasParent()) {
            feed.writeUpLink(AtomPubUtils.compileUrl(baseUrl, "parents", folderInfo.getId()), "application/atom+xml;type=feed");
        }
        if (folderInfo.getRenditionInfos() != null) {
            for (RenditionInfo ri : folderInfo.getRenditionInfos()) {
                feed.writeAlternateLink(AtomPubUtils.compileUrl(baseUrl, "content", ri.getId()), ri.getContenType(), ri.getKind(), ri.getTitle(), ri.getLength());
            }
        }
        if (folderInfo.hasAcl()) {
            feed.writeAclLink(AtomPubUtils.compileUrl(baseUrl, "acl", folderInfo.getId()));
        }
        if (folderInfo.supportsPolicies()) {
            feed.writeAclLink(AtomPubUtils.compileUrl(baseUrl, "policies", folderInfo.getId()));
        }
        if (folderInfo.supportsRelationships()) {
            feed.writeRelationshipsLink(AtomPubUtils.compileUrl(baseUrl, "relationships", folderInfo.getId()));
        }
        UrlBuilder pagingUrl = new UrlBuilder(AtomPubUtils.compileUrlBuilder(baseUrl, "children", folderInfo.getId()));
        pagingUrl.addParameter("filter", (Object)filter);
        pagingUrl.addParameter("orderBy", (Object)orderBy);
        pagingUrl.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        pagingUrl.addParameter("includeRelationships", (Object)includeRelationships);
        pagingUrl.addParameter("renditionFilter", (Object)renditionFilter);
        pagingUrl.addParameter("includePathSegment", (Object)includePathSegment);
        feed.writePagingLinks(pagingUrl, maxItems, skipCount, children.getNumItems(), children.hasMoreItems(), AtomPubUtils.PAGE_SIZE);
        feed.writeCollection(AtomPubUtils.compileUrl(baseUrl, "children", folderInfo.getId()), null, "Folder collection", "application/cmisatom+xml");
        if (children.getObjects() != null) {
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectInFolderData object : children.getObjects()) {
                if (object == null || object.getObject() == null) continue;
                AtomPubUtils.writeObjectEntry(service, entry, object.getObject(), null, repositoryId, object.getPathSegment(), null, baseUrl, false);
            }
        }
        feed.endFeed();
        feed.endDocument();
    }

    public static void getDescendants(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includePathSegment;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String filter;
        BigInteger depth;
        String folderId = HttpUtils.getStringParameter(request, "id");
        List descendants = service.getDescendants(repositoryId, folderId, depth = HttpUtils.getBigIntegerParameter(request, "depth"), filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment"), null);
        if (descendants == null) {
            throw new CmisRuntimeException("Descendants are null!");
        }
        ObjectInfo folderInfo = service.getObjectInfo(repositoryId, folderId);
        if (folderInfo == null) {
            throw new CmisRuntimeException("Folder Object Info is missing!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, null);
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, "descendants", folderInfo.getId()), null);
        feed.writeViaLink(AtomPubUtils.compileUrl(baseUrl, "entry", folderInfo.getId()));
        feed.writeDownLink(AtomPubUtils.compileUrl(baseUrl, "children", folderInfo.getId()), "application/atom+xml;type=feed");
        if (folderInfo.supportsFolderTree()) {
            feed.writeFolderTreeLink(AtomPubUtils.compileUrl(baseUrl, "foldertree", folderInfo.getId()));
        }
        if (folderInfo.hasParent()) {
            feed.writeUpLink(AtomPubUtils.compileUrl(baseUrl, "parents", folderInfo.getId()), "application/atom+xml;type=feed");
        }
        AtomEntry entry = new AtomEntry(feed.getWriter());
        for (ObjectInFolderContainer container : descendants) {
            if (container == null || container.getObject() == null || container.getObject().getObject() == null) continue;
            AtomPubUtils.writeObjectEntry(service, entry, container.getObject().getObject(), container.getChildren(), repositoryId, container.getObject().getPathSegment(), null, baseUrl, false);
        }
        feed.endFeed();
        feed.endDocument();
    }

    public static void getFolderTree(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includePathSegment;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String filter;
        BigInteger depth;
        String folderId = HttpUtils.getStringParameter(request, "id");
        List folderTree = service.getFolderTree(repositoryId, folderId, depth = HttpUtils.getBigIntegerParameter(request, "depth"), filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includePathSegment = HttpUtils.getBooleanParameter(request, "includePathSegment"), null);
        if (folderTree == null) {
            throw new CmisRuntimeException("Folder tree is null!");
        }
        ObjectInfo folderInfo = service.getObjectInfo(repositoryId, folderId);
        if (folderInfo == null) {
            throw new CmisRuntimeException("Folder Object Info is missing!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, null);
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, "descendants", folderInfo.getId()), null);
        feed.writeViaLink(AtomPubUtils.compileUrl(baseUrl, "entry", folderInfo.getId()));
        feed.writeDownLink(AtomPubUtils.compileUrl(baseUrl, "children", folderInfo.getId()), "application/atom+xml;type=feed");
        if (folderInfo.supportsDescendants()) {
            feed.writeDownLink(AtomPubUtils.compileUrl(baseUrl, "descendants", folderInfo.getId()), "application/cmistree+xml");
        }
        if (folderInfo.hasParent()) {
            feed.writeUpLink(AtomPubUtils.compileUrl(baseUrl, "parents", folderInfo.getId()), "application/atom+xml;type=feed");
        }
        AtomEntry entry = new AtomEntry(feed.getWriter());
        for (ObjectInFolderContainer container : folderTree) {
            if (container == null || container.getObject() == null || container.getObject().getObject() == null) continue;
            AtomPubUtils.writeObjectEntry(service, entry, container.getObject().getObject(), container.getChildren(), repositoryId, container.getObject().getPathSegment(), null, baseUrl, false);
        }
        feed.endFeed();
        feed.endDocument();
    }

    public static void getObjectParents(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includeRelativePathSegment;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String filter;
        String objectId = HttpUtils.getStringParameter(request, "id");
        List parents = service.getObjectParents(repositoryId, objectId, filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), includeRelativePathSegment = HttpUtils.getBooleanParameter(request, "includeRelativePathSegment"), null);
        if (parents == null) {
            throw new CmisRuntimeException("Parents are null!");
        }
        ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
        if (objectInfo == null) {
            throw new CmisRuntimeException("Object Info is missing!");
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        feed.writeFeedElements(objectInfo.getId(), objectInfo.getAtomId(), objectInfo.getCreatedBy(), objectInfo.getName(), objectInfo.getLastModificationDate(), null, null);
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, "parents", objectInfo.getId()), null);
        AtomEntry entry = new AtomEntry(feed.getWriter());
        for (ObjectParentData object : parents) {
            if (object == null || object.getObject() == null) continue;
            AtomPubUtils.writeObjectEntry(service, entry, object.getObject(), null, repositoryId, null, object.getRelativePathSegment(), baseUrl, false);
        }
        feed.endFeed();
        feed.endDocument();
    }

    public static void getCheckedOutDocs(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigInteger skipCount;
        BigInteger maxItems;
        String renditionFilter;
        IncludeRelationships includeRelationships;
        Boolean includeAllowableActions;
        String orderBy;
        String filter;
        String folderId = HttpUtils.getStringParameter(request, "folderId");
        ObjectList checkedOut = service.getCheckedOutDocs(repositoryId, folderId, filter = HttpUtils.getStringParameter(request, "filter"), orderBy = HttpUtils.getStringParameter(request, "orderBy"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), includeRelationships = HttpUtils.getEnumParameter(request, "includeRelationships", IncludeRelationships.class), renditionFilter = HttpUtils.getStringParameter(request, "renditionFilter"), maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems"), skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount"), null);
        if (checkedOut == null) {
            throw new CmisRuntimeException("Checked Out list is null!");
        }
        ObjectInfoImpl folderInfo = null;
        if (folderId != null) {
            folderInfo = service.getObjectInfo(repositoryId, folderId);
            if (folderInfo == null) {
                throw new CmisRuntimeException("Folder Object Info is missing!");
            }
        } else {
            folderInfo = new ObjectInfoImpl();
            GregorianCalendar now = new GregorianCalendar();
            folderInfo.setId("uri:x-checkedout");
            folderInfo.setName("Checked Out");
            folderInfo.setCreatedBy("");
            folderInfo.setCreationDate(now);
            folderInfo.setLastModificationDate(now);
            folderInfo.setHasParent(false);
            folderInfo.setSupportsDescendants(false);
            folderInfo.setSupportsFolderTree(false);
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, checkedOut.getNumItems());
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(AtomPubUtils.compileUrl(baseUrl, "checkedout", folderInfo.getId()), null);
        UrlBuilder pagingUrl = new UrlBuilder(AtomPubUtils.compileUrlBuilder(baseUrl, "checkedout", folderInfo.getId()));
        pagingUrl.addParameter("filter", (Object)filter);
        pagingUrl.addParameter("orderBy", (Object)orderBy);
        pagingUrl.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        pagingUrl.addParameter("includeRelationships", (Object)includeRelationships);
        pagingUrl.addParameter("renditionFilter", (Object)renditionFilter);
        feed.writePagingLinks(pagingUrl, maxItems, skipCount, checkedOut.getNumItems(), checkedOut.hasMoreItems(), AtomPubUtils.PAGE_SIZE);
        if (checkedOut.getObjects() != null) {
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectData object : checkedOut.getObjects()) {
                if (object == null) continue;
                AtomPubUtils.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, false);
            }
        }
        feed.endFeed();
        feed.endDocument();
    }
}

