/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.impl.atompub.ServiceDocument;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public final class RepositoryService {
    private RepositoryService() {
    }

    public static void getRepositories(CallContext context, CmisService service, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String repositoryId = HttpUtils.getStringParameter(request, "repositoryId");
        List<RepositoryInfo> infoDataList = null;
        if (repositoryId == null) {
            infoDataList = service.getRepositoryInfos(null);
        } else {
            infoDataList = Collections.singletonList(service.getRepositoryInfo(repositoryId, null));
            if (context instanceof CallContextImpl) {
                ((CallContextImpl)context).put("repositoryId", repositoryId);
            }
        }
        response.setStatus(200);
        response.setContentType("application/atomsvc+xml");
        ServiceDocument serviceDoc = new ServiceDocument();
        serviceDoc.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        serviceDoc.startServiceDocument();
        if (infoDataList != null) {
            for (RepositoryInfo infoData : infoDataList) {
                if (infoData == null) continue;
                String repId = infoData.getId();
                UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repId);
                boolean supportsQuery = false;
                boolean supportsUnFiling = false;
                boolean supportsMultifiling = false;
                boolean supportsFolderTree = false;
                boolean supportsRootDescendants = false;
                boolean supportsChanges = false;
                if (infoData.getCapabilities() != null) {
                    RepositoryCapabilities cap = infoData.getCapabilities();
                    if (cap.getQueryCapability() != null) {
                        boolean bl = supportsQuery = cap.getQueryCapability() != CapabilityQuery.NONE;
                    }
                    if (cap.isUnfilingSupported() != null) {
                        supportsUnFiling = cap.isUnfilingSupported();
                    }
                    if (cap.isMultifilingSupported() != null) {
                        supportsMultifiling = cap.isMultifilingSupported();
                    }
                    if (cap.isGetFolderTreeSupported() != null) {
                        supportsFolderTree = cap.isGetFolderTreeSupported();
                    }
                    if (cap.isGetDescendantsSupported() != null) {
                        supportsRootDescendants = cap.isGetDescendantsSupported();
                    }
                    if (cap.getChangesCapability() != null) {
                        supportsChanges = cap.getChangesCapability() != CapabilityChanges.NONE;
                    }
                }
                serviceDoc.startWorkspace(infoData.getId());
                serviceDoc.writeCollection(AtomPubUtils.compileUrl(baseUrl, "children", infoData.getRootFolderId()), "root", "Root Collection", "application/atom+xml;type=entry", "application/cmisatom+xml");
                serviceDoc.writeCollection(AtomPubUtils.compileUrl(baseUrl, "types", null), "types", "Types Collection", "");
                if (supportsQuery) {
                    serviceDoc.writeCollection(AtomPubUtils.compileUrl(baseUrl, "query", null), "query", "Query Collection", "application/cmisquery+xml");
                }
                serviceDoc.writeCollection(AtomPubUtils.compileUrl(baseUrl, "checkedout", null), "checkedout", "Checked Out Collection", "application/cmisatom+xml");
                if (supportsUnFiling || supportsMultifiling) {
                    serviceDoc.writeCollection(AtomPubUtils.compileUrl(baseUrl, "unfiled", null), "unfiled", "Unfiled Collection", "application/cmisatom+xml");
                }
                serviceDoc.writeRepositoryInfo(infoData);
                serviceDoc.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/typedescendants", AtomPubUtils.compileUrl(baseUrl, "typedesc", null), "application/atom+xml;type=feed", null);
                if (supportsFolderTree) {
                    serviceDoc.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", AtomPubUtils.compileUrl(baseUrl, "foldertree", infoData.getRootFolderId()), "application/cmistree+xml", null);
                }
                if (supportsRootDescendants) {
                    serviceDoc.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/rootdescendants", AtomPubUtils.compileUrl(baseUrl, "descendants", infoData.getRootFolderId()), "application/cmistree+xml", infoData.getRootFolderId());
                }
                if (supportsChanges) {
                    serviceDoc.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/changes", AtomPubUtils.compileUrl(baseUrl, "changes", null), "application/atom+xml;type=feed", null);
                }
                String url = AtomPubUtils.compileUrl(baseUrl, "id", null) + "?id={id}&filter={filter}&includeAllowableActions={includeAllowableActions}&includeACL={includeACL}&includePolicyIds={includePolicyIds}&includeRelationships={includeRelationships}&renditionFilter={renditionFilter}";
                serviceDoc.writeUriTemplate(url, "objectbyid", "application/atom+xml;type=entry");
                url = AtomPubUtils.compileUrl(baseUrl, "path", null) + "?path={path}&filter={filter}&includeAllowableActions={includeAllowableActions}&includeACL={includeACL}&includePolicyIds={includePolicyIds}&includeRelationships={includeRelationships}&renditionFilter={renditionFilter}";
                serviceDoc.writeUriTemplate(url, "objectbypath", "application/atom+xml;type=entry");
                url = AtomPubUtils.compileUrl(baseUrl, "type", null) + "?id={id}";
                serviceDoc.writeUriTemplate(url, "typebyid", "application/atom+xml;type=entry");
                if (supportsQuery) {
                    url = AtomPubUtils.compileUrl(baseUrl, "query", null) + "?q={q}&searchAllVersions={searchAllVersions}&includeAllowableActions={includeAllowableActions}&includeRelationships={includeRelationships}&maxItems={maxItems}&skipCount={skipCount}";
                    serviceDoc.writeUriTemplate(url, "query", "application/atom+xml;type=feed");
                }
                serviceDoc.endWorkspace();
            }
        }
        serviceDoc.endServiceDocument();
        serviceDoc.endDocument();
    }

    public static void getTypeChildren(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        boolean includePropertyDefinitions = HttpUtils.getBooleanParameter(request, "includePropertyDefinitions", false);
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        TypeDefinitionList typeList = service.getTypeChildren(repositoryId, typeId, Boolean.valueOf(includePropertyDefinitions), maxItems, skipCount, null);
        BigInteger numItems = typeList == null ? null : typeList.getNumItems();
        Boolean hasMoreItems = typeList == null ? null : typeList.hasMoreItems();
        String parentTypeId = null;
        String typeName = "Type Children";
        if (typeId != null) {
            TypeDefinition typeDefinition = service.getTypeDefinition(repositoryId, typeId, null);
            parentTypeId = typeDefinition == null ? null : typeDefinition.getParentTypeId();
            typeName = typeDefinition == null ? typeId : typeDefinition.getDisplayName();
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        feed.writeFeedElements(typeId, null, "unknown", typeName, new GregorianCalendar(), null, numItems);
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        UrlBuilder selfLink = AtomPubUtils.compileUrlBuilder(baseUrl, "types", null);
        selfLink.addParameter("typeId", (Object)typeId);
        selfLink.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
        feed.writeSelfLink(selfLink.toString(), typeId);
        feed.writeViaLink(AtomPubUtils.compileUrl(baseUrl, "type", typeId));
        UrlBuilder downLink = AtomPubUtils.compileUrlBuilder(baseUrl, "typedesc", null);
        downLink.addParameter("typeId", (Object)typeId);
        feed.writeDownLink(downLink.toString(), "application/cmistree+xml");
        if (parentTypeId != null) {
            feed.writeUpLink(AtomPubUtils.compileUrl(baseUrl, "type", parentTypeId), "application/atom+xml;type=entry");
        }
        UrlBuilder pagingUrl = AtomPubUtils.compileUrlBuilder(baseUrl, "types", null);
        pagingUrl.addParameter("typeId", (Object)typeId);
        pagingUrl.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
        feed.writePagingLinks(pagingUrl, maxItems, skipCount, numItems, hasMoreItems, AtomPubUtils.PAGE_SIZE);
        UrlBuilder collectionUrl = AtomPubUtils.compileUrlBuilder(baseUrl, "types", null);
        collectionUrl.addParameter("typeId", (Object)typeId);
        feed.writeCollection(collectionUrl.toString(), null, "Types Collection", "");
        if (typeList != null && typeList.getList() != null) {
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (TypeDefinition type : typeList.getList()) {
                AtomPubUtils.writeTypeEntry(entry, type, null, repositoryId, baseUrl, false);
            }
        }
        feed.endFeed();
        feed.endDocument();
    }

    public static void getTypeDescendants(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        BigInteger depth = HttpUtils.getBigIntegerParameter(request, "depth");
        boolean includePropertyDefinitions = HttpUtils.getBooleanParameter(request, "includePropertyDefinitions", false);
        List typeTree = service.getTypeDescendants(repositoryId, typeId, depth, Boolean.valueOf(includePropertyDefinitions), null);
        String parentTypeId = null;
        String typeName = "Type Children";
        if (typeId != null) {
            TypeDefinition typeDefinition = service.getTypeDefinition(repositoryId, typeId, null);
            parentTypeId = typeDefinition == null ? null : typeDefinition.getParentTypeId();
            typeName = typeDefinition == null ? typeId : typeDefinition.getDisplayName();
        }
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=feed");
        AtomFeed feed = new AtomFeed();
        feed.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        feed.startFeed(true);
        feed.writeFeedElements(typeId, null, "unknown", typeName, new GregorianCalendar(), null, null);
        UrlBuilder baseUrl = AtomPubUtils.compileBaseUrl(request, repositoryId);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        UrlBuilder selfLink = AtomPubUtils.compileUrlBuilder(baseUrl, "typedesc", null);
        selfLink.addParameter("typeId", (Object)typeId);
        selfLink.addParameter("depth", (Object)depth);
        selfLink.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
        feed.writeSelfLink(selfLink.toString(), typeId);
        feed.writeViaLink(AtomPubUtils.compileUrl(baseUrl, "type", typeId));
        UrlBuilder downLink = AtomPubUtils.compileUrlBuilder(baseUrl, "types", null);
        downLink.addParameter("typeId", (Object)typeId);
        feed.writeDownLink(downLink.toString(), "application/atom+xml;type=feed");
        if (parentTypeId != null) {
            feed.writeUpLink(AtomPubUtils.compileUrl(baseUrl, "type", parentTypeId), "application/atom+xml;type=entry");
        }
        if (typeTree != null) {
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (TypeDefinitionContainer container : typeTree) {
                if (container == null || container.getTypeDefinition() == null) continue;
                AtomPubUtils.writeTypeEntry(entry, container.getTypeDefinition(), container.getChildren(), repositoryId, baseUrl, false);
            }
        }
        feed.endFeed();
        feed.endDocument();
    }

    public static void getTypeDefinition(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeId = HttpUtils.getStringParameter(request, "id");
        TypeDefinition type = service.getTypeDefinition(repositoryId, typeId, null);
        response.setStatus(200);
        response.setContentType("application/atom+xml;type=entry");
        AtomEntry entry = new AtomEntry();
        entry.startDocument((OutputStream)response.getOutputStream(), AtomPubUtils.getNamespaces(service));
        AtomPubUtils.writeTypeEntry(entry, type, null, repositoryId, AtomPubUtils.compileBaseUrl(request, repositoryId), true);
        entry.endDocument();
    }
}

