/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Principal;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlEntryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlPrincipalDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.impl.browser.POSTHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowserBindingUtils {
    public static final String JSON_MIME_TYPE = "application/json";
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String ROOT_PATH_FRAGMENT = "root";
    public static final String CONTEXT_OBJECT_ID = "org.apache.chemistry.opencmis.browserbinding.objectId";
    public static final String CONTEXT_OBJECT_TYPE_ID = "org.apache.chemistry.opencmis.browserbinding.objectTypeId";
    public static final String CONTEXT_BASETYPE_ID = "org.apache.chemistry.opencmis.browserbinding.basetypeId";
    public static final String CONTEXT_TOKEN = "org.apache.chemistry.opencmis.browserbinding.token";

    private BrowserBindingUtils() {
    }

    public static UrlBuilder compileBaseUrl(HttpServletRequest request) {
        String baseUrl = (String)request.getAttribute("org.apache.chemistry.opencmis.baseurl");
        if (baseUrl != null) {
            return new UrlBuilder(baseUrl);
        }
        UrlBuilder url = new UrlBuilder(request.getScheme(), request.getServerName(), request.getServerPort(), null);
        url.addPath(request.getContextPath());
        url.addPath(request.getServletPath());
        return url;
    }

    public static UrlBuilder compileRepositoryUrl(HttpServletRequest request, String repositoryId) {
        return BrowserBindingUtils.compileBaseUrl(request).addPathSegment(repositoryId);
    }

    public static UrlBuilder compileRootUrl(HttpServletRequest request, String repositoryId) {
        return BrowserBindingUtils.compileRepositoryUrl(request, repositoryId).addPathSegment(ROOT_PATH_FRAGMENT);
    }

    public static String getPath(HttpServletRequest request) {
        String[] pathFragments = HttpUtils.splitPath(request);
        if (pathFragments.length < 2) {
            return null;
        }
        if (pathFragments.length == 2) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < pathFragments.length; ++i) {
            if (pathFragments[i].length() == 0) continue;
            sb.append("/");
            sb.append(pathFragments[i]);
        }
        return sb.toString();
    }

    public static void prepareContext(CallContext context, CallUrl callUrl, CmisService service, String repositoryId, String objectId, String token, HttpServletRequest request) {
        CallContextImpl contextImpl = null;
        if (context instanceof CallContextImpl) {
            contextImpl = (CallContextImpl)context;
            contextImpl.put(CONTEXT_TOKEN, token);
        }
        if (callUrl != CallUrl.ROOT) {
            return;
        }
        ObjectData object = null;
        object = objectId != null ? service.getObject(repositoryId, objectId, "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId", Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null) : service.getObjectByPath(repositoryId, BrowserBindingUtils.getPath(request), "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId", Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
        if (contextImpl != null) {
            contextImpl.put(CONTEXT_OBJECT_ID, object.getId());
            contextImpl.put(CONTEXT_OBJECT_TYPE_ID, BrowserBindingUtils.getProperty(object, "cmis:objectTypeId", String.class));
            contextImpl.put(CONTEXT_BASETYPE_ID, BrowserBindingUtils.getProperty(object, "cmis:baseTypeId", String.class));
        }
    }

    public static <T> T getProperty(ObjectData object, String name, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        Properties propData = object.getProperties();
        if (propData == null) {
            return null;
        }
        Map properties = propData.getProperties();
        if (properties == null) {
            return null;
        }
        PropertyData property = (PropertyData)properties.get(name);
        if (property == null) {
            return null;
        }
        Object value = property.getFirstValue();
        if (!clazz.isInstance(value)) {
            return null;
        }
        return (T)value;
    }

    public static Properties createNewProperties(ControlParser controlParser, TypeCache typeCache) {
        List<String> propertyIds = controlParser.getValues("propertyId");
        if (propertyIds == null) {
            return null;
        }
        Map<Integer, String> singleValuePropertyMap = controlParser.getOneDimMap("propertyValue");
        Map<Integer, Map<Integer, String>> multiValuePropertyMap = controlParser.getTwoDimMap("propertyValue");
        int i = 0;
        for (String propertId : propertyIds) {
            TypeDefinition typeDef;
            String typeId;
            if ("cmis:objectTypeId".equals(propertId) && singleValuePropertyMap != null && (typeId = singleValuePropertyMap.get(i)) != null && (typeDef = typeCache.getTypeDefinition(typeId)) == null) {
                throw new CmisInvalidArgumentException("Invalid type: " + typeId);
            }
            if ("cmis:secondaryObjectTypeIds".equals(propertId) && multiValuePropertyMap != null) {
                TypeDefinition typeDef2;
                String value;
                Map<Integer, String> values = multiValuePropertyMap.get(i);
                if (values != null) {
                    for (String secTypeId : values.values()) {
                        TypeDefinition typeDef3 = typeCache.getTypeDefinition(secTypeId);
                        if (typeDef3 != null) continue;
                        throw new CmisInvalidArgumentException("Invalid secondary type: " + secTypeId);
                    }
                } else if (singleValuePropertyMap != null && (value = singleValuePropertyMap.get(i)) != null && (typeDef2 = typeCache.getTypeDefinition(value)) == null) {
                    throw new CmisInvalidArgumentException("Invalid secondary type: " + value);
                }
            }
            ++i;
        }
        PropertiesImpl result = new PropertiesImpl();
        i = 0;
        for (String propertyId : propertyIds) {
            PropertyDefinition propDef = typeCache.getPropertyDefinition(propertyId);
            if (propDef == null) {
                throw new CmisInvalidArgumentException(propertyId + " is unknown!");
            }
            PropertyData<?> propertyData = null;
            propertyData = singleValuePropertyMap != null && singleValuePropertyMap.containsKey(i) ? BrowserBindingUtils.createPropertyData(propDef, singleValuePropertyMap.get(i)) : (multiValuePropertyMap != null && multiValuePropertyMap.containsKey(i) ? BrowserBindingUtils.createPropertyData(propDef, controlParser.getValues("propertyValue", i)) : BrowserBindingUtils.createPropertyData(propDef, null));
            result.addProperty(propertyData);
            ++i;
        }
        return result;
    }

    public static Properties createUpdateProperties(ControlParser controlParser, String typeId, List<String> secondaryTypeIds, List<String> objectIds, TypeCache typeCache) {
        TypeDefinition typeDef;
        List<String> propertyIds = controlParser.getValues("propertyId");
        if (propertyIds == null) {
            return null;
        }
        Map<Integer, String> singleValuePropertyMap = controlParser.getOneDimMap("propertyValue");
        Map<Integer, Map<Integer, String>> multiValuePropertyMap = controlParser.getTwoDimMap("propertyValue");
        if (typeId != null && (typeDef = typeCache.getTypeDefinition(typeId)) == null) {
            throw new CmisInvalidArgumentException("Invalid type: " + typeId);
        }
        if (multiValuePropertyMap != null) {
            int i = 0;
            for (String propertId : propertyIds) {
                if ("cmis:secondaryObjectTypeIds".equals(propertId)) {
                    Map<Integer, String> values = multiValuePropertyMap.get(i);
                    if (values == null) break;
                    for (String secTypeId : values.values()) {
                        TypeDefinition typeDef2 = typeCache.getTypeDefinition(secTypeId);
                        if (typeDef2 != null) continue;
                        throw new CmisInvalidArgumentException("Invalid secondary type: " + secTypeId);
                    }
                    break;
                }
                ++i;
            }
        }
        if (secondaryTypeIds != null) {
            for (String secTypeId : secondaryTypeIds) {
                TypeDefinition typeDef3 = typeCache.getTypeDefinition(secTypeId);
                if (typeDef3 != null) continue;
                throw new CmisInvalidArgumentException("Invalid secondary type: " + secTypeId);
            }
        }
        PropertiesImpl result = new PropertiesImpl();
        int i = 0;
        for (String propertyId : propertyIds) {
            PropertyDefinition propDef = typeCache.getPropertyDefinition(propertyId);
            if (propDef == null && objectIds != null) {
                String objectId;
                TypeDefinition typeDef4;
                Iterator<String> i$ = objectIds.iterator();
                while (i$.hasNext() && (propDef = (PropertyDefinition)(typeDef4 = typeCache.getTypeDefinitionForObject(objectId = i$.next())).getPropertyDefinitions().get(propertyId)) == null) {
                }
            }
            if (propDef == null) {
                throw new CmisInvalidArgumentException(propertyId + " is unknown!");
            }
            PropertyData<?> propertyData = null;
            propertyData = singleValuePropertyMap != null && singleValuePropertyMap.containsKey(i) ? BrowserBindingUtils.createPropertyData(propDef, singleValuePropertyMap.get(i)) : (multiValuePropertyMap != null && multiValuePropertyMap.containsKey(i) ? BrowserBindingUtils.createPropertyData(propDef, controlParser.getValues("propertyValue", i)) : BrowserBindingUtils.createPropertyData(propDef, null));
            result.addProperty(propertyData);
            ++i;
        }
        return result;
    }

    private static PropertyData<?> createPropertyData(PropertyDefinition<?> propDef, Object value) {
        ArrayList<String> strValues;
        if (value == null) {
            strValues = Collections.emptyList();
        } else if (value instanceof String) {
            strValues = new ArrayList<String>();
            strValues.add((String)value);
        } else {
            strValues = (ArrayList<String>)value;
        }
        PropertyStringImpl propertyData = null;
        switch (propDef.getPropertyType()) {
            case STRING: {
                propertyData = new PropertyStringImpl(propDef.getId(), strValues);
                break;
            }
            case ID: {
                propertyData = new PropertyIdImpl(propDef.getId(), strValues);
                break;
            }
            case BOOLEAN: {
                ArrayList<Boolean> boolValues = new ArrayList<Boolean>(strValues.size());
                try {
                    for (String s : strValues) {
                        boolValues.add(Boolean.valueOf(s));
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not a boolean value!");
                }
                propertyData = new PropertyBooleanImpl(propDef.getId(), boolValues);
                break;
            }
            case INTEGER: {
                ArrayList<BigInteger> intValues = new ArrayList<BigInteger>(strValues.size());
                try {
                    for (String s : strValues) {
                        intValues.add(new BigInteger(s));
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an integer value!");
                }
                propertyData = new PropertyIntegerImpl(propDef.getId(), intValues);
                break;
            }
            case DECIMAL: {
                ArrayList<BigDecimal> decValues = new ArrayList<BigDecimal>(strValues.size());
                try {
                    for (String s : strValues) {
                        decValues.add(new BigDecimal(s));
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an integer value!");
                }
                propertyData = new PropertyDecimalImpl(propDef.getId(), decValues);
                break;
            }
            case DATETIME: {
                ArrayList<GregorianCalendar> calValues = new ArrayList<GregorianCalendar>(strValues.size());
                try {
                    for (String s : strValues) {
                        GregorianCalendar cal = new GregorianCalendar();
                        cal.setTimeInMillis(Long.parseLong(s));
                        calValues.add(cal);
                    }
                }
                catch (NumberFormatException e) {
                    throw new CmisInvalidArgumentException(propDef.getId() + " value is not an datetime value!");
                }
                propertyData = new PropertyDateTimeImpl(propDef.getId(), calValues);
                break;
            }
            case HTML: {
                propertyData = new PropertyHtmlImpl(propDef.getId(), strValues);
                break;
            }
            case URI: {
                propertyData = new PropertyUriImpl(propDef.getId(), strValues);
            }
        }
        return propertyData;
    }

    public static List<String> createPolicies(ControlParser controlParser) {
        return controlParser.getValues("policy");
    }

    public static Acl createAddAcl(ControlParser controlParser) {
        List<String> principals = controlParser.getValues("addACEPrincipal");
        if (principals == null) {
            return null;
        }
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        int i = 0;
        for (String principalId : principals) {
            aces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(principalId), controlParser.getValues("addACEPermission", i)));
            ++i;
        }
        return new AccessControlListImpl(aces);
    }

    public static Acl createRemoveAcl(ControlParser controlParser) {
        List<String> principals = controlParser.getValues("removeACEPrincipal");
        if (principals == null) {
            return null;
        }
        ArrayList<AccessControlEntryImpl> aces = new ArrayList<AccessControlEntryImpl>();
        int i = 0;
        for (String principalId : principals) {
            aces.add(new AccessControlEntryImpl((Principal)new AccessControlPrincipalDataImpl(principalId), controlParser.getValues("removeACEPermission", i)));
            ++i;
        }
        return new AccessControlListImpl(aces);
    }

    public static ContentStream createContentStream(HttpServletRequest request) {
        POSTHttpServletRequestWrapper post;
        ContentStreamImpl result = null;
        if (request instanceof POSTHttpServletRequestWrapper && (post = (POSTHttpServletRequestWrapper)request).getStream() != null) {
            result = new ContentStreamImpl(post.getFilename(), post.getSize(), post.getContentType(), post.getStream());
        }
        return result;
    }

    protected static ObjectData getSimpleObject(CmisService service, String repositoryId, String objectId) {
        return service.getObject(repositoryId, objectId, null, Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public static void setStatus(HttpServletRequest request, HttpServletResponse response, int statusCode) {
        if (HttpUtils.getBooleanParameter(request, "suppressResponseCodes", false)) {
            statusCode = 200;
        }
        response.setStatus(statusCode);
    }

    public static String getCookieName(String token) {
        if (token == null || token.length() == 0) {
            return "cmis%";
        }
        return "cmis_" + Base64.encodeBytes((byte[])token.getBytes()).replace('=', '%');
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String token, String value) {
        BrowserBindingUtils.setCookie(request, response, repositoryId, token, value, 3600);
    }

    public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String token) {
        BrowserBindingUtils.setCookie(request, response, repositoryId, token, "", 0);
    }

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String repositoryId, String token, String value, int expiry) {
        if (token != null && token.length() > 0) {
            String cookieValue = value;
            try {
                cookieValue = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            Cookie transactionCookie = new Cookie(BrowserBindingUtils.getCookieName(token), cookieValue);
            transactionCookie.setMaxAge(expiry);
            transactionCookie.setPath(request.getContextPath() + request.getServletPath() + "/" + repositoryId);
            response.addCookie(transactionCookie);
        }
    }

    public static String createCookieValue(int code, String objectId, String ex, String message) {
        JSONObject result = new JSONObject();
        result.put((Object)"code", (Object)code);
        result.put((Object)"objectId", (Object)(objectId == null ? "" : objectId));
        result.put((Object)"exception", (Object)(ex == null ? "" : ex));
        result.put((Object)"message", (Object)(message == null ? "" : message));
        return result.toJSONString();
    }

    public static void writeJSON(JSONStreamAware json, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = HttpUtils.getStringParameter(request, "token");
        if (token != null && "POST".equals(request.getMethod())) {
            response.setContentType(HTML_MIME_TYPE);
            response.setContentLength(0);
        } else {
            response.setContentType(JSON_MIME_TYPE);
            response.setCharacterEncoding("UTF-8");
            String callback = HttpUtils.getStringParameter(request, "callback");
            if (callback != null) {
                if (!callback.matches("[A-Za-z0-9._\\[\\]]*")) {
                    throw new CmisInvalidArgumentException("Invalid callback name!");
                }
                response.getWriter().print(callback + "(");
            }
            json.writeJSONString((Writer)response.getWriter());
            if (callback != null) {
                response.getWriter().print(");");
            }
        }
        response.getWriter().flush();
    }

    public static void writeEmpty(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentLength(0);
        response.setContentType(HTML_MIME_TYPE);
        response.getWriter().flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CallUrl {
        SERVICE,
        REPOSITORY,
        ROOT;

    }
}

