/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.server.impl.ServerVersion;
import org.apache.chemistry.opencmis.server.impl.browser.AclService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.DiscoveryService;
import org.apache.chemistry.opencmis.server.impl.browser.MultiFilingService;
import org.apache.chemistry.opencmis.server.impl.browser.NavigationService;
import org.apache.chemistry.opencmis.server.impl.browser.ObjectService;
import org.apache.chemistry.opencmis.server.impl.browser.POSTHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.impl.browser.PolicyService;
import org.apache.chemistry.opencmis.server.impl.browser.RelationshipService;
import org.apache.chemistry.opencmis.server.impl.browser.RepositoryService;
import org.apache.chemistry.opencmis.server.impl.browser.VersioningService;
import org.apache.chemistry.opencmis.server.impl.browser.token.TokenHandler;
import org.apache.chemistry.opencmis.server.shared.CallContextHandler;
import org.apache.chemistry.opencmis.server.shared.Dispatcher;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.QueryStringHttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisBrowserBindingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_CALL_CONTEXT_HANDLER = "callContextHandler";
    private static final Logger LOG = LoggerFactory.getLogger((String)CmisBrowserBindingServlet.class.getName());
    private File tempDir;
    private int memoryThreshold;
    private long maxContentSize;
    private boolean encrypt;
    private Dispatcher repositoryDispatcher;
    private Dispatcher rootDispatcher;
    private CallContextHandler callContextHandler;

    public void init(ServletConfig config) throws ServletException {
        CmisServiceFactory factory;
        super.init(config);
        this.callContextHandler = null;
        String callContextHandlerClass = config.getInitParameter(PARAM_CALL_CONTEXT_HANDLER);
        if (callContextHandlerClass != null) {
            try {
                this.callContextHandler = (CallContextHandler)Class.forName(callContextHandlerClass).newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Could not load call context handler: " + e, (Throwable)e);
            }
        }
        if ((factory = (CmisServiceFactory)config.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory")) == null) {
            throw new CmisRuntimeException("Service factory not available! Configuration problem?");
        }
        this.tempDir = factory.getTempDirectory();
        this.memoryThreshold = factory.getMemoryThreshold();
        this.maxContentSize = factory.getMaxContentSize();
        this.encrypt = factory.encryptTempFiles();
        this.repositoryDispatcher = new Dispatcher(false);
        this.rootDispatcher = new Dispatcher(false);
        try {
            this.repositoryDispatcher.addResource("repositoryInfo", "GET", RepositoryService.class, "getRepositoryInfo");
            this.repositoryDispatcher.addResource("lastResult", "GET", RepositoryService.class, "getLastResult");
            this.repositoryDispatcher.addResource("typeChildren", "GET", RepositoryService.class, "getTypeChildren");
            this.repositoryDispatcher.addResource("typeDescendants", "GET", RepositoryService.class, "getTypeDescendants");
            this.repositoryDispatcher.addResource("typeDefinition", "GET", RepositoryService.class, "getTypeDefinition");
            this.repositoryDispatcher.addResource("createType", "POST", RepositoryService.class, "createType");
            this.repositoryDispatcher.addResource("updateType", "POST", RepositoryService.class, "updateType");
            this.repositoryDispatcher.addResource("deleteType", "POST", RepositoryService.class, "deleteType");
            this.repositoryDispatcher.addResource("query", "GET", DiscoveryService.class, "query");
            this.repositoryDispatcher.addResource("checkedout", "GET", NavigationService.class, "getCheckedOutDocs");
            this.repositoryDispatcher.addResource("contentChanges", "GET", DiscoveryService.class, "getContentChanges");
            this.repositoryDispatcher.addResource("query", "POST", DiscoveryService.class, "query");
            this.repositoryDispatcher.addResource("createDocument", "POST", ObjectService.class, "createDocument");
            this.repositoryDispatcher.addResource("createDocumentFromSource", "POST", ObjectService.class, "createDocumentFromSource");
            this.repositoryDispatcher.addResource("createPolicy", "POST", ObjectService.class, "createPolicy");
            this.repositoryDispatcher.addResource("createItem", "POST", ObjectService.class, "createItem");
            this.repositoryDispatcher.addResource("createRelationship", "POST", ObjectService.class, "createRelationship");
            this.repositoryDispatcher.addResource("bulkUpdate", "POST", ObjectService.class, "bulkUpdateProperties");
            this.rootDispatcher.addResource("object", "GET", ObjectService.class, "getObject");
            this.rootDispatcher.addResource("properties", "GET", ObjectService.class, "getProperties");
            this.rootDispatcher.addResource("allowableActions", "GET", ObjectService.class, "getAllowableActions");
            this.rootDispatcher.addResource("renditions", "GET", ObjectService.class, "getRenditions");
            this.rootDispatcher.addResource("content", "GET", ObjectService.class, "getContentStream");
            this.rootDispatcher.addResource("children", "GET", NavigationService.class, "getChildren");
            this.rootDispatcher.addResource("descendants", "GET", NavigationService.class, "getDescendants");
            this.rootDispatcher.addResource("folder", "GET", NavigationService.class, "getFolderTree");
            this.rootDispatcher.addResource("parent", "GET", NavigationService.class, "getFolderParent");
            this.rootDispatcher.addResource("parents", "GET", NavigationService.class, "getObjectParents");
            this.rootDispatcher.addResource("versions", "GET", VersioningService.class, "getAllVersions");
            this.rootDispatcher.addResource("relationships", "GET", RelationshipService.class, "getObjectRelationships");
            this.rootDispatcher.addResource("checkedout", "GET", NavigationService.class, "getCheckedOutDocs");
            this.rootDispatcher.addResource("policies", "GET", PolicyService.class, "getAppliedPolicies");
            this.rootDispatcher.addResource("acl", "GET", AclService.class, "getACL");
            this.rootDispatcher.addResource("createDocument", "POST", ObjectService.class, "createDocument");
            this.rootDispatcher.addResource("createDocumentFromSource", "POST", ObjectService.class, "createDocumentFromSource");
            this.rootDispatcher.addResource("createFolder", "POST", ObjectService.class, "createFolder");
            this.rootDispatcher.addResource("createPolicy", "POST", ObjectService.class, "createPolicy");
            this.rootDispatcher.addResource("createItem", "POST", ObjectService.class, "createItem");
            this.rootDispatcher.addResource("update", "POST", ObjectService.class, "updateProperties");
            this.rootDispatcher.addResource("setContent", "POST", ObjectService.class, "setContentStream");
            this.rootDispatcher.addResource("appendContent", "POST", ObjectService.class, "appendContentStream");
            this.rootDispatcher.addResource("deleteContent", "POST", ObjectService.class, "deleteContentStream");
            this.rootDispatcher.addResource("delete", "POST", ObjectService.class, "deleteObject");
            this.rootDispatcher.addResource("deleteTree", "POST", ObjectService.class, "deleteTree");
            this.rootDispatcher.addResource("move", "POST", ObjectService.class, "moveObject");
            this.rootDispatcher.addResource("addObjectToFolder", "POST", MultiFilingService.class, "addObjectToFolder");
            this.rootDispatcher.addResource("removeObjectFromFolder", "POST", MultiFilingService.class, "removeObjectFromFolder");
            this.rootDispatcher.addResource("checkOut", "POST", VersioningService.class, "checkOut");
            this.rootDispatcher.addResource("cancelCheckOut", "POST", VersioningService.class, "cancelCheckOut");
            this.rootDispatcher.addResource("checkIn", "POST", VersioningService.class, "checkIn");
            this.rootDispatcher.addResource("applyPolicy", "POST", PolicyService.class, "applyPolicy");
            this.rootDispatcher.addResource("removePolicy", "POST", PolicyService.class, "removePolicy");
            this.rootDispatcher.addResource("applyACL", "POST", AclService.class, "applyACL");
        }
        catch (NoSuchMethodException e) {
            LOG.error("Cannot initialize dispatcher!", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addHeader("Cache-Control", "private, max-age=0");
        response.addHeader("Server", ServerVersion.OPENCMIS_SERVER);
        CallContext context = null;
        try {
            String method = request.getMethod();
            if ("GET".equals(method)) {
                request = new QueryStringHttpServletRequestWrapper((HttpServletRequest)request);
            } else if ("POST".equals(method)) {
                request = new POSTHttpServletRequestWrapper((HttpServletRequest)request, this.tempDir, this.memoryThreshold, this.maxContentSize, this.encrypt);
            } else {
                throw new CmisNotSupportedException("Unsupported method");
            }
            if (request.getParameter("login") != null && this.callContextHandler instanceof TokenHandler) {
                ((TokenHandler)((Object)this.callContextHandler)).service(this.getServletContext(), (HttpServletRequest)request, response);
                return;
            }
            context = HttpUtils.createContext(request, response, this.getServletContext(), "browser", CmisVersion.CMIS_1_1, this.callContextHandler, this.tempDir, this.memoryThreshold, this.maxContentSize, this.encrypt);
            this.dispatch(context, (HttpServletRequest)request, response);
        }
        catch (Exception e) {
            if (e instanceof CmisPermissionDeniedException) {
                if (context == null || context.getUsername() == null) {
                    response.setHeader("WWW-Authenticate", "Basic realm=\"CMIS\"");
                    response.sendError(401, "Authorization Required");
                } else {
                    CmisBrowserBindingServlet.printError(e, request, response, context);
                }
            }
            CmisBrowserBindingServlet.printError(e, request, response, context);
        }
        response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(CallContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CmisService service = null;
        try {
            CmisServiceFactory factory = (CmisServiceFactory)this.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory");
            if (factory == null) {
                throw new CmisRuntimeException("Service factory not available! Configuration problem?");
            }
            service = factory.getService(context);
            String[] pathFragments = HttpUtils.splitPath(request);
            if (pathFragments.length < 1) {
                RepositoryService.getRepositories(context, service, request, response);
                return;
            }
            BrowserBindingUtils.CallUrl callUrl = null;
            if (pathFragments.length == 1) {
                callUrl = BrowserBindingUtils.CallUrl.REPOSITORY;
            } else if ("root".equals(pathFragments[1])) {
                callUrl = BrowserBindingUtils.CallUrl.ROOT;
            }
            if (callUrl == null) {
                throw new CmisNotSupportedException("Unknown operation");
            }
            String method = request.getMethod();
            String repositoryId = pathFragments[0];
            boolean methodFound = false;
            if ("GET".equals(method)) {
                String selector = HttpUtils.getStringParameter(request, "cmisselector");
                String objectId = HttpUtils.getStringParameter(request, "objectId");
                BrowserBindingUtils.prepareContext(context, callUrl, service, repositoryId, objectId, null, request);
                if (callUrl == BrowserBindingUtils.CallUrl.REPOSITORY) {
                    if (selector == null) {
                        selector = "";
                    }
                    methodFound = this.repositoryDispatcher.dispatch(selector, method, context, service, repositoryId, request, response);
                } else if (callUrl == BrowserBindingUtils.CallUrl.ROOT) {
                    if (selector == null) {
                        try {
                            BaseTypeId basetype = BaseTypeId.fromValue((String)((String)context.get("org.apache.chemistry.opencmis.browserbinding.basetypeId")));
                            switch (basetype) {
                                case CMIS_DOCUMENT: {
                                    selector = "content";
                                    break;
                                }
                                case CMIS_FOLDER: {
                                    selector = "children";
                                    break;
                                }
                                default: {
                                    selector = "object";
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            selector = "object";
                        }
                    }
                    methodFound = this.rootDispatcher.dispatch(selector, method, context, service, repositoryId, request, response);
                }
            } else if ("POST".equals(method)) {
                String cmisaction = HttpUtils.getStringParameter(request, "cmisaction");
                String objectId = HttpUtils.getStringParameter(request, "objectId");
                String token = HttpUtils.getStringParameter(request, "token");
                if (cmisaction == null || cmisaction.length() == 0) {
                    throw new CmisNotSupportedException("Unknown action");
                }
                BrowserBindingUtils.prepareContext(context, callUrl, service, repositoryId, objectId, token, request);
                if (callUrl == BrowserBindingUtils.CallUrl.REPOSITORY) {
                    methodFound = this.repositoryDispatcher.dispatch(cmisaction, method, context, service, repositoryId, request, response);
                } else if (callUrl == BrowserBindingUtils.CallUrl.ROOT) {
                    methodFound = this.rootDispatcher.dispatch(cmisaction, method, context, service, repositoryId, request, response);
                }
            }
            if (!methodFound) {
                throw new CmisNotSupportedException("Unknown operation");
            }
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    private static int getErrorCode(CmisBaseException ex) {
        if (ex instanceof CmisConstraintException) {
            return 409;
        }
        if (ex instanceof CmisContentAlreadyExistsException) {
            return 409;
        }
        if (ex instanceof CmisFilterNotValidException) {
            return 400;
        }
        if (ex instanceof CmisInvalidArgumentException) {
            return 400;
        }
        if (ex instanceof CmisNameConstraintViolationException) {
            return 409;
        }
        if (ex instanceof CmisNotSupportedException) {
            return 405;
        }
        if (ex instanceof CmisObjectNotFoundException) {
            return 404;
        }
        if (ex instanceof CmisPermissionDeniedException) {
            return 403;
        }
        if (ex instanceof CmisStorageException) {
            return 500;
        }
        if (ex instanceof CmisStreamNotSupportedException) {
            return 403;
        }
        if (ex instanceof CmisUpdateConflictException) {
            return 409;
        }
        if (ex instanceof CmisVersioningException) {
            return 409;
        }
        return 500;
    }

    private static void printError(Exception ex, HttpServletRequest request, HttpServletResponse response, CallContext context) {
        String token;
        int statusCode = 500;
        String exceptionName = "runtime";
        if (ex instanceof CmisRuntimeException) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        } else if (ex instanceof CmisBaseException) {
            statusCode = CmisBrowserBindingServlet.getErrorCode((CmisBaseException)ex);
            exceptionName = ((CmisBaseException)ex).getExceptionName();
        } else {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        String string = token = context == null ? null : (String)context.get("org.apache.chemistry.opencmis.browserbinding.token");
        if (token == null) {
            BrowserBindingUtils.setStatus(request, response, statusCode);
            response.setContentType("application/json");
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put((Object)"exception", (Object)exceptionName);
            jsonResponse.put((Object)"message", (Object)ex.getMessage());
            String st = ExceptionHelper.getStacktraceAsString(ex);
            if (st != null) {
                jsonResponse.put((Object)"stacktrace", (Object)st);
            }
            try {
                BrowserBindingUtils.writeJSON((JSONStreamAware)jsonResponse, request, response);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        } else {
            BrowserBindingUtils.setStatus(request, response, 200);
            response.setContentType("text/html");
            response.setContentLength(0);
            if (context != null) {
                BrowserBindingUtils.setCookie(request, response, context.getRepositoryId(), token, BrowserBindingUtils.createCookieValue(statusCode, null, exceptionName, ex.getMessage()));
            }
        }
    }
}

