/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.impl.json.JSONValue;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public final class RepositoryService {
    private RepositoryService() {
    }

    public static void getRepositories(CallContext context, CmisService service, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List infoDataList = service.getRepositoryInfos(null);
        JSONObject result = new JSONObject();
        for (RepositoryInfo ri : infoDataList) {
            String repositoryUrl = BrowserBindingUtils.compileRepositoryUrl(request, ri.getId()).toString();
            String rootUrl = BrowserBindingUtils.compileRootUrl(request, ri.getId()).toString();
            result.put((Object)ri.getId(), (Object)JSONConverter.convert((RepositoryInfo)ri, (String)repositoryUrl, (String)rootUrl));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)result, request, response);
    }

    public static void getRepositoryInfo(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RepositoryInfo ri = service.getRepositoryInfo(repositoryId, null);
        String repositoryUrl = BrowserBindingUtils.compileRepositoryUrl(request, ri.getId()).toString();
        String rootUrl = BrowserBindingUtils.compileRootUrl(request, ri.getId()).toString();
        JSONObject result = new JSONObject();
        result.put((Object)ri.getId(), (Object)JSONConverter.convert((RepositoryInfo)ri, (String)repositoryUrl, (String)rootUrl));
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)result, request, response);
    }

    public static void getLastResult(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String token = HttpUtils.getStringParameter(request, "token");
        String cookieName = BrowserBindingUtils.getCookieName(token);
        String cookieValue = null;
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookieName.equals(cookie.getName())) continue;
                cookieValue = URLDecoder.decode(cookie.getValue(), "UTF-8");
                break;
            }
        }
        try {
            if (cookieValue == null) {
                cookieValue = BrowserBindingUtils.createCookieValue(0, null, "invalidArgument", "Unknown transaction!");
            } else {
                JSONValue.parse(cookieValue);
            }
        }
        catch (Exception pe) {
            cookieValue = BrowserBindingUtils.createCookieValue(0, null, "runtime", "Cookie pasring error!");
        }
        BrowserBindingUtils.deleteCookie(request, response, repositoryId, token);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)((JSONObject)JSONValue.parse((String)cookieValue)), request, response);
    }

    public static void getTypeChildren(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        boolean includePropertyDefinitions = HttpUtils.getBooleanParameter(request, "includePropertyDefinitions", false);
        BigInteger maxItems = HttpUtils.getBigIntegerParameter(request, "maxItems");
        BigInteger skipCount = HttpUtils.getBigIntegerParameter(request, "skipCount");
        TypeDefinitionList typeList = service.getTypeChildren(repositoryId, typeId, Boolean.valueOf(includePropertyDefinitions), maxItems, skipCount, null);
        JSONObject jsonTypeList = JSONConverter.convert((TypeDefinitionList)typeList);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonTypeList, request, response);
    }

    public static void getTypeDescendants(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean includePropertyDefinitions;
        BigInteger depth;
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        List typeTree = service.getTypeDescendants(repositoryId, typeId, depth = HttpUtils.getBigIntegerParameter(request, "depth"), Boolean.valueOf(includePropertyDefinitions = HttpUtils.getBooleanParameter(request, "includePropertyDefinitions", false)), null);
        if (typeTree == null) {
            throw new CmisRuntimeException("Type tree is null!");
        }
        JSONArray jsonTypeTree = new JSONArray();
        for (TypeDefinitionContainer container : typeTree) {
            jsonTypeTree.add((Object)JSONConverter.convert((TypeDefinitionContainer)container));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonTypeTree, request, response);
    }

    public static void getTypeDefinition(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        TypeDefinition type = service.getTypeDefinition(repositoryId, typeId, null);
        JSONObject jsonType = JSONConverter.convert((TypeDefinition)type);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonType, request, response);
    }

    public static void createType(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeStr = HttpUtils.getStringParameter(request, "type");
        if (typeStr == null) {
            throw new CmisInvalidArgumentException("Type definition missing!");
        }
        JSONParser parser = new JSONParser();
        Object typeJson = parser.parse(typeStr);
        if (!(typeJson instanceof Map)) {
            throw new CmisInvalidArgumentException("Invalid type definition!");
        }
        TypeDefinition typeIn = JSONConverter.convertTypeDefinition((Map)((Map)typeJson));
        TypeDefinition typeOut = service.createType(repositoryId, typeIn, null);
        JSONObject jsonType = JSONConverter.convert((TypeDefinition)typeOut);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonType, request, response);
    }

    public static void updateType(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeStr = HttpUtils.getStringParameter(request, "type");
        if (typeStr == null) {
            throw new CmisInvalidArgumentException("Type definition missing!");
        }
        JSONParser parser = new JSONParser();
        Object typeJson = parser.parse(typeStr);
        if (!(typeJson instanceof Map)) {
            throw new CmisInvalidArgumentException("Invalid type definition!");
        }
        TypeDefinition typeIn = JSONConverter.convertTypeDefinition((Map)((Map)typeJson));
        TypeDefinition typeOut = service.updateType(repositoryId, typeIn, null);
        JSONObject jsonType = JSONConverter.convert((TypeDefinition)typeOut);
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonType, request, response);
    }

    public static void deleteType(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String typeId = HttpUtils.getStringParameter(request, "typeId");
        service.deleteType(repositoryId, typeId, null);
        response.setStatus(200);
        BrowserBindingUtils.writeEmpty(request, response);
    }
}

