/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.WSServlet;
import com.sun.xml.ws.transport.http.servlet.WSServletDelegate;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.xml.ws.WebServiceFeature;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisWebServicesServlet
extends WSServlet {
    public static final String PARAM_CMIS_VERSION = "cmisVersion";
    public static final String CMIS_VERSION = "org.apache.chemistry.opencmis.cmisVersion";
    private static final Logger LOG = LoggerFactory.getLogger((String)CmisWebServicesServlet.class.getName());
    private static final long serialVersionUID = 1L;
    private CmisVersion cmisVersion;

    public void init(ServletConfig config) throws ServletException {
        String cmisVersionStr = config.getInitParameter(PARAM_CMIS_VERSION);
        if (cmisVersionStr != null) {
            try {
                this.cmisVersion = CmisVersion.fromValue((String)cmisVersionStr);
                this.cmisVersion = CmisVersion.CMIS_1_0;
            }
            catch (IllegalArgumentException e) {
                LOG.warn("CMIS version is invalid! Setting it to CMIS 1.0.");
                this.cmisVersion = CmisVersion.CMIS_1_0;
            }
        } else {
            LOG.warn("CMIS version is not defined! Setting it to CMIS 1.0.");
            this.cmisVersion = CmisVersion.CMIS_1_0;
        }
        config.getServletContext().setAttribute(CMIS_VERSION, (Object)this.cmisVersion);
        super.init(config);
    }

    protected WSServletDelegate getDelegate(ServletConfig servletConfig) {
        WSServletDelegate delegate = super.getDelegate(servletConfig);
        if (delegate.adapters != null) {
            CmisServiceFactory factory = (CmisServiceFactory)this.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory");
            if (factory == null) {
                throw new CmisRuntimeException("Service factory not available! Configuration problem?");
            }
            for (ServletAdapter adapter : delegate.adapters) {
                WSFeatureList wsfl = adapter.getEndpoint().getBinding().getFeatures();
                for (WebServiceFeature ft : wsfl) {
                    if (!(ft instanceof StreamingAttachmentFeature)) continue;
                    ((StreamingAttachmentFeature)ft).setDir(factory.getTempDirectory().getAbsolutePath());
                    ((StreamingAttachmentFeature)ft).setMemoryThreshold(factory.getMemoryThreshold());
                }
            }
        }
        return delegate;
    }
}

