/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.shared.CallContextHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpUtils {
    private HttpUtils() {
    }

    public static CallContext createContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, String binding, CmisVersion cmisVersion, CallContextHandler callContextHandler, File tempDir, int memoryThreshold, long maxContentSize, boolean encrypt) {
        String acceptLanguage;
        Map<String, String> callContextMap;
        String[] pathFragments = HttpUtils.splitPath(request);
        String repositoryId = null;
        if (pathFragments.length > 0) {
            repositoryId = pathFragments[0];
        }
        CallContextImpl context = new CallContextImpl(binding, repositoryId, "atompub".equals(binding));
        if (callContextHandler != null && (callContextMap = callContextHandler.getCallContextMap(request)) != null) {
            for (Map.Entry<String, String> e : callContextMap.entrySet()) {
                context.put(e.getKey(), e.getValue());
            }
        }
        context.put("servletContext", servletContext);
        context.put("httpServletRequest", request);
        context.put("httpServletResponse", response);
        context.put("cmisVersion", cmisVersion);
        context.put("tempDir", tempDir);
        context.put("memoryThreshold", memoryThreshold);
        context.put("maxContentSize", maxContentSize);
        context.put("encryptTempFiles", encrypt);
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader != null && (rangeHeader = rangeHeader.trim().toLowerCase(Locale.ENGLISH)).length() > 6 && rangeHeader.startsWith("bytes=") && rangeHeader.indexOf(44) == -1 && rangeHeader.charAt(6) != '-') {
            BigInteger offset = null;
            BigInteger length = null;
            int ds = rangeHeader.indexOf(45);
            if (ds > 6) {
                try {
                    String firstBytePosStr = rangeHeader.substring(6, ds);
                    if (firstBytePosStr.length() > 0) {
                        offset = new BigInteger(firstBytePosStr);
                    }
                    if (!rangeHeader.endsWith("-")) {
                        String lastBytePosStr = rangeHeader.substring(ds + 1);
                        length = offset == null ? new BigInteger(lastBytePosStr).add(BigInteger.ONE) : new BigInteger(lastBytePosStr).subtract(offset).add(BigInteger.ONE);
                    }
                    if (offset != null) {
                        context.put("offset", offset);
                    }
                    if (length != null) {
                        context.put("length", length);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if ((acceptLanguage = request.getHeader("Accept-Language")) != null) {
            String[] locale = acceptLanguage.split("-");
            context.put("language", locale[0].trim());
            if (locale.length > 1) {
                int x = locale[1].indexOf(44);
                if (x == -1) {
                    context.put("country", locale[1].trim());
                } else {
                    context.put("country", locale[1].substring(0, x).trim());
                }
            }
        }
        return context;
    }

    public static String[] splitPath(HttpServletRequest request) {
        int prefixLength = request.getContextPath().length() + request.getServletPath().length();
        String p = request.getRequestURI().substring(prefixLength);
        if (p.length() == 0) {
            return new String[0];
        }
        String[] result = p.substring(1).split("/");
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = URLDecoder.decode(result[i], "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getStringParameter(HttpServletRequest request, String name) {
        if (name == null) {
            return null;
        }
        Map parameters = request.getParameterMap();
        for (Map.Entry parameter : parameters.entrySet()) {
            if (!name.equalsIgnoreCase((String)parameter.getKey())) continue;
            if (parameter.getValue() == null) {
                return null;
            }
            return ((String[])parameter.getValue())[0];
        }
        return null;
    }

    public static boolean getBooleanParameter(HttpServletRequest request, String name, boolean def) {
        String value = HttpUtils.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return def;
        }
        return Boolean.valueOf(value);
    }

    public static Boolean getBooleanParameter(HttpServletRequest request, String name) {
        String value = HttpUtils.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public static BigInteger getBigIntegerParameter(HttpServletRequest request, String name, long def) {
        BigInteger result = HttpUtils.getBigIntegerParameter(request, name);
        if (result == null) {
            result = BigInteger.valueOf(def);
        }
        return result;
    }

    public static BigInteger getBigIntegerParameter(HttpServletRequest request, String name) {
        String value = HttpUtils.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new BigInteger(value);
        }
        catch (Exception e) {
            throw new CmisInvalidArgumentException("Invalid parameter '" + name + "'!");
        }
    }

    public static <T> T getEnumParameter(HttpServletRequest request, String name, Class<T> clazz) {
        String value = HttpUtils.getStringParameter(request, name);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Method m = clazz.getMethod("fromValue", String.class);
            return (T)m.invoke(null, value);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof IllegalArgumentException) {
                throw new CmisInvalidArgumentException("Invalid parameter '" + name + "'!");
            }
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

