/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.IndexStorage;
import org.modeshape.jboss.service.IndexStorageService;
import org.modeshape.jboss.subsystem.AbstractAddIndexStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddCacheIndexStorage
extends AbstractAddIndexStorage {
    public static final AddCacheIndexStorage INSTANCE = new AddCacheIndexStorage();
    private String cacheContainerName = null;

    private AddCacheIndexStorage() {
    }

    @Override
    protected void writeIndexStorageConfiguration(OperationContext context, ModelNode storage, EditableDocument indexStorage, String repositoryName) throws OperationFailedException {
        indexStorage.set("type", (Object)"infinispan");
        this.cacheContainerName = ModelAttributes.INDEX_STORAGE_CACHE_CONTAINER.resolveModelAttribute(context, storage).asString();
        indexStorage.set("cacheConfiguration", (Object)this.cacheContainerJNDIBinding(this.cacheContainerName));
        int chunkSize = ModelAttributes.CHUNK_SIZE.resolveModelAttribute(context, storage).asInt();
        indexStorage.set("chunkSizeInBytes", (Object)chunkSize);
        if (storage.hasDefined("lock-cache-name")) {
            String lockCache = ModelAttributes.LOCK_CACHE_NAME.resolveModelAttribute(context, storage).asString();
            indexStorage.set("lockCacheName", (Object)lockCache);
        }
        if (storage.hasDefined("data-cache-name")) {
            String dataCache = ModelAttributes.DATA_CACHE_NAME.resolveModelAttribute(context, storage).asString();
            indexStorage.set("dataCacheName", (Object)dataCache);
        }
        if (storage.hasDefined("metadata-cache-name")) {
            String metaCache = ModelAttributes.METADATA_CACHE_NAME.resolveModelAttribute(context, storage).asString();
            indexStorage.set("metadataCacheName", (Object)metaCache);
        }
    }

    @Override
    protected void addControllersAndDependencies(String repositoryName, IndexStorageService service, List<ServiceController<?>> newControllers, ServiceBuilder<IndexStorage> builder, ServiceTarget target) {
        builder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", this.cacheContainerName}), CacheContainer.class, service.getCacheContainerInjectedValue());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddCacheIndexStorage.populate(operation, model, "cache-index-storage", ModelAttributes.CACHE_INDEX_STORAGE_ATTRIBUTES);
    }

    private String cacheContainerJNDIBinding(String cacheContainerName) {
        return "java:jboss/infinispan/container/" + cacheContainerName;
    }
}

