/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.AbstractModeShapeRemoveStepHandler;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

class RemoveIndexStorage
extends AbstractModeShapeRemoveStepHandler {
    static final RemoveIndexStorage INSTANCE = new RemoveIndexStorage();

    private RemoveIndexStorage() {
    }

    @Override
    List<ServiceName> servicesToRemove(ModelNode operation, ModelNode model) {
        String repositoryName = this.repositoryName(operation);
        ArrayList<ServiceName> servicesToRemove = new ArrayList<ServiceName>();
        servicesToRemove.add(ModeShapeServiceNames.indexStorageServiceName(repositoryName));
        if (model.has("relative-to") && model.get("relative-to").asString().contains("jboss.server.data.dir")) {
            servicesToRemove.add(ModeShapeServiceNames.indexStorageDirectoryServiceName(repositoryName));
        }
        if (model.has("source-relative-to") && model.get("source-relative-to").asString().contains("jboss.server.data.dir")) {
            servicesToRemove.add(ModeShapeServiceNames.indexSourceStorageDirectoryServiceName(repositoryName));
        }
        return servicesToRemove;
    }
}

