/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import org.modeshape.common.text.ParsingException;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.dialect.teiid.StatementParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParsingException;
import org.modeshape.sequencer.ddl.node.AstNode;

final class CreateTriggerParser
extends StatementParser {
    static final String[] FOR_EACH_ROW = new String[]{TeiidDdlConstants.TeiidReservedWord.FOR.toDdl(), TeiidDdlConstants.TeiidReservedWord.EACH.toDdl(), TeiidDdlConstants.TeiidReservedWord.ROW.toDdl()};
    static final String[] INSTEAD_OF = new String[]{TeiidDdlConstants.TeiidNonReservedWord.INSTEAD.toDdl(), TeiidDdlConstants.TeiidReservedWord.OF.toDdl()};

    CreateTriggerParser(TeiidDdlParser teiidDdlParser) {
        super(teiidDdlParser);
    }

    @Override
    boolean matches(DdlTokenStream tokens) {
        return tokens.matches(TeiidDdlConstants.DdlStatement.CREATE_TRIGGER.tokens());
    }

    @Override
    AstNode parse(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        if (tokens.canConsume(TeiidDdlConstants.DdlStatement.CREATE_TRIGGER.tokens())) {
            String tableRefName = this.parseIdentifier(tokens);
            if (tokens.canConsume(INSTEAD_OF) && (tokens.matches("INSERT") || tokens.matches("UPDATE") || tokens.matches("DELETE"))) {
                String triggerType = tokens.consume();
                if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.AS.toDdl())) {
                    AstNode triggerNode = this.getNodeFactory().node(tableRefName, parentNode, "teiidddl:createTrigger");
                    triggerNode.setProperty("teiidddl:insteadOf", (Object)triggerType);
                    AstNode tableRefNode = this.getNode(parentNode, tableRefName, "teiidddl:createTable", "teiidddl:createView");
                    if (tableRefNode == null) {
                        this.logger.debug("Create trigger statement table reference '{0}' node not found", new Object[]{tableRefName});
                    } else {
                        triggerNode.setProperty("teiidddl:tableRef", (Object)tableRefNode);
                    }
                    if (tokens.canConsume(FOR_EACH_ROW)) {
                        boolean error = false;
                        boolean beginBlock = tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.BEGIN.toDdl());
                        boolean atomic = beginBlock ? tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.ATOMIC.toDdl()) : true;
                        triggerNode.setProperty("teiidddl:atomic", (Object)atomic);
                        String rowAction = this.parseUntilTerminatorIgnoreEmbeddedStatements(tokens).trim();
                        AstNode rowActionNode = this.getNodeFactory().node("rowAction", triggerNode, "teiidddl:triggerRowAction");
                        if (!tokens.canConsume(";")) {
                            throw new TeiidDdlParsingException(tokens, "Unexpected create trigger statement");
                        }
                        rowActionNode.setProperty("teiidddl:action", (Object)(rowAction + ';'));
                        if (beginBlock && !tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.END.toDdl())) {
                            error = true;
                            while (tokens.hasNext()) {
                                rowAction = this.parseUntilTerminatorIgnoreEmbeddedStatements(tokens).trim();
                                rowActionNode = this.getNodeFactory().node("rowAction", triggerNode, "teiidddl:triggerRowAction");
                                rowActionNode.setProperty("teiidddl:action", (Object)rowAction);
                                if (!tokens.canConsume(";")) {
                                    throw new TeiidDdlParsingException(tokens, "Unexpected create trigger statement");
                                }
                                rowActionNode.setProperty("teiidddl:action", (Object)(rowAction + ';'));
                                if (!tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.END.toDdl())) continue;
                                error = false;
                                break;
                            }
                        }
                        if (!error) {
                            return triggerNode;
                        }
                    }
                }
            }
        }
        throw new TeiidDdlParsingException(tokens, "Unparsable create trigger statement");
    }
}

