/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.query;

import java.util.ArrayList;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.server.support.query.CalendarHelper;
import org.apache.chemistry.opencmis.server.support.query.PredicateWalker;

public abstract class AbstractPredicateWalker
implements PredicateWalker {
    public Boolean walkPredicate(Tree node) {
        switch (node.getType()) {
            case 42: {
                return this.walkNot(node, node.getChild(0));
            }
            case 4: {
                return this.walkAnd(node, node.getChild(0), node.getChild(1));
            }
            case 49: {
                return this.walkOr(node, node.getChild(0), node.getChild(1));
            }
            case 18: {
                return this.walkEquals(node, node.getChild(0), node.getChild(1));
            }
            case 41: {
                return this.walkNotEquals(node, node.getChild(0), node.getChild(1));
            }
            case 23: {
                return this.walkGreaterThan(node, node.getChild(0), node.getChild(1));
            }
            case 24: {
                return this.walkGreaterOrEquals(node, node.getChild(0), node.getChild(1));
            }
            case 39: {
                return this.walkLessThan(node, node.getChild(0), node.getChild(1));
            }
            case 40: {
                return this.walkLessOrEquals(node, node.getChild(0), node.getChild(1));
            }
            case 26: {
                return this.walkIn(node, node.getChild(0), node.getChild(1));
            }
            case 43: {
                return this.walkNotIn(node, node.getChild(0), node.getChild(1));
            }
            case 28: {
                return this.walkInAny(node, node.getChild(0), node.getChild(1));
            }
            case 44: {
                return this.walkNotInAny(node, node.getChild(0), node.getChild(1));
            }
            case 19: {
                return this.walkEqAny(node, node.getChild(0), node.getChild(1));
            }
            case 34: {
                return this.walkIsNull(node, node.getChild(0));
            }
            case 33: {
                return this.walkIsNotNull(node, node.getChild(0));
            }
            case 37: {
                return this.walkLike(node, node.getChild(0), node.getChild(1));
            }
            case 45: {
                return this.walkNotLike(node, node.getChild(0), node.getChild(1));
            }
            case 14: {
                if (node.getChildCount() == 1) {
                    return this.walkContains(node, null, node.getChild(0));
                }
                return this.walkContains(node, node.getChild(0), node.getChild(1));
            }
            case 29: {
                if (node.getChildCount() == 1) {
                    return this.walkInFolder(node, null, node.getChild(0));
                }
                return this.walkInFolder(node, node.getChild(0), node.getChild(1));
            }
            case 31: {
                if (node.getChildCount() == 1) {
                    return this.walkInTree(node, null, node.getChild(0));
                }
                return this.walkInTree(node, node.getChild(0), node.getChild(1));
            }
        }
        return this.walkOtherPredicate(node);
    }

    protected Boolean walkOtherPredicate(Tree node) {
        throw new CmisRuntimeException("Unknown node type: " + node.getType() + " (" + node.getText() + ")");
    }

    public Boolean walkNot(Tree opNode, Tree node) {
        this.walkPredicate(node);
        return false;
    }

    public Boolean walkAnd(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkPredicate(leftNode);
        this.walkPredicate(rightNode);
        return false;
    }

    public Boolean walkOr(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkPredicate(leftNode);
        this.walkPredicate(rightNode);
        return false;
    }

    public Object walkExpr(Tree node) {
        switch (node.getType()) {
            case 10: {
                return this.walkBoolean(node);
            }
            case 47: {
                return this.walkNumber(node);
            }
            case 61: {
                return this.walkString(node);
            }
            case 65: {
                return this.walkTimestamp(node);
            }
            case 30: {
                return this.walkList(node);
            }
            case 12: {
                return this.walkCol(node);
            }
            case 25: {
                return this.walkId(node);
            }
        }
        return this.walkOtherExpr(node);
    }

    public Boolean walkSearchExpr(Tree node) {
        switch (node.getType()) {
            case 9: {
                return this.walkTextAnd(node);
            }
            case 11: {
                return this.walkTextOr(node);
            }
            case 10: {
                return this.walkTextMinus(node);
            }
            case 14: {
                return this.walkTextWord(node);
            }
            case 13: {
                return this.walkTextPhrase(node);
            }
        }
        this.walkOtherExpr(node);
        return null;
    }

    protected Object walkOtherExpr(Tree node) {
        throw new CmisRuntimeException("Unknown node type: " + node.getType() + " (" + node.getText() + ")");
    }

    public Boolean walkEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkNotEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkGreaterThan(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkGreaterOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkLessThan(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkLessOrEquals(Tree opNode, Tree leftNode, Tree rightNode) {
        this.walkExpr(leftNode);
        this.walkExpr(rightNode);
        return false;
    }

    public Boolean walkIn(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    public Boolean walkNotIn(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    public Boolean walkInAny(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    public Boolean walkNotInAny(Tree opNode, Tree colNode, Tree listNode) {
        this.walkExpr(colNode);
        this.walkExpr(listNode);
        return false;
    }

    public Boolean walkEqAny(Tree opNode, Tree literalNode, Tree colNode) {
        this.walkExpr(literalNode);
        this.walkExpr(colNode);
        return false;
    }

    public Boolean walkIsNull(Tree opNode, Tree colNode) {
        this.walkExpr(colNode);
        return false;
    }

    public Boolean walkIsNotNull(Tree opNode, Tree colNode) {
        this.walkExpr(colNode);
        return false;
    }

    public Boolean walkLike(Tree opNode, Tree colNode, Tree stringNode) {
        this.walkExpr(colNode);
        this.walkExpr(stringNode);
        return false;
    }

    public Boolean walkNotLike(Tree opNode, Tree colNode, Tree stringNode) {
        this.walkExpr(colNode);
        this.walkExpr(stringNode);
        return false;
    }

    public Boolean walkContains(Tree opNode, Tree qualNode, Tree queryNode) {
        if (qualNode != null) {
            return this.walkSearchExpr(qualNode);
        }
        return this.walkSearchExpr(queryNode);
    }

    public Boolean walkInFolder(Tree opNode, Tree qualNode, Tree paramNode) {
        if (qualNode != null) {
            this.walkExpr(qualNode);
        }
        this.walkExpr(paramNode);
        return false;
    }

    public Boolean walkInTree(Tree opNode, Tree qualNode, Tree paramNode) {
        if (qualNode != null) {
            this.walkExpr(qualNode);
        }
        this.walkExpr(paramNode);
        return false;
    }

    public Object walkList(Tree node) {
        int n = node.getChildCount();
        ArrayList<Object> res = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            res.add(this.walkExpr(node.getChild(i)));
        }
        return res;
    }

    public Object walkBoolean(Tree node) {
        String s = node.getText();
        return Boolean.valueOf(s);
    }

    public Object walkNumber(Tree node) {
        String s = node.getText();
        if (s.contains(".") || s.contains("e") || s.contains("E")) {
            return Double.valueOf(s);
        }
        return Long.valueOf(s);
    }

    public Object walkString(Tree node) {
        String s = node.getText();
        s = s.substring(1, s.length() - 1);
        s = s.replace("''", "'");
        return s;
    }

    public Object walkTimestamp(Tree node) {
        String s = node.getText();
        s = s.substring(s.indexOf(39) + 1, s.length() - 1);
        return CalendarHelper.fromString(s);
    }

    public Object walkCol(Tree node) {
        return null;
    }

    public Object walkId(Tree node) {
        return null;
    }

    protected Boolean walkTextAnd(Tree node) {
        return null;
    }

    protected Boolean walkTextOr(Tree node) {
        return null;
    }

    protected Boolean walkTextMinus(Tree node) {
        return null;
    }

    protected Boolean walkTextWord(Tree node) {
        return null;
    }

    protected Boolean walkTextPhrase(Tree node) {
        return null;
    }
}

