/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.extractor.tika;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.extractor.tika.TikaTextExtractorTest;
import org.modeshape.jcr.SingleUseAbstractTest;
import org.modeshape.jcr.api.JcrTools;

public class TikaTextExtractorRepositoryTest
extends SingleUseAbstractTest {
    private JcrTools jcrTools = new JcrTools();

    @Test
    public void shouldExtractAndIndexContentFromPlainTextFile() throws Exception {
        this.startRepositoryWithConfiguration(this.getResource("repo-config.json"));
        this.uploadFile("text-file.txt");
        this.assertExtractedTextHasBeenIndexed("select [jcr:path] from [nt:resource] as res where contains(res.*, 'The Quick Red Fox Jumps Over the Lazy Brown Dog')");
    }

    @Test
    @Ignore(value="MODE-1934")
    public void shouldExtractAndIndexContentFromDocFile() throws Exception {
        this.startRepositoryWithConfiguration(this.getResource("repo-config.json"));
        this.uploadFile("modeshape.doc");
        this.assertExtractedTextHasBeenIndexed("select [jcr:path] from [nt:resource] as res where contains(res.*, 'ModeShape supports')");
    }

    @Test
    public void shouldExtractAndIndexContentFromPdfGSFile() throws Exception {
        this.startRepositoryWithConfiguration(this.getResource("repo-config.json"));
        this.uploadFile("modeshape_gs.pdf");
        this.assertExtractedTextHasBeenIndexed("select [jcr:path] from [nt:resource] as res where contains(res.*, 'ModeShape supports')");
    }

    @Test
    @FixFor(value={"MODE-1561"})
    public void shouldNotExtractPastWriteLimit() throws Exception {
        this.startRepositoryWithConfiguration(this.getResource("repo-config-text-extraction-limit.json"));
        int configuredWriteLimit = 100;
        String randomString = TikaTextExtractorTest.randomString(configuredWriteLimit);
        this.jcrTools.uploadFile((Session)this.session, "/testFile", (InputStream)new ByteArrayInputStream(randomString.getBytes()));
        this.session.save();
        String sql = "select [jcr:path] from [nt:base] where contains([nt:base].*, '" + randomString + "')";
        this.jcrTools.printQuery((Session)this.session, sql, 1L, new JcrTools.Variable[0]);
        randomString = TikaTextExtractorTest.randomString(configuredWriteLimit + 1);
        this.jcrTools.uploadFile((Session)this.session, "testFile1", (InputStream)new ByteArrayInputStream(randomString.getBytes()));
        this.session.save();
        sql = "select [jcr:path] from [nt:base] where contains([nt:base].*, '" + randomString + "')";
        this.jcrTools.printQuery((Session)this.session, sql, 0L, new JcrTools.Variable[0]);
    }

    private void assertExtractedTextHasBeenIndexed(String validationQuery) throws RepositoryException {
        Query query = this.jcrSession().getWorkspace().getQueryManager().createQuery(validationQuery, "JCR-SQL2");
        QueryResult result = query.execute();
        Assert.assertEquals((String)"Node with text content not found", (long)1L, (long)result.getNodes().getSize());
    }

    private void uploadFile(String filepath) throws RepositoryException, IOException, InterruptedException {
        this.jcrTools.uploadFile((Session)this.session, "/" + filepath, this.getResource(filepath));
        this.session.save();
        Thread.sleep(500L);
    }

    private InputStream getResource(String path) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
    }
}

