/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc.repeatable_read;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.repeatable_read.WriteSkewTest")
public class WriteSkewTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(WriteSkewTest.class);
    protected TransactionManager tm;
    protected LockManager lockManager;
    protected InvocationContextContainer icc;
    protected EmbeddedCacheManager cacheManager;
    protected volatile Cache<String, String> cache;

    @BeforeTest
    public void setUp() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).locking().lockAcquisitionTimeout(3000L).isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cacheManager = TestCacheManagerFactory.createCacheManager(configurationBuilder);
        configurationBuilder.locking().writeSkewCheck(true).versioning().enable().scheme(VersioningScheme.SIMPLE);
        this.cacheManager.defineConfiguration("writeSkew", configurationBuilder.build());
    }

    @AfterTest(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cacheManager);
        this.cacheManager = null;
        this.cache = null;
        this.lockManager = null;
        this.tm = null;
        this.icc = null;
    }

    private void postStart() {
        this.lockManager = (LockManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(LockManager.class);
        this.icc = (InvocationContextContainer)TestingUtil.extractComponentRegistry(this.cache).getComponent(InvocationContextContainer.class);
        this.tm = (TransactionManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(TransactionManager.class);
    }

    protected void assertNoLocks() {
        LockAssert.assertNoLocks(this.lockManager, this.icc);
    }

    private void setCacheWithWriteSkewCheck() {
        this.cache = this.cacheManager.getCache("writeSkew");
    }

    private void setCacheWithoutWriteSkewCheck() {
        this.cache = this.cacheManager.getCache();
    }

    public void testDontCheckWriteSkew() throws Exception {
        this.setCacheWithoutWriteSkewCheck();
        this.postStart();
        this.doTest(true);
    }

    public void testCheckWriteSkew() throws Exception {
        this.setCacheWithWriteSkewCheck();
        this.postStart();
        this.doTest(false);
    }

    public void testCheckWriteSkewWithMultipleModifications() throws Exception {
        this.setCacheWithWriteSkewCheck();
        this.postStart();
        final AtomicInteger successes = new AtomicInteger();
        final AtomicInteger rollbacks = new AtomicInteger();
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        final CountDownLatch latch3 = new CountDownLatch(1);
        Thread t1 = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    latch1.await();
                    WriteSkewTest.this.tm.begin();
                    try {
                        try {
                            WriteSkewTest.this.cache.get((Object)"k1");
                            WriteSkewTest.this.cache.put((Object)"k1", (Object)"v1");
                            WriteSkewTest.this.cache.put((Object)"k2", (Object)"thread 1");
                        }
                        finally {
                            latch2.countDown();
                        }
                        latch3.await();
                        WriteSkewTest.this.tm.commit();
                        successes.incrementAndGet();
                    }
                    catch (Exception e) {
                        if (e instanceof RollbackException) {
                            rollbacks.incrementAndGet();
                        }
                        if (WriteSkewTest.this.tm.getTransaction() != null) {
                            try {
                                WriteSkewTest.this.tm.rollback();
                            }
                            catch (SystemException e1) {
                                log.error((Object)"Failed to rollback", (Throwable)e1);
                            }
                        }
                        throw e;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, "WriteSkewTest.Thread-1");
        Thread t2 = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    latch2.await();
                    WriteSkewTest.this.tm.begin();
                    try {
                        try {
                            WriteSkewTest.this.cache.get((Object)"k1");
                            WriteSkewTest.this.cache.put((Object)"k1", (Object)"v2");
                            WriteSkewTest.this.cache.put((Object)"k3", (Object)"thread 2");
                            WriteSkewTest.this.tm.commit();
                            successes.incrementAndGet();
                        }
                        finally {
                            latch3.countDown();
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof RollbackException) {
                            rollbacks.incrementAndGet();
                        }
                        if (WriteSkewTest.this.tm.getTransaction() != null) {
                            try {
                                WriteSkewTest.this.tm.rollback();
                            }
                            catch (SystemException e1) {
                                log.error((Object)"Failed to rollback", (Throwable)e1);
                            }
                        }
                        throw e;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, "WriteSkewTest.Thread-2");
        t1.start();
        t2.start();
        latch1.countDown();
        t1.join();
        t2.join();
        log.trace((Object)("successes= " + successes.get()));
        log.trace((Object)("rollbacks= " + rollbacks.get()));
        Assert.assertTrue((boolean)this.cache.containsKey((Object)"k1"));
        Assert.assertEquals((String)"v2", (String)((String)this.cache.get((Object)"k1")));
        Assert.assertEquals((int)1, (int)successes.get());
        Assert.assertEquals((int)1, (int)rollbacks.get());
    }

    public void testDontFailOnImmediateRemoval() throws Exception {
        this.setCacheWithWriteSkewCheck();
        this.postStart();
        this.tm.begin();
        this.cache.put((Object)"testDontOnImmediateRemoval-Key", (Object)"testDontOnImmediateRemoval-Value");
        Assert.assertEquals((String)((String)this.cache.get((Object)"testDontOnImmediateRemoval-Key")), (String)"testDontOnImmediateRemoval-Value");
        this.cache.put((Object)"testDontOnImmediateRemoval-Key", (Object)"testDontOnImmediateRemoval-Value-Second");
        this.cache.remove((Object)"testDontOnImmediateRemoval-Key");
        this.tm.commit();
        Assert.assertFalse((boolean)this.cache.containsKey((Object)"testDontOnImmediateRemoval-Key"));
    }

    public void testDontFailOnImmediateRemovalOfAtomicMaps() throws Exception {
        this.setCacheWithWriteSkewCheck();
        this.postStart();
        String key = "key1";
        String subKey = "subK";
        this.tm.begin();
        FineGrainedAtomicMap fineGrainedAtomicMap = AtomicMapLookup.getFineGrainedAtomicMap(this.cache, (Object)"key1");
        fineGrainedAtomicMap.put((Object)"subK", (Object)"some value");
        fineGrainedAtomicMap = AtomicMapLookup.getFineGrainedAtomicMap(this.cache, (Object)"key1");
        fineGrainedAtomicMap.get((Object)"subK");
        fineGrainedAtomicMap.put((Object)"subK", (Object)"v");
        fineGrainedAtomicMap.put((Object)"subK2", (Object)"v2");
        fineGrainedAtomicMap = AtomicMapLookup.getFineGrainedAtomicMap(this.cache, (Object)"key1");
        Object object = fineGrainedAtomicMap.get((Object)"subK");
        Assert.assertEquals((Object)"v", (Object)object);
        AtomicMapLookup.removeAtomicMap(this.cache, (Object)"key1");
        this.tm.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteSkewWithOnlyPut() throws Exception {
        this.setCacheWithWriteSkewCheck();
        this.postStart();
        this.tm.begin();
        try {
            this.cache.put((Object)"k", (Object)"init");
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.tm.commit();
            } else {
                this.tm.rollback();
            }
        }
        int nbWriters = 10;
        CyclicBarrier barrier = new CyclicBarrier(nbWriters + 1);
        ArrayList<Future> futures = new ArrayList<Future>(nbWriters);
        ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){
            volatile int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                int ii = this.i++;
                return new Thread(r, "EntryWriter-" + ii + ", WriteSkewTest");
            }
        });
        try {
            for (int i = 0; i < nbWriters; ++i) {
                log.debug((Object)"Schedule execution");
                Future future = executorService.submit(new EntryWriter(barrier));
                futures.add(future);
            }
            barrier.await();
            barrier.await();
            log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void doTest(final boolean allowWriteSkew) throws Exception {
        this.cache.put((Object)"k", (Object)"v");
        final HashSet w1exceptions = new HashSet();
        final HashSet w2exceptions = new HashSet();
        final CountDownLatch w1Signal = new CountDownLatch(1);
        final CountDownLatch w2Signal = new CountDownLatch(1);
        final CountDownLatch threadSignal = new CountDownLatch(2);
        Thread w1 = new Thread("Writer-1, WriteSkewTest"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean didCoundDown = false;
                try {
                    WriteSkewTest.this.tm.begin();
                    assert ("v".equals(WriteSkewTest.this.cache.get((Object)"k")));
                    threadSignal.countDown();
                    didCoundDown = true;
                    w1Signal.await();
                    WriteSkewTest.this.cache.put((Object)"k", (Object)"v2");
                    WriteSkewTest.this.tm.commit();
                }
                catch (Exception e) {
                    w1exceptions.add(e);
                }
                finally {
                    if (!didCoundDown) {
                        threadSignal.countDown();
                    }
                }
            }
        };
        Thread w2 = new Thread("Writer-2, WriteSkewTest"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean didCoundDown = false;
                try {
                    WriteSkewTest.this.tm.begin();
                    assert ("v".equals(WriteSkewTest.this.cache.get((Object)"k")));
                    threadSignal.countDown();
                    didCoundDown = true;
                    w2Signal.await();
                    WriteSkewTest.this.cache.put((Object)"k", (Object)"v3");
                    WriteSkewTest.this.tm.commit();
                }
                catch (Exception e) {
                    w2exceptions.add(e);
                    if (!allowWriteSkew) {
                        try {
                            WriteSkewTest.this.tm.rollback();
                        }
                        catch (SystemException systemException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (!didCoundDown) {
                        threadSignal.countDown();
                    }
                }
            }
        };
        w1.start();
        w2.start();
        threadSignal.await();
        w1Signal.countDown();
        w1.join();
        w2Signal.countDown();
        w2.join();
        if (allowWriteSkew) {
            this.throwExceptions(w1exceptions, w2exceptions);
            assert (w2exceptions.isEmpty());
            assert (w1exceptions.isEmpty());
            assert ("v3".equals(this.cache.get((Object)"k"))) : "W2 should have overwritten W1's work!";
            this.assertNoLocks();
        } else {
            HashSet combined = new HashSet(w1exceptions);
            combined.addAll(w2exceptions);
            assert (!combined.isEmpty());
            assert (combined.size() == 1);
            assert (combined.iterator().next() instanceof CacheException);
        }
    }

    private void throwExceptions(Collection<Exception> ... exceptions) throws Exception {
        for (Collection<Exception> ce : exceptions) {
            Iterator<Exception> i$ = ce.iterator();
            if (!i$.hasNext()) continue;
            Exception e = i$.next();
            throw e;
        }
    }

    protected class EntryWriter
    implements Callable<Void> {
        private final CyclicBarrier barrier;

        public EntryWriter(CyclicBarrier barrier) {
            this.barrier = barrier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                log.debug((Object)"Wait for all executions paths to be ready to perform calls");
                this.barrier.await();
                WriteSkewTest.this.tm.begin();
                try {
                    WriteSkewTest.this.cache.put((Object)"k", (Object)"_lockthisplease_");
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected", (Throwable)e);
                    WriteSkewTest.this.tm.setRollbackOnly();
                    throw e;
                }
                finally {
                    if (WriteSkewTest.this.tm.getStatus() == 0) {
                        WriteSkewTest.this.tm.commit();
                    } else {
                        WriteSkewTest.this.tm.rollback();
                    }
                }
                Void void_ = null;
                return void_;
            }
            finally {
                log.debug((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
        }
    }
}

