/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import org.infinispan.atomic.LocalDeltaAwareEvictionTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="atomic.LocalDeltaAwarePassivationTest")
@CleanupAfterMethod
public class LocalDeltaAwarePassivationTest
extends LocalDeltaAwareEvictionTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        configBuilder.eviction().maxEntries(1).strategy(EvictionStrategy.LRU).loaders().passivation(true).addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore());
        this.addClusterEnabledCacheManager(configBuilder);
    }

    @Override
    protected void assertNumberOfEntries(int cacheIndex) throws Exception {
        CacheStore cacheStore = TestingUtil.extractComponent(this.cache(cacheIndex), CacheLoaderManager.class).getCacheStore();
        Assert.assertEquals((long)1L, (long)cacheStore.loadAllKeys(null).size());
        DataContainer dataContainer = this.cache(cacheIndex).getAdvancedCache().getDataContainer();
        Assert.assertEquals((long)1L, (long)dataContainer.size());
    }
}

