/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.List;
import java.util.Properties;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.config.AdvancedExternalizerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.CustomInterceptorConfig;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.QueryableDataContainer;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.executors.DefaultExecutorFactory;
import org.infinispan.executors.DefaultScheduledExecutorFactory;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.jmx.JBossMBeanServerLookup;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.cluster.ClusterCacheLoaderConfig;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.marshall.exts.ArrayListExternalizer;
import org.infinispan.marshall.exts.ReplicableCommandExternalizer;
import org.infinispan.remoting.ReplicationQueueImpl;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.ProgrammaticConfigurationTest")
public class ProgrammaticConfigurationTest
extends AbstractInfinispanTest {
    public void testGlobalConfiguration() {
        GlobalConfiguration gc = new GlobalConfiguration().fluent().transport().clusterName("boo").distributedSyncTimeout(Long.valueOf(999L)).addProperty("configurationFile", "jgroups-tcp.xml").machineId("id").rackId("rack").strictPeerToPeer(Boolean.valueOf(true)).globalJmxStatistics().jmxDomain("org.my.infinispan").allowDuplicateDomains(Boolean.valueOf(true)).cacheManagerName("BooMooCacheManager").mBeanServerLookupClass(JBossMBeanServerLookup.class).withProperties((Properties)new TypedProperties().setProperty("jb", "oss")).addProperty("na", "me").serialization().version("2.2").marshallerClass(VersionAwareMarshaller.class).addAdvancedExternalizer(ReplicableCommandExternalizer.class).addAdvancedExternalizer(999, ArrayListExternalizer.class).asyncListenerExecutor().factory(DefaultExecutorFactory.class).addProperty("maxThreads", "6").addProperty("threadNamePrefix", "AsyncListenerThread2").asyncTransportExecutor().factory(DefaultExecutorFactory.class).withProperties((Properties)new TypedProperties().setProperty("maxThreads", "26").setProperty("threadNamePrefix", "AsyncSerializationThread2")).evictionScheduledExecutor().factory(DefaultScheduledExecutorFactory.class).addProperty("threadNamePrefix", "EvictionThread2").replicationQueueScheduledExecutor().factory(DefaultScheduledExecutorFactory.class).addProperty("threadNamePrefix", "ReplicationQueueThread2").shutdown().hookBehavior(GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER).build();
        Assert.assertEquals((String)"boo", (String)gc.getClusterName());
        Assert.assertEquals((long)999L, (long)gc.getDistributedSyncTimeout());
        Assert.assertEquals((String)"jgroups-tcp.xml", (String)gc.getTransportProperties().getProperty("configurationFile"));
        Assert.assertEquals((String)"rack", (String)gc.getRackId());
        Assert.assertEquals((String)"id", (String)gc.getMachineId());
        assert (gc.isStrictPeerToPeer());
        Assert.assertEquals((String)"org.my.infinispan", (String)gc.getJmxDomain());
        assert (gc.isExposeGlobalJmxStatistics());
        assert (gc.isAllowDuplicateDomains());
        Assert.assertEquals((String)"BooMooCacheManager", (String)gc.getCacheManagerName());
        Assert.assertEquals((String)JBossMBeanServerLookup.class.getName(), (String)gc.getMBeanServerLookup());
        Assert.assertEquals((String)"oss", (String)gc.getMBeanServerProperties().getProperty("jb"));
        Assert.assertEquals((String)"me", (String)gc.getMBeanServerProperties().getProperty("na"));
        Assert.assertEquals((String)"2.2", (String)gc.getMarshallVersionString());
        List exts = gc.getExternalizers();
        Assert.assertEquals((int)2, (int)exts.size());
        Assert.assertEquals((String)ReplicableCommandExternalizer.class.getName(), (String)((AdvancedExternalizerConfig)exts.get(0)).getExternalizerClass());
        Assert.assertEquals((String)ArrayListExternalizer.class.getName(), (String)((AdvancedExternalizerConfig)exts.get(1)).getExternalizerClass());
        assert (999 == ((AdvancedExternalizerConfig)exts.get(1)).getId());
        Assert.assertEquals((String)DefaultExecutorFactory.class.getName(), (String)gc.getAsyncListenerExecutorFactoryClass());
        Properties asyncListenerExecutorProps = gc.getAsyncListenerExecutorProperties();
        Assert.assertEquals((String)"6", (String)asyncListenerExecutorProps.getProperty("maxThreads"));
        Assert.assertEquals((String)"AsyncListenerThread2", (String)asyncListenerExecutorProps.getProperty("threadNamePrefix"));
        Assert.assertEquals((String)DefaultExecutorFactory.class.getName(), (String)gc.getAsyncTransportExecutorFactoryClass());
        Properties asyncTransportExecutorProps = gc.getAsyncTransportExecutorProperties();
        Assert.assertEquals((String)"26", (String)asyncTransportExecutorProps.getProperty("maxThreads"));
        Assert.assertEquals((String)"AsyncSerializationThread2", (String)asyncTransportExecutorProps.getProperty("threadNamePrefix"));
        Assert.assertEquals((String)DefaultScheduledExecutorFactory.class.getName(), (String)gc.getEvictionScheduledExecutorFactoryClass());
        Properties evictionScheduledExecutorProps = gc.getEvictionScheduledExecutorProperties();
        Assert.assertEquals((String)"EvictionThread2", (String)evictionScheduledExecutorProps.getProperty("threadNamePrefix"));
        Assert.assertEquals((String)DefaultScheduledExecutorFactory.class.getName(), (String)gc.getReplicationQueueScheduledExecutorFactoryClass());
        Properties replicationQueueScheduledExecutorProps = gc.getReplicationQueueScheduledExecutorProperties();
        Assert.assertEquals((String)"ReplicationQueueThread2", (String)replicationQueueScheduledExecutorProps.getProperty("threadNamePrefix"));
        assert (GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER == gc.getShutdownHookBehavior());
        gc = new GlobalConfiguration();
        assert (!gc.isExposeGlobalJmxStatistics());
    }

    public void testConfiguration() {
        Configuration c = new Configuration().fluent().locking().concurrencyLevel(Integer.valueOf(1234)).isolationLevel(IsolationLevel.SERIALIZABLE).lockAcquisitionTimeout(Long.valueOf(8888L)).useLockStriping(Boolean.valueOf(false)).writeSkewCheck(Boolean.valueOf(true)).loaders().shared(Boolean.valueOf(true)).passivation(Boolean.valueOf(false)).addCacheLoader(new CacheLoaderConfig[]{new FileCacheStoreConfig().purgeOnStartup(Boolean.valueOf(true)).location("/tmp/2").streamBufferSize(1615).asyncStore().threadPoolSize(Integer.valueOf(14)).flushLockTimeout(Long.valueOf(777L)).shutdownTimeout(Long.valueOf(666L)).fetchPersistentState(Boolean.valueOf(false)).ignoreModifications(Boolean.valueOf(true)).singletonStore().pushStateWhenCoordinator(Boolean.valueOf(true)).pushStateTimeout(Long.valueOf(8989L)).purgeSynchronously(Boolean.valueOf(false))}).addCacheLoader(new CacheLoaderConfig[]{new DummyInMemoryCacheStore.Cfg().debug(true).failKey("fail").purgeOnStartup(false).asyncStore().threadPoolSize(Integer.valueOf(21)).purgeSynchronously(Boolean.valueOf(true))}).addCacheLoader(new CacheLoaderConfig[]{new ClusterCacheLoaderConfig().remoteCallTimeout(7694L)}).preload(Boolean.valueOf(true)).transaction().cacheStopTimeout(Integer.valueOf(1928)).eagerLockSingleNode(Boolean.valueOf(false)).syncCommitPhase(Boolean.valueOf(true)).syncRollbackPhase(Boolean.valueOf(false)).useEagerLocking(Boolean.valueOf(false)).recovery().recoveryInfoCacheName("mmmmmircea").transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).useSynchronization(Boolean.valueOf(true)).deadlockDetection().spinDuration(Long.valueOf(8373L)).customInterceptors().add((CommandInterceptor)new OptimisticLockingInterceptor()).first().add((CommandInterceptor)new TxDistributionInterceptor()).last().add((CommandInterceptor)new CallInterceptor()).atIndex(8).add((CommandInterceptor)new CacheStoreInterceptor()).after(OptimisticLockingInterceptor.class).add((CommandInterceptor)new CacheLoaderInterceptor()).before(CallInterceptor.class).eviction().maxEntries(Integer.valueOf(7676)).strategy(EvictionStrategy.LIRS).threadPolicy(EvictionThreadPolicy.PIGGYBACK).expiration().maxIdle(Long.valueOf(8392L)).lifespan(Long.valueOf(4372L)).wakeUpInterval(Long.valueOf(7585L)).clustering().mode(Configuration.CacheMode.INVALIDATION_ASYNC).async().replQueueClass(ReplicationQueueImpl.class).asyncMarshalling(Boolean.valueOf(false)).replQueueInterval(Long.valueOf(5738L)).replQueueMaxElements(Integer.valueOf(19191)).useReplQueue(Boolean.valueOf(true)).l1().lifespan(Long.valueOf(65738L)).onRehash(Boolean.valueOf(true)).stateRetrieval().alwaysProvideInMemoryState(Boolean.valueOf(false)).fetchInMemoryState(Boolean.valueOf(true)).initialRetryWaitTime(Long.valueOf(8989L)).retryWaitTimeIncreaseFactor(Integer.valueOf(4)).numRetries(Integer.valueOf(8)).logFlushTimeout(Long.valueOf(533L)).maxNonProgressingLogWrites(Integer.valueOf(434)).timeout(Long.valueOf(7383L)).chunkSize(Integer.valueOf(1234)).hash().hashFunctionClass(MurmurHash3.class).consistentHashClass(DefaultConsistentHash.class).numOwners(Integer.valueOf(200)).rehashWait(Long.valueOf(74843L)).rehashRpcTimeout(Long.valueOf(374L)).rehashEnabled(Boolean.valueOf(false)).dataContainer().dataContainerClass(DefaultDataContainer.class).dataContainer((DataContainer)new QueryableDataContainer()).addProperty("a-property", "a-value").indexing().indexLocalOnly(Boolean.valueOf(true)).addProperty("indexing", "in memory").unsafe().unreliableReturnValues(Boolean.valueOf(false)).jmxStatistics().storeAsBinary().invocationBatching().build();
        assert (c.isInvocationBatchingEnabled());
        assert (c.isStoreAsBinary());
        assert (c.isExposeJmxStatistics());
        assert (!c.isUnsafeUnreliableReturnValues());
        assert (c.getDataContainer() instanceof QueryableDataContainer);
        Assert.assertEquals((String)DefaultDataContainer.class.getName(), (String)c.getDataContainerClass());
        Assert.assertEquals((String)"a-value", (String)c.getDataContainerProperties().getProperty("a-property"));
        assert (c.isIndexingEnabled());
        assert (c.isIndexLocalOnly());
        assert (c.getIndexingProperties().getProperty("indexing").equals("in memory"));
        assert (!c.isAlwaysProvideInMemoryState());
        assert (c.isFetchInMemoryState());
        assert (8989L == c.getStateRetrievalInitialRetryWaitTime());
        assert (4 == c.getStateRetrievalRetryWaitTimeIncreaseFactor());
        assert (8 == c.getStateRetrievalNumRetries());
        assert (533L == c.getStateRetrievalLogFlushTimeout());
        assert (434 == c.getStateRetrievalMaxNonProgressingLogWrites());
        assert (7383L == c.getStateRetrievalTimeout());
        assert (1234 == c.getStateRetrievalChunkSize());
        Assert.assertEquals((String)MurmurHash3.class.getName(), (String)c.getHashFunctionClass());
        Assert.assertEquals((String)DefaultConsistentHash.class.getName(), (String)c.getConsistentHashClass());
        assert (200 == c.getNumOwners());
        assert (74843L == c.getRehashWaitTime());
        assert (374L == c.getRehashRpcTimeout());
        assert (!c.isRehashEnabled());
        assert (c.isL1CacheEnabled());
        assert (c.isL1OnRehash());
        assert (65738L == c.getL1Lifespan());
        assert (Configuration.CacheMode.INVALIDATION_ASYNC == c.getCacheMode());
        assert (!c.isUseAsyncMarshalling());
        Assert.assertEquals((String)ReplicationQueueImpl.class.getName(), (String)c.getReplQueueClass());
        assert (5738L == c.getReplQueueInterval());
        assert (19191 == c.getReplQueueMaxElements());
        assert (c.isUseReplQueue());
        assert (4372L == c.getExpirationLifespan());
        assert (8392L == c.getExpirationMaxIdle());
        assert (7676 == c.getEvictionMaxEntries());
        assert (EvictionStrategy.LIRS == c.getEvictionStrategy());
        assert (EvictionThreadPolicy.PIGGYBACK == c.getEvictionThreadPolicy());
        assert (7585L == c.getExpirationWakeUpInterval());
        List customInterceptors = c.getCustomInterceptors();
        assert (((CustomInterceptorConfig)customInterceptors.get(0)).getInterceptor() instanceof OptimisticLockingInterceptor);
        assert (((CustomInterceptorConfig)customInterceptors.get(1)).getInterceptor() instanceof BaseDistributionInterceptor);
        assert (((CustomInterceptorConfig)customInterceptors.get(2)).getInterceptor() instanceof CallInterceptor);
        assert (((CustomInterceptorConfig)customInterceptors.get(3)).getInterceptor() instanceof CacheStoreInterceptor);
        assert (((CustomInterceptorConfig)customInterceptors.get(4)).getInterceptor() instanceof CacheLoaderInterceptor);
        assert (c.isDeadlockDetectionEnabled());
        assert (8373L == c.getDeadlockDetectionSpinDuration());
        assert (1928 == c.getCacheStopTimeout());
        assert (!c.isEagerLockSingleNode());
        assert (c.isSyncCommitPhase());
        assert (!c.isSyncRollbackPhase());
        assert (!c.isUseEagerLocking());
        assert (c.getTransactionManagerLookup() instanceof DummyTransactionManagerLookup);
        assert (c.isTransactionRecoveryEnabled());
        Assert.assertEquals((String)"mmmmmircea", (String)c.getTransactionRecoveryCacheName());
        assert (c.isUseSynchronizationForTransactions());
        ClusterCacheLoaderConfig clusterLoaderConfig = (ClusterCacheLoaderConfig)c.getCacheLoaders().get(2);
        assert (7694L == clusterLoaderConfig.getRemoteCallTimeout());
        DummyInMemoryCacheStore.Cfg dummyStoreConfig = (DummyInMemoryCacheStore.Cfg)((Object)c.getCacheLoaders().get(1));
        assert (dummyStoreConfig.isDebug());
        assert (!dummyStoreConfig.isPurgeOnStartup().booleanValue());
        assert (dummyStoreConfig.isPurgeSynchronously().booleanValue());
        assert (21 == dummyStoreConfig.getAsyncStoreConfig().getThreadPoolSize());
        assert (dummyStoreConfig.isPurgeSynchronously().booleanValue());
        FileCacheStoreConfig storeConfig = (FileCacheStoreConfig)c.getCacheLoaders().get(0);
        Assert.assertEquals((String)"/tmp/2", (String)storeConfig.getLocation());
        assert (1615 == storeConfig.getStreamBufferSize());
        assert (storeConfig.isPurgeOnStartup().booleanValue());
        assert (14 == storeConfig.getAsyncStoreConfig().getThreadPoolSize());
        assert (777L == storeConfig.getAsyncStoreConfig().getFlushLockTimeout());
        assert (666L == storeConfig.getAsyncStoreConfig().getShutdownTimeout());
        assert (!storeConfig.isFetchPersistentState().booleanValue());
        assert (storeConfig.isIgnoreModifications().booleanValue());
        assert (storeConfig.getSingletonStoreConfig().isPushStateWhenCoordinator().booleanValue());
        assert (8989L == storeConfig.getSingletonStoreConfig().getPushStateTimeout());
        assert (!storeConfig.isPurgeSynchronously().booleanValue());
        assert (c.isCacheLoaderShared());
        assert (!c.isCacheLoaderPassivation());
        assert (c.isCacheLoaderPreload());
        assert (!c.isFetchPersistentState());
        assert (1234 == c.getConcurrencyLevel());
        assert (IsolationLevel.SERIALIZABLE == c.getIsolationLevel());
        assert (8888L == c.getLockAcquisitionTimeout());
        assert (!c.isUseLockStriping());
        assert (c.isWriteSkewCheck());
    }
}

