/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.ConfigurationOverrideTest")
public class ConfigurationOverrideTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cm;

    @AfterMethod(alwaysRun=true)
    public void stopCacheManager() {
        this.cm.stop();
    }

    public void testConfigurationOverride() throws Exception {
        ConfigurationBuilder defaultCfgBuilder = new ConfigurationBuilder();
        defaultCfgBuilder.eviction().maxEntries(200).strategy(EvictionStrategy.LIRS);
        this.cm = TestCacheManagerFactory.createCacheManager(defaultCfgBuilder);
        ConfigurationBuilder cacheCfgBuilder = new ConfigurationBuilder().read(defaultCfgBuilder.build());
        this.cm.defineConfiguration("my-cache", cacheCfgBuilder.build());
        Cache cache = this.cm.getCache("my-cache");
        AssertJUnit.assertEquals((int)200, (int)cache.getCacheConfiguration().eviction().maxEntries());
        AssertJUnit.assertEquals((Object)EvictionStrategy.LIRS, (Object)cache.getCacheConfiguration().eviction().strategy());
    }

    public void testOldConfigurationOverride() throws Exception {
        Configuration defaultConfiguration = new Configuration().fluent().eviction().maxEntries(Integer.valueOf(200)).strategy(EvictionStrategy.LIRS).build();
        this.cm = TestCacheManagerFactory.createCacheManager(defaultConfiguration);
        Configuration cacheConfiguration = new Configuration().fluent().build();
        this.cm.defineConfiguration("my-cache", cacheConfiguration);
        Cache cache = this.cm.getCache("my-cache");
        Configuration cfg = cache.getConfiguration();
        AssertJUnit.assertEquals((int)200, (int)cfg.getEvictionMaxEntries());
        AssertJUnit.assertEquals((Object)EvictionStrategy.LIRS, (Object)cfg.getEvictionStrategy());
    }

    public void testSimpleDistributedClusterModeDefault() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(3).numSegments(51);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(builder);
        Cache cache = this.cm.getCache("my-cache");
        ClusteringConfiguration clusteringCfg = cache.getCacheConfiguration().clustering();
        AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)clusteringCfg.cacheMode());
        AssertJUnit.assertEquals((int)3, (int)clusteringCfg.hash().numOwners());
        AssertJUnit.assertEquals((int)51, (int)clusteringCfg.hash().numSegments());
    }

    public void testSimpleDistributedClusterModeNamedCache() throws Exception {
        String cacheName = "my-cache";
        org.infinispan.configuration.cache.Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(3).numSegments(51).build();
        this.cm = TestCacheManagerFactory.createClusteredCacheManager();
        this.cm.defineConfiguration("my-cache", config);
        Cache cache = this.cm.getCache("my-cache");
        ClusteringConfiguration clusteringCfg = cache.getCacheConfiguration().clustering();
        AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)clusteringCfg.cacheMode());
        AssertJUnit.assertEquals((int)3, (int)clusteringCfg.hash().numOwners());
        AssertJUnit.assertEquals((int)51, (int)clusteringCfg.hash().numSegments());
    }
}

