/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.BaseWordCountMapReduceTest")
public abstract class BaseWordCountMapReduceTest
extends MultipleCacheManagersTest {
    protected static HashMap<String, Integer> counts = new HashMap();

    public BaseWordCountMapReduceTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_TEST;
    }

    protected CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }

    protected String cacheName() {
        return "mapreducecache";
    }

    protected MapReduceTask<String, String, String, Integer> createMapReduceTask(Cache c) {
        return new MapReduceTask(c);
    }

    public MapReduceTask<String, String, String, Integer> invokeMapReduce(String[] keys, Mapper<String, String, String, Integer> mapper, Reducer<String, Integer> reducer) throws Exception {
        return this.invokeMapReduce(keys, mapper, reducer, true);
    }

    public MapReduceTask<String, String, String, Integer> invokeMapReduce(String[] keys, Mapper<String, String, String, Integer> mapper, Reducer<String, Integer> reducer, boolean useCombiner) throws Exception {
        Cache c1 = this.cache(0, this.cacheName());
        Cache c2 = this.cache(1, this.cacheName());
        c1.put((Object)"1", (Object)"Hello world here I am");
        c2.put((Object)"2", (Object)"Infinispan rules the world");
        c1.put((Object)"3", (Object)"JUDCon is in Boston");
        c2.put((Object)"4", (Object)"JBoss World is in Boston as well");
        c1.put((Object)"12", (Object)"JBoss Application Server");
        c2.put((Object)"15", (Object)"Hello world");
        c1.put((Object)"14", (Object)"Infinispan community");
        c1.put((Object)"111", (Object)"Infinispan open source");
        c2.put((Object)"112", (Object)"Boston is close to Toronto");
        c1.put((Object)"113", (Object)"Toronto is a capital of Ontario");
        c2.put((Object)"114", (Object)"JUDCon is cool");
        c1.put((Object)"211", (Object)"JBoss World is awesome");
        c2.put((Object)"212", (Object)"JBoss rules");
        c1.put((Object)"213", (Object)"JBoss division of RedHat ");
        c2.put((Object)"214", (Object)"RedHat community");
        MapReduceTask<String, String, String, Integer> task = this.createMapReduceTask(c1);
        task.mappedWith(mapper).reducedWith(reducer);
        if (useCombiner) {
            task.combinedWith(reducer);
        }
        if (keys != null && keys.length > 0) {
            task.onKeys((Object[])keys);
        }
        return task;
    }

    public MapReduceTask<String, String, String, Integer> invokeMapReduce(String[] keys) throws Exception {
        return this.invokeMapReduce(keys, true);
    }

    public MapReduceTask<String, String, String, Integer> invokeMapReduce(String[] keys, boolean useCombiner) throws Exception {
        return this.invokeMapReduce(keys, new WordCountMapper(), new WordCountReducer(), useCombiner);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testImproperCacheStateForMapReduceTask() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            @Override
            public void call() {
                Cache cache = this.cm.getCache();
                MapReduceTask task = new MapReduceTask(cache);
            }
        });
    }

    public void testinvokeMapReduceOnAllKeys() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null);
        Map mapReduce = task.execute();
        this.verifyResults(mapReduce);
    }

    public void testinvokeMapReduceOnEmptyKeys() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(new String[0]);
        Map mapReduce = task.execute();
        this.verifyResults(mapReduce);
    }

    public void testinvokeMapReduceOnAllKeysWithCombiner() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null, true);
        Map mapReduce = task.execute();
        this.verifyResults(mapReduce);
    }

    public void testCombinerDoesNotChangeResult() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null, true);
        Map mapReduce = task.execute();
        MapReduceTask<String, String, String, Integer> task2 = this.invokeMapReduce(null, false);
        Map mapReduce2 = task2.execute();
        AssertJUnit.assertEquals(mapReduce2.get("Infinispan"), mapReduce.get("Infinispan"));
        AssertJUnit.assertEquals(mapReduce2.get("RedHat"), mapReduce.get("RedHat"));
    }

    public void testMapperReducerIsolation() throws Exception {
        this.invokeMapReduce(null, new IsolationMapper(), new IsolationReducer(), false);
    }

    public void testinvokeMapReduceOnAllKeysAsync() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null);
        Future future = task.executeAsynchronously();
        Map mapReduce = (Map)future.get();
        this.verifyResults(mapReduce);
    }

    public void testinvokeMapReduceOnSubsetOfKeys() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(new String[]{"1", "2", "3"});
        Map mapReduce = task.execute();
        this.assertWordCount(this.countWords(mapReduce), 13);
    }

    public void testinvokeMapReduceOnSubsetOfKeysAsync() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(new String[]{"1", "2", "3"});
        Future future = task.executeAsynchronously();
        Map mapReduce = (Map)future.get();
        this.assertWordCount(this.countWords(mapReduce), 13);
    }

    protected void verifyResults(Map<String, Integer> result, Map<String, Integer> verifyAgainst) {
        for (Map.Entry<String, Integer> e : result.entrySet()) {
            String key = e.getKey();
            Integer count = verifyAgainst.get(key);
            assert (count.equals(e.getValue())) : "key " + e.getKey() + " does not have count " + count + " but " + e.getValue();
        }
    }

    protected int nodeCount() {
        return this.getCacheManagers().size();
    }

    public void testinvokeMapReduceOnAllKeysWithCollator() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null);
        Integer totalWords = (Integer)task.execute((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                int sum = 0;
                for (Map.Entry<String, Integer> e : reducedResults.entrySet()) {
                    sum += e.getValue().intValue();
                }
                return sum;
            }
        });
        this.assertWordCount(totalWords, 56);
    }

    public void testinvokeMapReduceOnSubsetOfKeysWithCollator() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(new String[]{"1", "2", "3"});
        Integer totalWords = (Integer)task.execute((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                int sum = 0;
                for (Map.Entry<String, Integer> e : reducedResults.entrySet()) {
                    sum += e.getValue().intValue();
                }
                return sum;
            }
        });
        this.assertWordCount(totalWords, 13);
    }

    public void testinvokeMapReduceOnAllKeysWithCollatorAsync() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null);
        Future future = task.executeAsynchronously((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                int sum = 0;
                for (Map.Entry<String, Integer> e : reducedResults.entrySet()) {
                    sum += e.getValue().intValue();
                }
                return sum;
            }
        });
        Integer totalWords = (Integer)future.get();
        this.assertWordCount(totalWords, 56);
    }

    public void testinvokeMapReduceOnSubsetOfKeysWithCollatorAsync() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(new String[]{"1", "2", "3"});
        Future future = task.executeAsynchronously((Collator)new Collator<String, Integer, Integer>(){

            public Integer collate(Map<String, Integer> reducedResults) {
                int sum = 0;
                for (Map.Entry<String, Integer> e : reducedResults.entrySet()) {
                    sum += e.getValue().intValue();
                }
                return sum;
            }
        });
        Integer totalWords = (Integer)future.get();
        this.assertWordCount(totalWords, 13);
    }

    @Test(expectedExceptions={CacheException.class})
    public void testCombinerForDistributedReductionWithException() throws Exception {
        MapReduceTask<String, String, String, Integer> task = this.invokeMapReduce(null);
        task.combinedWith((Reducer)new Reducer<String, Integer>(){

            public Integer reduce(String reducedKey, Iterator<Integer> iter) {
                int a = 4 / 0;
                return null;
            }
        });
        task.execute();
    }

    protected void assertWordCount(int actualWordCount, int expectedWordCount) {
        assert (actualWordCount == expectedWordCount) : " word count of " + actualWordCount + " incorrect , expected " + expectedWordCount;
    }

    protected int countWords(Map<String, Integer> result) {
        int sum = 0;
        for (Map.Entry<String, Integer> e : result.entrySet()) {
            sum += e.getValue().intValue();
        }
        return sum;
    }

    protected void verifyResults(Map<String, Integer> result) {
        this.verifyResults(result, counts);
    }

    static {
        counts.put("of", 2);
        counts.put("open", 1);
        counts.put("is", 6);
        counts.put("source", 1);
        counts.put("JBoss", 5);
        counts.put("in", 2);
        counts.put("capital", 1);
        counts.put("world", 3);
        counts.put("Hello", 2);
        counts.put("Ontario", 1);
        counts.put("cool", 1);
        counts.put("JUDCon", 2);
        counts.put("Infinispan", 3);
        counts.put("a", 1);
        counts.put("awesome", 1);
        counts.put("Application", 1);
        counts.put("am", 1);
        counts.put("RedHat", 2);
        counts.put("Server", 1);
        counts.put("community", 2);
        counts.put("as", 1);
        counts.put("the", 1);
        counts.put("Toronto", 2);
        counts.put("close", 1);
        counts.put("to", 1);
        counts.put("division", 1);
        counts.put("here", 1);
        counts.put("Boston", 3);
        counts.put("well", 1);
        counts.put("World", 2);
        counts.put("I", 1);
        counts.put("rules", 2);
    }

    private static class IsolationReducer
    implements Reducer<String, Integer> {
        private static final long serialVersionUID = 6069777605143824777L;
        private int count = 0;

        private IsolationReducer() {
        }

        public Integer reduce(String key, Iterator<Integer> iter) {
            assert (this.count == 0);
            ++this.count;
            return this.count;
        }
    }

    private static class IsolationMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = 1993535517358319862L;
        private int count = 0;

        private IsolationMapper() {
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            assert (this.count == 0);
            ++this.count;
        }
    }

    static class WordCountReducer
    implements Reducer<String, Integer> {
        private static final long serialVersionUID = 1901016598354633256L;

        WordCountReducer() {
        }

        public Integer reduce(String key, Iterator<Integer> iter) {
            int sum = 0;
            while (iter.hasNext()) {
                sum += iter.next().intValue();
            }
            return sum;
        }
    }

    static class WordCountMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = -5943370243108735560L;

        WordCountMapper() {
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            if (value == null) {
                throw new IllegalArgumentException("Key " + key + " has value " + value);
            }
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreElements()) {
                String s = (String)tokens.nextElement();
                collector.emit((Object)s, (Object)1);
            }
        }
    }
}

