/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distexec.mapreduce.BaseWordCountMapReduceTest;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.TwoNodesWithCacheStoreMapReduceTest")
public class TwoNodesWithCacheStoreMapReduceTest
extends BaseWordCountMapReduceTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TwoNodesWithCacheStoreMapReduceTest.getDefaultClusteredCacheConfig(this.getCacheMode(), true);
        LegacyStoreConfigurationBuilder store = builder.loaders().addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore(this.getClass().getSimpleName()));
        store.purgeOnStartup(true);
        this.createClusteredCaches(2, this.cacheName(), builder);
    }

    @Override
    public MapReduceTask<String, String, String, Integer> invokeMapReduce(String[] keys, Mapper<String, String, String, Integer> mapper, Reducer<String, Integer> reducer, boolean useCombiner) throws Exception {
        Cache cache1 = this.cache(0, this.cacheName());
        Cache cache2 = this.cache(1, this.cacheName());
        CacheStore c1 = this.getStore(cache1);
        CacheStore c2 = this.getStore(cache2);
        c1.store(this.toEntry("1", "Hello world here I am"));
        c2.store(this.toEntry("1", "Hello world here I am"));
        c1.store(this.toEntry("2", "Infinispan rules the world"));
        c2.store(this.toEntry("2", "Infinispan rules the world"));
        c1.store(this.toEntry("3", "JUDCon is in Boston"));
        c2.store(this.toEntry("3", "JUDCon is in Boston"));
        c1.store(this.toEntry("4", "JBoss World is in Boston as well"));
        c2.store(this.toEntry("4", "JBoss World is in Boston as well"));
        c1.store(this.toEntry("12", "JBoss Application Server"));
        c2.store(this.toEntry("12", "JBoss Application Server"));
        c1.store(this.toEntry("15", "Hello world"));
        c2.store(this.toEntry("15", "Hello world"));
        c1.store(this.toEntry("14", "Infinispan community"));
        c2.store(this.toEntry("14", "Infinispan community"));
        c1.store(this.toEntry("111", "Infinispan open source"));
        c2.store(this.toEntry("111", "Infinispan open source"));
        c1.store(this.toEntry("112", "Boston is close to Toronto"));
        c2.store(this.toEntry("112", "Boston is close to Toronto"));
        c1.store(this.toEntry("113", "Toronto is a capital of Ontario"));
        c2.store(this.toEntry("113", "Toronto is a capital of Ontario"));
        c1.store(this.toEntry("114", "JUDCon is cool"));
        c2.store(this.toEntry("114", "JUDCon is cool"));
        c1.store(this.toEntry("211", "JBoss World is awesome"));
        c2.store(this.toEntry("211", "JBoss World is awesome"));
        c1.store(this.toEntry("212", "JBoss rules"));
        c2.store(this.toEntry("212", "JBoss rules"));
        c1.store(this.toEntry("213", "JBoss division of RedHat "));
        c2.store(this.toEntry("213", "JBoss division of RedHat "));
        c1.store(this.toEntry("214", "RedHat community"));
        c2.store(this.toEntry("214", "RedHat community"));
        MapReduceTask<String, String, String, Integer> task = this.createMapReduceTask(cache1);
        task.mappedWith(mapper).reducedWith(reducer);
        if (useCombiner) {
            task.combinedWith(reducer);
        }
        if (keys != null && keys.length > 0) {
            task.onKeys((Object[])keys);
        }
        return task;
    }

    protected CacheStore getStore(Cache c) {
        return TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
    }

    protected InternalCacheEntry toEntry(String key, String value) {
        return TestInternalCacheEntryFactory.create(key, value);
    }
}

