/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.distribution.BaseDistCacheStoreTest;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncCacheStoreSharedTest")
public class DistSyncCacheStoreSharedTest
extends BaseDistCacheStoreTest {
    public DistSyncCacheStoreSharedTest() {
        this.sync = true;
        this.tx = false;
        this.testRetVals = true;
        this.shared = true;
    }

    @AfterMethod(alwaysRun=true)
    public void clearStats() {
        for (Cache c : this.caches) {
            System.out.println("Clearing stats for cache store on cache " + c);
            DummyInMemoryCacheStore cs = (DummyInMemoryCacheStore)TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            cs.clearStats();
        }
    }

    public void testExpectedConfig() {
        assert (this.c1.getCacheConfiguration().locking().supportsConcurrentUpdates());
    }

    public void testPutFromNonOwner() throws Exception {
        String key = "k4";
        String value = "value4";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Cache<Object, String> nonOwner = this.getFirstNonOwner(key);
        CacheStore nonOwnerStore = TestingUtil.extractComponent(nonOwner, CacheLoaderManager.class).getCacheStore();
        assert (!nonOwnerStore.containsKey((Object)key));
        Object retval = nonOwner.put((Object)key, (Object)value);
        this.asyncWait(key, PutKeyValueCommand.class, this.getSecondNonOwner(key));
        Cache<Object, String>[] owners = this.getOwners(key);
        CacheStore store = TestingUtil.extractComponent(owners[0], CacheLoaderManager.class).getCacheStore();
        this.assertIsInContainerImmortal(owners[0], key);
        assert (store.containsKey((Object)key));
        for (int i = 1; i < owners.length; ++i) {
            store = TestingUtil.extractComponent(owners[i], CacheLoaderManager.class).getCacheStore();
            this.assertIsInContainerImmortal(owners[i], key);
            assert (store.containsKey((Object)key));
        }
        for (Cache c : this.caches) {
            store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            assert (store.containsKey((Object)key));
            this.assertNumberOfInvocations(store, "store", 1);
        }
        if (this.testRetVals) assert (retval == null);
        this.assertOnAllCachesAndOwnership(key, value);
    }

    public void testPutFromOwner() throws Exception {
        String key = "k5";
        String value = "value5";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Cache<Object, String>[] owners = this.getOwners(key);
        Object retval = owners[0].put((Object)key, (Object)value);
        this.asyncWait(key, PutKeyValueCommand.class, this.getNonOwners(key));
        CacheStore store = TestingUtil.extractComponent(owners[0], CacheLoaderManager.class).getCacheStore();
        this.assertIsInContainerImmortal(owners[0], key);
        assert (store.containsKey((Object)key));
        for (int i = 1; i < owners.length; ++i) {
            store = TestingUtil.extractComponent(owners[i], CacheLoaderManager.class).getCacheStore();
            this.assertIsInContainerImmortal(owners[i], key);
            assert (store.containsKey((Object)key));
        }
        for (Cache c : this.caches) {
            store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (this.isOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
            }
            assert (store.containsKey((Object)key));
            this.assertNumberOfInvocations(store, "store", 1);
        }
        if (this.testRetVals) assert (retval == null);
        this.assertOnAllCachesAndOwnership(key, value);
    }

    private void assertNumberOfInvocations(CacheStore cs, String method, int expected) {
        int actual = ((DummyInMemoryCacheStore)cs).stats().get(method);
        assert (expected == actual) : "Expected " + expected + " but was " + actual;
    }

    public void testPutAll() throws Exception {
        this.log.trace((Object)"Here it begins");
        String k1 = "1";
        String v1 = "one";
        String k2 = "2";
        String v2 = "two";
        String k3 = "3";
        String v3 = "three";
        String k4 = "4";
        String v4 = "four";
        String[] keys = new String[]{k1, k2, k3, k4};
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(k1, v1);
        data.put(k2, v2);
        data.put(k3, v3);
        data.put(k4, v4);
        this.c1.putAll(data);
        for (String key : keys) {
            for (Cache c : this.caches) {
                CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
                if (this.isFirstOwner(c, key)) {
                    this.assertIsInContainerImmortal(c, key);
                }
                this.log.debug((Object)("Testing " + c));
                this.assertNumberOfInvocations(store, "store", 4);
                assert (store.containsKey((Object)key));
            }
        }
    }

    public void testRemoveFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        this.initAndTest();
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (!this.isFirstOwner(c, key)) continue;
            this.assertIsInContainerImmortal(c, key);
            assert (store.load((Object)key).getValue().equals(value));
        }
        Object retval = this.getFirstNonOwner(key).remove((Object)key);
        this.asyncWait("k1", RemoveCommand.class, this.getSecondNonOwner("k1"));
        if (this.testRetVals) assert (value.equals(retval));
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            assert (!store.containsKey((Object)key));
            this.assertNumberOfInvocations(store, "remove", 1);
        }
    }

    public void testReplaceFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (!this.isFirstOwner(c, key)) continue;
            this.assertIsInContainerImmortal(c, key);
            assert (store.load((Object)key).getValue().equals(value));
        }
        Object retval = this.getFirstNonOwner(key).replace((Object)key, (Object)value2);
        this.asyncWait(key, ReplaceCommand.class, this.getSecondNonOwner(key));
        if (this.testRetVals) assert (value.equals(retval));
        for (Cache c : this.caches) {
            CacheStore store = TestingUtil.extractComponent(c, CacheLoaderManager.class).getCacheStore();
            if (this.isFirstOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
            }
            assert (store.load((Object)key).getValue().equals(value2));
            this.assertNumberOfInvocations(store, "store", 2);
        }
    }

    public void testClear() throws Exception {
        int i;
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        for (i = 0; i < 5; ++i) {
            this.getOwners("k" + i)[0].put((Object)("k" + i), (Object)("value" + i));
            this.asyncWait("k" + i, PutKeyValueCommand.class, this.getNonOwners("k" + i));
        }
        for (i = 0; i < 5; ++i) {
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        for (Cache c : this.caches) {
            assert (!c.isEmpty());
        }
        this.c1.clear();
        this.asyncWait(null, ClearCommand.class, new Cache[0]);
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        CacheStore store = TestingUtil.extractComponent(this.c1, CacheLoaderManager.class).getCacheStore();
        for (int i2 = 0; i2 < 5; ++i2) {
            String key = "k" + i2;
            assert (!store.containsKey((Object)key));
            this.assertNumberOfInvocations(store, "clear", 1);
        }
    }
}

