/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.InvalidationFailureTest")
public class InvalidationFailureTest
extends MultipleCacheManagersTest {
    private Object k0;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration config = InvalidationFailureTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        config.setL1CacheEnabled(true);
        config.setNumOwners(1);
        this.createCluster(config, 2);
        this.manager(0).defineConfiguration("second", config);
        this.manager(1).defineConfiguration("second", config);
        this.manager(0).startCaches(new String[]{"___defaultcache", "second"});
        this.manager(1).startCaches(new String[]{"___defaultcache", "second"});
        this.waitForClusterToForm("___defaultcache", "second");
        this.cache(0).put((Object)"k", (Object)"v");
        this.cache(0, "second").put((Object)"k", (Object)"v");
        assert (this.cache(1).get((Object)"k").equals("v"));
        assert (this.cache(1, "second").get((Object)"k").equals("v"));
        this.k0 = new MagicKey(this.cache(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testL1Invalidated() throws Exception {
        block11: {
            this.tm(1).begin();
            this.cache(1).put(this.k0, (Object)"v");
            this.cache(1, "second").put(this.k0, (Object)"v");
            assert (!this.lockManager(1).isLocked(this.k0));
            assert (!this.lockManager(1, "second").isLocked(this.k0));
            Transaction transaction = this.tm(1).suspend();
            this.tm(0).begin();
            this.log.info((Object)"Before the put");
            this.cache(0, "second").put(this.k0, (Object)"v1");
            this.cache(0).put(this.k0, (Object)"v2");
            try {
                this.tm(0).commit();
                this.log.info((Object)"After the Commit");
            }
            catch (Exception e) {
                e.printStackTrace();
                assert (false) : "this should not fail even if the invalidation does";
            }
            finally {
                this.tm(1).resume(transaction);
                this.tm(1).rollback();
                assert (!this.lockManager(0).isLocked(this.k0));
                assert (!this.lockManager(0, "second").isLocked(this.k0));
                assert (!this.lockManager(1).isLocked(this.k0));
                if ($assertionsDisabled || !this.lockManager(1, "second").isLocked(this.k0)) break block11;
                throw new AssertionError();
            }
        }
    }
}

