/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionTestHelper;

public class MagicKey
implements Serializable {
    private static final long serialVersionUID = -835275755945753954L;
    String name = null;
    int hashcode;
    String address;

    public MagicKey(Cache<?, ?> primaryOwner) {
        int hc;
        Integer dummy;
        this.address = DistributionTestHelper.addressOf(primaryOwner).toString();
        Random r = new Random();
        while (!DistributionTestHelper.isFirstOwner(primaryOwner, dummy = new Integer(hc = r.nextInt()))) {
        }
        this.hashcode = ((Object)dummy).hashCode();
    }

    public MagicKey(Cache<?, ?> primaryOwner, Cache<?, ?> ... backupOwners) {
        int hc;
        Integer dummy;
        this.address = DistributionTestHelper.addressOf(primaryOwner).toString();
        Random r = new Random();
        int attemptsLeft = 1000;
        while (!DistributionTestHelper.hasOwners(dummy = new Integer(hc = r.nextInt()), primaryOwner, backupOwners) && --attemptsLeft >= 0) {
        }
        if (attemptsLeft < 0) {
            throw new IllegalStateException("Could not find any key owned by " + primaryOwner + ", " + Arrays.toString(backupOwners));
        }
        this.hashcode = ((Object)dummy).hashCode();
    }

    public MagicKey(String name, Cache<?, ?> primaryOwner) {
        this(primaryOwner);
        this.name = name;
    }

    public MagicKey(String name, Cache<?, ?> primaryOwner, Cache<?, ?> ... backupOwners) {
        this(primaryOwner, backupOwners);
        this.name = name;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MagicKey magicKey = (MagicKey)o;
        if (this.hashcode != magicKey.hashcode) {
            return false;
        }
        return !(this.address != null ? !this.address.equals(magicKey.address) : magicKey.address != null);
    }

    public String toString() {
        return "MagicKey#" + this.name + '{' + Integer.toHexString(this.hashcode) + '@' + this.address + '}';
    }
}

