/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.rehash;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="distribution.rehash.RehashAfterJoinWithPreloadTest", groups={"functional"})
public class RehashAfterJoinWithPreloadTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(RehashAfterJoinWithPreloadTest.class);
    private final String testCacheName = "testCache" + this.getClass().getSimpleName();
    private final String fileCacheStoreTmpDir = TestingUtil.tmpDirectory(this);
    protected boolean supportsConcurrentUpdates = true;

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    private void addNewCacheManagerAndWaitForRehash() {
        EmbeddedCacheManager cacheManager = this.addClusterEnabledCacheManager(RehashAfterJoinWithPreloadTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false));
        cacheManager.defineConfiguration(this.testCacheName, this.buildCfg(true));
        log.debug((Object)("\n\nstarted CacheManager #" + (this.getCacheManagers().size() - 1)));
        this.waitForClusterToForm(this.testCacheName);
    }

    private Configuration buildCfg(boolean clustered) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        FileCacheStoreConfigurationBuilder fileStoreCB = cb.loaders().addFileCacheStore().location(this.fileCacheStoreTmpDir);
        fileStoreCB.purgeOnStartup(false);
        cb.loaders().passivation(false);
        cb.loaders().preload(true);
        cb.loaders().shared(true);
        if (clustered) {
            cb.clustering().l1().disable();
            cb.clustering().cacheMode(CacheMode.DIST_SYNC);
            cb.clustering().hash().numOwners(1);
            cb.clustering().stateTransfer().fetchInMemoryState(true);
            cb.clustering().hash().groups().enabled();
        }
        cb.locking().supportsConcurrentUpdates(this.supportsConcurrentUpdates);
        return cb.build(true);
    }

    public void test() {
        this.putTestDataInCacheStore();
        this.addNewCacheManagerAndWaitForRehash();
        this.printCacheContents();
        this.addNewCacheManagerAndWaitForRehash();
        this.printCacheContents();
        this.addNewCacheManagerAndWaitForRehash();
        this.printCacheContents();
        this.assertEvenDistribution();
    }

    private void assertEvenDistribution() {
        for (int i = 0; i < this.getCacheManagers().size(); ++i) {
            Cache testCache = this.manager(i).getCache(this.testCacheName);
            for (String key : testCache.keySet()) {
                assert (testCache.getAdvancedCache().getDistributionManager().getLocality((Object)key).isLocal()) : "Key '" + key + "' is not owned by node " + this.address(i) + " but it still appears there";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putTestDataInCacheStore() {
        log.debug((Object)("Using cache store dir " + this.fileCacheStoreTmpDir));
        EmbeddedCacheManager cmForCacheStoreInit = TestCacheManagerFactory.createCacheManager(TestCacheManagerFactory.getDefaultConfiguration(true));
        try {
            cmForCacheStoreInit.defineConfiguration(this.testCacheName, this.buildCfg(false));
            Cache cache = cmForCacheStoreInit.getCache(this.testCacheName);
            cache.put((Object)"key1", (Object)"one");
            cache.put((Object)"key2", (Object)"two");
            cache.put((Object)"key3", (Object)"three");
            log.debug((Object)"added 3 entries to test cache");
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cmForCacheStoreInit);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cmForCacheStoreInit);
    }

    private void printCacheContents() {
        log.debug((Object)"----------------------------------------------------");
        for (int i = 0; i < this.getCacheManagers().size(); ++i) {
            log.debug((Object)(" Content of Cache with CacheManager #" + i + " (" + this.address(i) + ", all members: " + this.manager(i).getMembers() + ")"));
            Cache testCache = this.manager(i).getCache(this.testCacheName);
            for (String key : testCache.keySet()) {
                log.debug((Object)("  key: " + key + "  value: " + (String)testCache.get((Object)key)));
            }
        }
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove(this.fileCacheStoreTmpDir);
    }
}

