/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.Collection;
import java.util.List;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="topologyaware.TopologyInfoBroadcastTest")
public class TopologyInfoBroadcastTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfiguration gc1 = GlobalConfiguration.getClusteredDefault();
        this.updatedSiteInfo(gc1, "s0", "r0", "m0");
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createCacheManager(gc1, this.getClusterConfig());
        this.cacheManagers.add(cm1);
        GlobalConfiguration gc2 = GlobalConfiguration.getClusteredDefault();
        this.updatedSiteInfo(gc2, "s1", "r1", "m1");
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createCacheManager(gc2, this.getClusterConfig());
        this.cacheManagers.add(cm2);
        GlobalConfiguration gc3 = GlobalConfiguration.getClusteredDefault();
        this.updatedSiteInfo(gc3, "s2", "r2", "m2");
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createCacheManager(gc3, this.getClusterConfig());
        this.cacheManagers.add(cm3);
        this.log.info((Object)"Here it starts");
        this.waitForClusterToForm();
        this.log.info((Object)"Here it ends");
    }

    protected Configuration getClusterConfig() {
        return TopologyInfoBroadcastTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC);
    }

    private void updatedSiteInfo(GlobalConfiguration gc, String s, String r, String m) {
        gc.setSiteId(s);
        gc.setRackId(r);
        gc.setMachineId(m);
    }

    public void testIsReplicated() {
        DistributionManagerImpl dmi = (DistributionManagerImpl)this.advancedCache(0).getDistributionManager();
        System.out.println("distributionManager.ConsistentHash() = " + dmi.getConsistentHash());
        this.assertTopologyInfo3Nodes(dmi.getConsistentHash().getMembers());
        dmi = (DistributionManagerImpl)this.advancedCache(1).getDistributionManager();
        this.assertTopologyInfo3Nodes(dmi.getConsistentHash().getMembers());
        dmi = (DistributionManagerImpl)this.advancedCache(2).getDistributionManager();
        this.assertTopologyInfo3Nodes(dmi.getConsistentHash().getMembers());
        ConsistentHash tach0 = this.advancedCache(0).getDistributionManager().getConsistentHash();
        ConsistentHash tach1 = this.advancedCache(1).getDistributionManager().getConsistentHash();
        Assert.assertEquals((Collection)tach0.getMembers(), (Collection)tach1.getMembers());
        ConsistentHash tach2 = this.advancedCache(2).getDistributionManager().getConsistentHash();
        Assert.assertEquals((Collection)tach0.getMembers(), (Collection)tach2.getMembers());
    }

    @Test(dependsOnMethods={"testIsReplicated"})
    public void testNodeLeaves() {
        TestingUtil.killCacheManagers(this.manager(1));
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0), this.cache(2));
        TestingUtil.waitForRehashToComplete(this.cache(0), this.cache(2));
        DistributionManagerImpl dmi = (DistributionManagerImpl)this.advancedCache(0).getDistributionManager();
        this.assertTopologyInfo2Nodes(dmi.getConsistentHash().getMembers());
        dmi = (DistributionManagerImpl)this.advancedCache(2).getDistributionManager();
        this.assertTopologyInfo2Nodes(dmi.getConsistentHash().getMembers());
        ConsistentHash tach0 = this.advancedCache(0).getDistributionManager().getConsistentHash();
        ConsistentHash tach2 = this.advancedCache(2).getDistributionManager().getConsistentHash();
        Assert.assertEquals((Collection)tach0.getMembers(), (Collection)tach2.getMembers());
    }

    private void assertTopologyInfo3Nodes(List<Address> caches) {
        this.assertTopologyInfo2Nodes(caches);
        TopologyAwareAddress address1 = (TopologyAwareAddress)this.address(1);
        Assert.assertEquals((String)address1.getSiteId(), (String)"s1");
        Assert.assertEquals((String)address1.getRackId(), (String)"r1");
        Assert.assertEquals((String)address1.getMachineId(), (String)"m1");
    }

    private void assertTopologyInfo2Nodes(List<Address> caches) {
        TopologyAwareAddress address0 = (TopologyAwareAddress)this.address(0);
        Assert.assertEquals((String)address0.getSiteId(), (String)"s0");
        Assert.assertEquals((String)address0.getRackId(), (String)"r0");
        Assert.assertEquals((String)address0.getMachineId(), (String)"m0");
        TopologyAwareAddress address2 = (TopologyAwareAddress)this.address(2);
        Assert.assertEquals((String)address2.getSiteId(), (String)"s2");
        Assert.assertEquals((String)address2.getRackId(), (String)"r2");
        Assert.assertEquals((String)address2.getMachineId(), (String)"m2");
    }
}

