/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="interceptors.ConcurrentInterceptorVisibilityTest")
public class ConcurrentInterceptorVisibilityTest
extends AbstractInfinispanTest {
    public void testSizeVisibility() throws Exception {
        this.updateCache(Visibility.SIZE);
    }

    public void testGetVisibility() throws Exception {
        this.updateCache(Visibility.GET);
    }

    private void updateCache(final Visibility visibility) throws Exception {
        final String key = "k-" + (Object)((Object)visibility);
        final String value = "k-" + (Object)((Object)visibility);
        final CountDownLatch entryCreatedLatch = new CountDownLatch(1);
        final EntryCreatedInterceptor interceptor = new EntryCreatedInterceptor(entryCreatedLatch);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)interceptor).before(EntryWrappingInterceptor.class);
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(builder)){

            @Override
            public void call() {
                final Cache cache = this.cm.getCache();
                switch (visibility) {
                    case SIZE: {
                        assert (cache.size() == 0);
                        break;
                    }
                    case GET: {
                        assert (cache.get((Object)key) == null);
                        break;
                    }
                }
                Future ignore = ConcurrentInterceptorVisibilityTest.this.fork(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        cache.put((Object)key, (Object)value);
                        return null;
                    }
                });
                try {
                    entryCreatedLatch.await(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                switch (visibility) {
                    case SIZE: {
                        int size = cache.size();
                        assert (size == 1) : "size is: " + size;
                        assert (interceptor.assertKeySet);
                        break;
                    }
                    case GET: {
                        Object retVal = cache.get((Object)key);
                        assert (retVal != null);
                        assert (retVal.equals(value)) : "retVal is: " + retVal;
                        assert (interceptor.assertKeySet);
                        break;
                    }
                }
                try {
                    ignore.get(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static class EntryCreatedInterceptor
    extends BaseCustomInterceptor {
        Log log = LogFactory.getLog(EntryCreatedInterceptor.class);
        final CountDownLatch latch;
        volatile boolean assertKeySet;

        private EntryCreatedInterceptor(CountDownLatch latch) {
            this.latch = latch;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            Object ret = super.visitPutKeyValueCommand(ctx, command);
            this.assertKeySet = this.cache.keySet().size() == 1;
            this.log.info((Object)"Cache entry created, now check in different thread");
            this.latch.countDown();
            TestingUtil.sleepThread(3000L);
            return ret;
        }
    }

    private static enum Visibility {
        SIZE,
        GET;

    }
}

