/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.io.GridFile;
import org.infinispan.io.GridFilesystem;
import org.infinispan.io.ReadableGridFileChannel;
import org.infinispan.io.WritableGridFileChannel;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="io.GridFileTest", groups={"functional"})
public class GridFileTest
extends SingleCacheManagerTest {
    private Cache<String, byte[]> dataCache;
    private Cache<String, GridFile.Metadata> metadataCache;
    private GridFilesystem fs;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.dataCache = this.cacheManager.getCache("data");
        this.metadataCache = this.cacheManager.getCache("metadata");
        this.fs = new GridFilesystem(this.dataCache, this.metadataCache);
    }

    public void testGridFS() throws IOException {
        File gridDir = this.fs.getFile("/test");
        assert (gridDir.mkdirs());
        File gridFile = this.fs.getFile("/test/myfile.txt");
        assert (gridFile.createNewFile());
    }

    public void testGetFile() throws Exception {
        Assert.assertEquals((String)this.fs.getFile("file.txt").getPath(), (String)"file.txt");
        Assert.assertEquals((String)this.fs.getFile("/file.txt").getPath(), (String)"/file.txt");
        Assert.assertEquals((String)this.fs.getFile("myDir/file.txt").getPath(), (String)"myDir/file.txt");
        Assert.assertEquals((String)this.fs.getFile("/myDir/file.txt").getPath(), (String)"/myDir/file.txt");
        Assert.assertEquals((String)this.fs.getFile("myDir", "file.txt").getPath(), (String)"myDir/file.txt");
        Assert.assertEquals((String)this.fs.getFile("/myDir", "file.txt").getPath(), (String)"/myDir/file.txt");
        File dir = this.fs.getFile("/myDir");
        Assert.assertEquals((String)this.fs.getFile(dir, "file.txt").getPath(), (String)"/myDir/file.txt");
        dir = this.fs.getFile("myDir");
        Assert.assertEquals((String)this.fs.getFile(dir, "file.txt").getPath(), (String)"myDir/file.txt");
    }

    public void testCreateNewFile() throws IOException {
        File file = this.fs.getFile("file.txt");
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertFalse((boolean)file.createNewFile());
    }

    @Test(expectedExceptions={IOException.class})
    public void testCreateNewFileInNonExistentDir() throws IOException {
        File file = this.fs.getFile("nonExistent/file.txt");
        file.createNewFile();
    }

    public void testNonExistentFileIsNeitherFileNorDirectory() throws IOException {
        File file = this.fs.getFile("nonExistentFile.txt");
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)file.isFile());
        Assert.assertFalse((boolean)file.isDirectory());
    }

    public void testMkdir() throws IOException {
        Assert.assertFalse((boolean)this.mkdir(""));
        Assert.assertFalse((boolean)this.mkdir("/"));
        Assert.assertFalse((boolean)this.mkdir("/nonExistentParentDir/subDir"));
        Assert.assertTrue((boolean)this.mkdir("myDir1"));
        Assert.assertTrue((boolean)this.mkdir("myDir1/mySubDir1"));
        Assert.assertTrue((boolean)this.mkdir("/myDir2"));
        Assert.assertTrue((boolean)this.mkdir("/myDir2/mySubDir2"));
        this.createFile("/file.txt");
        Assert.assertFalse((boolean)this.mkdir("/file.txt/dir"));
    }

    private boolean mkdir(String pathname) {
        return this.fs.getFile(pathname).mkdir();
    }

    public void testMkdirs() throws IOException {
        Assert.assertFalse((boolean)this.mkdirs(""));
        Assert.assertFalse((boolean)this.mkdirs("/"));
        Assert.assertTrue((boolean)this.mkdirs("myDir1"));
        Assert.assertTrue((boolean)this.mkdirs("myDir2/mySubDir"));
        Assert.assertTrue((boolean)this.mkdirs("/myDir3"));
        Assert.assertTrue((boolean)this.mkdirs("/myDir4/mySubDir"));
        Assert.assertTrue((boolean)this.mkdirs("/myDir5/subDir/secondSubDir"));
        this.createFile("/file.txt");
        Assert.assertFalse((boolean)this.mkdirs("/file.txt/dir"));
    }

    private boolean mkdirs(String pathname) {
        return this.fs.getFile(pathname).mkdirs();
    }

    public void testGetParent() throws IOException {
        File file = this.fs.getFile("file.txt");
        Assert.assertEquals((String)file.getParent(), null);
        file = this.fs.getFile("/parentdir/file.txt");
        Assert.assertEquals((String)file.getParent(), (String)"/parentdir");
        file = this.fs.getFile("/parentdir/subdir/file.txt");
        Assert.assertEquals((String)file.getParent(), (String)"/parentdir/subdir");
    }

    public void testGetParentFile() throws IOException {
        File file = this.fs.getFile("file.txt");
        Assert.assertNull((Object)file.getParentFile());
        file = this.fs.getFile("/parentdir/file.txt");
        File parentDir = file.getParentFile();
        Assert.assertTrue((boolean)(parentDir instanceof GridFile));
        Assert.assertEquals((String)parentDir.getPath(), (String)"/parentdir");
    }

    @Test(expectedExceptions={FileNotFoundException.class})
    public void testWritingToDirectoryThrowsException1() throws IOException {
        GridFile dir = (GridFile)this.createDir();
        this.fs.getOutput(dir);
    }

    @Test(expectedExceptions={FileNotFoundException.class})
    public void testWritingToDirectoryThrowsException2() throws IOException {
        File dir = this.createDir();
        this.fs.getOutput(dir.getPath());
    }

    @Test(expectedExceptions={FileNotFoundException.class})
    public void testReadingFromDirectoryThrowsException1() throws IOException {
        File dir = this.createDir();
        this.fs.getInput(dir);
    }

    @Test(expectedExceptions={FileNotFoundException.class})
    public void testReadingFromDirectoryThrowsException2() throws IOException {
        File dir = this.createDir();
        this.fs.getInput(dir.getPath());
    }

    private File createDir() {
        return this.createDir("mydir");
    }

    private File createDir(String pathname) {
        File dir = this.fs.getFile(pathname);
        boolean created = dir.mkdir();
        assert (created);
        return dir;
    }

    public void testWriteAcrossMultipleChunksWithNonDefaultChunkSize() throws Exception {
        this.writeToFile("multipleChunks.txt", "This text spans multiple chunks, because each chunk is only 10 bytes long.", 10);
        String text = this.getContents("multipleChunks.txt");
        Assert.assertEquals((String)text, (String)"This text spans multiple chunks, because each chunk is only 10 bytes long.");
    }

    public void testWriteAcrossMultipleChunksWithNonDefaultChunkSizeAfterFileIsExplicitlyCreated() throws Exception {
        GridFile file = (GridFile)this.fs.getFile("multipleChunks.txt", 20);
        file.createNewFile();
        this.writeToFile("multipleChunks.txt", "This text spans multiple chunks, because each chunk is only 20 bytes long.", 10);
        String text = this.getContents("multipleChunks.txt");
        Assert.assertEquals((String)text, (String)"This text spans multiple chunks, because each chunk is only 20 bytes long.");
    }

    public void testAppend() throws Exception {
        this.writeToFile("append.txt", "Hello");
        this.appendToFile("append.txt", "World");
        Assert.assertEquals((String)this.getContents("append.txt"), (String)"HelloWorld");
    }

    public void testAppendWithDifferentChunkSize() throws Exception {
        this.writeToFile("append.txt", "Hello", 2);
        this.appendToFile("append.txt", "World", 5);
        Assert.assertEquals((String)this.getContents("append.txt"), (String)"HelloWorld");
    }

    public void testAppendToEmptyFile() throws Exception {
        this.appendToFile("empty.txt", "Hello");
        Assert.assertEquals((String)this.getContents("empty.txt"), (String)"Hello");
    }

    public void testDeleteRemovesAllChunks() throws Exception {
        Assert.assertEquals((int)this.numberOfChunksInCache(), (int)0);
        Assert.assertEquals((int)this.numberOfMetadataEntries(), (int)0);
        this.writeToFile("delete.txt", "delete me", 100);
        GridFile file = (GridFile)this.fs.getFile("delete.txt");
        boolean deleted = file.delete(true);
        Assert.assertTrue((boolean)deleted);
        Assert.assertFalse((boolean)file.exists());
        Assert.assertEquals((int)this.numberOfChunksInCache(), (int)0);
        Assert.assertEquals((int)this.numberOfMetadataEntries(), (int)0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testDeleteOnExit() {
        this.fs.getFile("nonsuch.txt").deleteOnExit();
    }

    public void testOverwritingFileDoesNotLeaveExcessChunksInCache() throws Exception {
        Assert.assertEquals((int)this.numberOfChunksInCache(), (int)0);
        this.writeToFile("leak.txt", "12345abcde12345", 5);
        Assert.assertEquals((int)this.numberOfChunksInCache(), (int)3);
        this.writeToFile("leak.txt", "12345", 5);
        Assert.assertEquals((int)this.numberOfChunksInCache(), (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteAndReadNegativeByte() throws Exception {
        String filePath = "negative.dat";
        OutputStream out = this.fs.getOutput(filePath);
        try {
            out.write(-1);
        }
        finally {
            out.close();
        }
        InputStream in = this.fs.getInput(filePath);
        try {
            Assert.assertEquals((int)in.read(), (int)255);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteAfterClose() throws Exception {
        String filePath = "test_write_to_closed.dat";
        OutputStream out = this.fs.getOutput(filePath);
        try {
            out.write(1);
        }
        finally {
            out.close();
        }
        IOException e = null;
        try {
            out.write(2);
        }
        catch (IOException ex) {
            e = ex;
        }
        Assert.assertNotNull((Object)e);
        File f = this.fs.getFile(filePath);
        Assert.assertEquals((long)f.length(), (long)1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiClose() throws Exception {
        String filePath = "test_close.dat";
        OutputStream out = this.fs.getOutput(filePath);
        try {
            out.write(1);
        }
        finally {
            out.close();
            out.close();
        }
        File f = this.fs.getFile(filePath);
        Assert.assertEquals((long)f.length(), (long)1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCanReadClosed() throws Exception {
        String filePath = "file_read_closed.txt";
        OutputStream out = this.fs.getOutput(filePath);
        try {
            out.write(1);
            out.write(2);
            out.write(3);
        }
        finally {
            out.close();
        }
        InputStream in = this.fs.getInput(filePath);
        in.read();
        in.close();
        IOException e = null;
        try {
            in.read();
        }
        catch (IOException ex) {
            e = ex;
        }
        Assert.assertNotNull((Object)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSkipAndAvailable() throws Exception {
        String filePath = "skip.dat";
        OutputStream out = this.fs.getOutput(filePath);
        try {
            out.write(1);
            out.write(2);
            out.write(3);
        }
        finally {
            out.close();
        }
        InputStream in = this.fs.getInput(filePath);
        try {
            long skipped = in.skip(2L);
            Assert.assertEquals((long)skipped, (long)2L);
            Assert.assertEquals((int)in.read(), (int)3);
        }
        finally {
            in.close();
        }
    }

    public void testLastModified() throws Exception {
        Assert.assertEquals((long)this.fs.getFile("nonExistentFile.txt").lastModified(), (long)0L);
        long time1 = System.currentTimeMillis();
        File file = this.createFile("file.txt");
        long time2 = System.currentTimeMillis();
        Assert.assertTrue((time1 <= file.lastModified() ? 1 : 0) != 0);
        Assert.assertTrue((file.lastModified() <= time2 ? 1 : 0) != 0);
        Thread.sleep(100L);
        time1 = System.currentTimeMillis();
        this.writeToFile(file.getPath(), "foo");
        time2 = System.currentTimeMillis();
        Assert.assertTrue((time1 <= file.lastModified() ? 1 : 0) != 0);
        Assert.assertTrue((file.lastModified() <= time2 ? 1 : 0) != 0);
    }

    public void testSetLastModified() throws IOException {
        Assert.assertFalse((boolean)this.fs.getFile("nonsuch").setLastModified(23L));
        File file = this.createFile("file.txt");
        Assert.assertTrue((boolean)file.setLastModified(42L));
        Assert.assertEquals((long)this.fs.getFile("file.txt").lastModified(), (long)42L);
    }

    public void testList() throws Exception {
        Assert.assertNull((Object)this.fs.getFile("nonExistentDir").list());
        Assert.assertEquals((int)this.createDir("/emptyDir").list().length, (int)0);
        File dir = this.createDirWithFiles();
        String[] filenames = dir.list();
        Assert.assertEquals(this.asSet(filenames), this.asSet("foo1.txt", "foo2.txt", "bar1.txt", "bar2.txt", "fooDir", "barDir"));
    }

    public void testListWithFilenameFilter() throws Exception {
        File dir = this.createDirWithFiles();
        String[] filenames = dir.list(new FooFilenameFilter());
        Assert.assertEquals(this.asSet(filenames), this.asSet("foo1.txt", "foo2.txt", "fooDir"));
    }

    public void testListFiles() throws Exception {
        Assert.assertNull((Object)this.fs.getFile("nonExistentDir").listFiles());
        Assert.assertEquals((int)this.createDir("/emptyDir").listFiles().length, (int)0);
        File dir = this.createDirWithFiles();
        File[] files = dir.listFiles();
        Assert.assertEquals(this.asSet(this.getPaths(files)), this.asSet("/myDir/foo1.txt", "/myDir/foo2.txt", "/myDir/fooDir", "/myDir/bar1.txt", "/myDir/bar2.txt", "/myDir/barDir"));
    }

    public void testListFilesWithFilenameFilter() throws Exception {
        File dir = this.createDirWithFiles();
        FooFilenameFilter filter = new FooFilenameFilter();
        filter.expectDir(dir);
        File[] files = dir.listFiles(filter);
        Assert.assertEquals(this.asSet(this.getPaths(files)), this.asSet("/myDir/foo1.txt", "/myDir/foo2.txt", "/myDir/fooDir"));
    }

    public void testListFilesWithFileFilter() throws Exception {
        File dir = this.createDirWithFiles();
        File[] files = dir.listFiles(new FooFileFilter());
        Assert.assertEquals(this.asSet(this.getPaths(files)), this.asSet("/myDir/foo1.txt", "/myDir/foo2.txt", "/myDir/fooDir"));
    }

    public void testRootDir() throws Exception {
        File rootDir = this.fs.getFile("/");
        Assert.assertTrue((boolean)rootDir.exists());
        Assert.assertTrue((boolean)rootDir.isDirectory());
        this.createFile("/foo.txt");
        String[] filenames = rootDir.list();
        Assert.assertNotNull((Object)filenames);
        Assert.assertEquals((int)filenames.length, (int)1);
        Assert.assertEquals((String)filenames[0], (String)"foo.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadableChannel() throws Exception {
        String content = "This is the content of channelTest.txt";
        this.writeToFile("/channelTest.txt", content, 10);
        ReadableGridFileChannel channel = this.fs.getReadableChannel("/channelTest.txt");
        try {
            Assert.assertTrue((boolean)channel.isOpen());
            ByteBuffer buffer = ByteBuffer.allocate(1000);
            channel.read(buffer);
            Assert.assertEquals((String)this.getStringFrom(buffer), (String)content);
        }
        finally {
            channel.close();
        }
        Assert.assertFalse((boolean)channel.isOpen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadableChannelPosition() throws Exception {
        this.writeToFile("/position.txt", "0123456789", 3);
        ReadableGridFileChannel channel = this.fs.getReadableChannel("/position.txt");
        try {
            Assert.assertEquals((long)channel.position(), (long)0L);
            channel.position(5L);
            Assert.assertEquals((long)channel.position(), (long)5L);
            Assert.assertEquals((String)this.getStringFromChannel((ReadableByteChannel)channel, 3), (String)"567");
            Assert.assertEquals((long)channel.position(), (long)8L);
            channel.position(2L);
            Assert.assertEquals((long)channel.position(), (long)2L);
            Assert.assertEquals((String)this.getStringFromChannel((ReadableByteChannel)channel, 5), (String)"23456");
            Assert.assertEquals((long)channel.position(), (long)7L);
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWritableChannel() throws Exception {
        WritableGridFileChannel channel = this.fs.getWritableChannel("/channelTest.txt", false, 10);
        try {
            Assert.assertTrue((boolean)channel.isOpen());
            channel.write(ByteBuffer.wrap("This file spans multiple chunks.".getBytes()));
        }
        finally {
            channel.close();
        }
        Assert.assertFalse((boolean)channel.isOpen());
        Assert.assertEquals((String)this.getContents("/channelTest.txt"), (String)"This file spans multiple chunks.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWritableChannelAppend() throws Exception {
        this.writeToFile("/append.txt", "Initial text.", 3);
        WritableGridFileChannel channel = this.fs.getWritableChannel("/append.txt", true);
        try {
            channel.write(ByteBuffer.wrap("Appended text.".getBytes()));
        }
        finally {
            channel.close();
        }
        Assert.assertEquals((String)this.getContents("/append.txt"), (String)"Initial text.Appended text.");
    }

    public void testGetAbsolutePath() throws IOException {
        Assert.assertEquals((String)this.fs.getFile("/file.txt").getAbsolutePath(), (String)"/file.txt");
        Assert.assertEquals((String)this.fs.getFile("file.txt").getAbsolutePath(), (String)"/file.txt");
        Assert.assertEquals((String)this.fs.getFile("dir/file.txt").getAbsolutePath(), (String)"/dir/file.txt");
    }

    public void testGetAbsoluteFile() throws IOException {
        Assert.assertTrue((boolean)(this.fs.getFile("file.txt").getAbsoluteFile() instanceof GridFile));
        Assert.assertEquals((String)this.fs.getFile("/file.txt").getAbsoluteFile().getPath(), (String)"/file.txt");
        Assert.assertEquals((String)this.fs.getFile("file.txt").getAbsoluteFile().getPath(), (String)"/file.txt");
        Assert.assertEquals((String)this.fs.getFile("dir/file.txt").getAbsoluteFile().getPath(), (String)"/dir/file.txt");
    }

    public void testIsAbsolute() throws IOException {
        Assert.assertTrue((boolean)this.fs.getFile("/file.txt").isAbsolute());
        Assert.assertFalse((boolean)this.fs.getFile("file.txt").isAbsolute());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testRenameTo() {
        this.fs.getFile("file.txt").renameTo(null);
    }

    public void testLeadingSeparatorIsOptional() throws IOException {
        File gridFile = this.fs.getFile("file.txt");
        assert (gridFile.createNewFile());
        Assert.assertTrue((boolean)this.fs.getFile("file.txt").exists());
        Assert.assertTrue((boolean)this.fs.getFile("/file.txt").exists());
        File dir = this.fs.getFile("dir");
        boolean dirCreated = dir.mkdir();
        Assert.assertTrue((boolean)dirCreated);
        Assert.assertTrue((boolean)this.fs.getFile("dir").exists());
        Assert.assertTrue((boolean)this.fs.getFile("/dir").exists());
    }

    public void testGetName() throws IOException {
        Assert.assertEquals((String)this.fs.getFile("").getName(), (String)"");
        Assert.assertEquals((String)this.fs.getFile("/").getName(), (String)"");
        Assert.assertEquals((String)this.fs.getFile("file.txt").getName(), (String)"file.txt");
        Assert.assertEquals((String)this.fs.getFile("/file.txt").getName(), (String)"file.txt");
        Assert.assertEquals((String)this.fs.getFile("/dir/file.txt").getName(), (String)"file.txt");
        Assert.assertEquals((String)this.fs.getFile("/dir/subdir/file.txt").getName(), (String)"file.txt");
        Assert.assertEquals((String)this.fs.getFile("dir/subdir/file.txt").getName(), (String)"file.txt");
    }

    public void testEquals() throws Exception {
        Assert.assertFalse((boolean)this.fs.getFile("").equals(null));
        Assert.assertTrue((boolean)this.fs.getFile("").equals(this.fs.getFile("")));
        Assert.assertTrue((boolean)this.fs.getFile("").equals(this.fs.getFile("/")));
        Assert.assertTrue((boolean)this.fs.getFile("foo.txt").equals(this.fs.getFile("foo.txt")));
        Assert.assertTrue((boolean)this.fs.getFile("foo.txt").equals(this.fs.getFile("/foo.txt")));
        Assert.assertFalse((boolean)this.fs.getFile("foo.txt").equals(this.fs.getFile("FOO.TXT")));
        Assert.assertFalse((boolean)this.fs.getFile("/foo.txt").equals(new File("/foo.txt")));
    }

    public void testCanRead() throws Exception {
        File gridFile = this.fs.getFile("file.txt");
        assert (gridFile.createNewFile());
        Assert.assertTrue((boolean)gridFile.canRead());
        Assert.assertFalse((boolean)this.fs.getFile("nonsuch.txt").canRead());
    }

    public void testCanWrite() throws Exception {
        File gridFile = this.fs.getFile("file.txt");
        assert (gridFile.createNewFile());
        Assert.assertTrue((boolean)gridFile.canWrite());
        Assert.assertFalse((boolean)this.fs.getFile("nonsuch.txt").canWrite());
    }

    public void testIsHidden() {
        Assert.assertFalse((boolean)this.fs.getFile("nonsuch.txt").isHidden());
    }

    public void testCanExecute() {
        Assert.assertFalse((boolean)this.fs.getFile("nonsuch.txt").isHidden());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testGetCanonicalPath() throws IOException {
        this.fs.getFile("nonsuch.txt").getCanonicalPath();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testGetCanonicalFile() throws IOException {
        this.fs.getFile("nonsuch.txt").getCanonicalFile();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testToURL() throws MalformedURLException {
        this.fs.getFile("nonsuch.txt").toURL();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testToURI() {
        this.fs.getFile("nonsuch.txt").toURI();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSetReadOnly() {
        this.fs.getFile("nonsuch.txt").setReadOnly();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSetWritable() {
        this.fs.getFile("nonsuch.txt").setWritable(true);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSetWritable2() {
        this.fs.getFile("nonsuch.txt").setWritable(true, true);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSetReadable() {
        this.fs.getFile("nonsuch.txt").setReadable(true);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSetReadable2() {
        this.fs.getFile("nonsuch.txt").setReadable(true, true);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSetExecutable() {
        this.fs.getFile("nonsuch.txt").setExecutable(true);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testSetExecutable2() {
        this.fs.getFile("nonsuch.txt").setExecutable(true, true);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testGetTotalSpace() {
        this.fs.getFile("nonsuch.txt").getTotalSpace();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testGetFreeSpace() {
        this.fs.getFile("nonsuch.txt").getFreeSpace();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testGetUsableSpace() {
        this.fs.getFile("nonsuch.txt").getUsableSpace();
    }

    private String getStringFromChannel(ReadableByteChannel channel, int length) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        channel.read(buffer);
        return this.getStringFrom(buffer);
    }

    private String getStringFrom(ByteBuffer buffer) {
        buffer.flip();
        byte[] buf = new byte[buffer.remaining()];
        buffer.get(buf);
        return new String(buf);
    }

    private String[] getPaths(File[] files) {
        String[] paths = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            paths[i] = file.getPath();
        }
        return paths;
    }

    private Set<String> asSet(String ... strings) {
        return new HashSet<String>(Arrays.asList(strings));
    }

    private File createDirWithFiles() throws IOException {
        File dir = this.createDir("/myDir");
        this.createFile("/myDir/foo1.txt");
        this.createFile("/myDir/foo2.txt");
        this.createFile("/myDir/bar1.txt");
        this.createFile("/myDir/bar2.txt");
        this.createDir("/myDir/fooDir");
        this.createFile("/myDir/fooDir/foo.txt");
        this.createFile("/myDir/fooDir/bar.txt");
        this.createDir("/myDir/barDir");
        return dir;
    }

    private File createFile(String pathname) throws IOException {
        File file = this.fs.getFile(pathname);
        assert (file.createNewFile());
        return file;
    }

    private int numberOfChunksInCache() {
        return this.dataCache.size();
    }

    private int numberOfMetadataEntries() {
        return this.metadataCache.size();
    }

    private void appendToFile(String filePath, String text) throws IOException {
        this.appendToFile(filePath, text, null);
    }

    private void appendToFile(String filePath, String text, Integer chunkSize) throws IOException {
        this.writeToFile(filePath, text, true, chunkSize);
    }

    private void writeToFile(String filePath, String text) throws IOException {
        this.writeToFile(filePath, text, null);
    }

    private void writeToFile(String filePath, String text, Integer chunkSize) throws IOException {
        this.writeToFile(filePath, text, false, chunkSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String filePath, String text, boolean append, Integer chunkSize) throws IOException {
        OutputStream out = chunkSize == null ? this.fs.getOutput(filePath, append) : this.fs.getOutput(filePath, append, chunkSize.intValue());
        try {
            out.write(text.getBytes());
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContents(String filePath) throws IOException {
        InputStream in = this.fs.getInput(filePath);
        try {
            byte[] buf = new byte[1000];
            int bytesRead = in.read(buf);
            String string = new String(buf, 0, bytesRead);
            return string;
        }
        finally {
            in.close();
        }
    }

    private static class FooFileFilter
    implements FileFilter {
        private FooFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith("foo");
        }
    }

    private static class FooFilenameFilter
    implements FilenameFilter {
        private File expectedDir;

        private FooFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.expectedDir != null) {
                Assert.assertEquals((Object)dir, (Object)this.expectedDir, (String)"accept() invoked with unexpected dir");
            }
            return name.startsWith("foo");
        }

        public void expectDir(File dir) {
            this.expectedDir = dir;
        }
    }
}

