/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jmx.MvccLockManagerMBeanTest")
public class MvccLockManagerMBeanTest
extends SingleCacheManagerTest {
    public static final int CONCURRENCY_LEVEL = 129;
    private ObjectName lockManagerObjName;
    private MBeanServer threadMBeanServer;
    private static final String JMX_DOMAIN = "MvccLockManagerMBeanTest";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault().fluent().globalJmxStatistics().mBeanServerLookupClass(PerThreadMBeanServerLookup.class).jmxDomain(JMX_DOMAIN).build();
        this.cacheManager = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(globalConfiguration);
        Configuration configuration = this.getDefaultStandaloneConfig(true).fluent().jmxStatistics().locking().concurrencyLevel(Integer.valueOf(129)).useLockStriping(Boolean.valueOf(true)).transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).build();
        this.cacheManager.defineConfiguration("test", configuration);
        this.cache = this.cacheManager.getCache("test");
        this.lockManagerObjName = TestingUtil.getCacheObjectName(JMX_DOMAIN, "test(local)", "LockManager");
        this.threadMBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        return this.cacheManager;
    }

    public void testJmxOperationMetadata() throws Exception {
        TestingUtil.checkMBeanOperationParameterNaming(this.lockManagerObjName);
    }

    public void testConcurrencyLevel() throws Exception {
        this.assertAttributeValue("ConcurrencyLevel", 129);
    }

    public void testNumberOfLocksHeld() throws Exception {
        DummyTransactionManager tm = (DummyTransactionManager)TestingUtil.extractComponent(this.cache, TransactionManager.class);
        tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        tm.getTransaction().runPrepare();
        this.assertAttributeValue("NumberOfLocksHeld", 1);
        tm.getTransaction().runCommitTx();
        this.assertAttributeValue("NumberOfLocksHeld", 0);
    }

    public void testNumberOfLocksAvailable() throws Exception {
        DummyTransactionManager tm = (DummyTransactionManager)TestingUtil.extractComponent(this.cache, TransactionManager.class);
        int initialAvailable = this.getAttrValue("NumberOfLocksAvailable");
        tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        tm.getTransaction().runPrepare();
        this.assertAttributeValue("NumberOfLocksHeld", 1);
        this.assertAttributeValue("NumberOfLocksAvailable", initialAvailable - 1);
        tm.rollback();
        this.assertAttributeValue("NumberOfLocksAvailable", initialAvailable);
        this.assertAttributeValue("NumberOfLocksHeld", 0);
    }

    private void assertAttributeValue(String attrName, int expectedVal) throws Exception {
        int cl = this.getAttrValue(attrName);
        assert (cl == expectedVal) : "expected " + expectedVal + ", but received " + cl;
    }

    private int getAttrValue(String attrName) throws Exception {
        return Integer.parseInt(this.threadMBeanServer.getAttribute(this.lockManagerObjName, attrName).toString());
    }
}

