/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.util.concurrent.ExecutorService;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.ReflectionUtil;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.AbstractCacheStoreTest")
public class AbstractCacheStoreTest
extends AbstractInfinispanTest {
    private AbstractCacheStore cs;
    private AbstractCacheStoreConfig cfg;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws NoSuchMethodException, CacheLoaderException {
        this.cs = (AbstractCacheStore)Mockito.mock(AbstractCacheStore.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.cfg = new AbstractCacheStoreConfig();
        this.cs.init((CacheLoaderConfig)this.cfg, null, null);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheLoaderException {
        this.cs.stop();
        this.cs = null;
        this.cfg = null;
    }

    @Test
    void testSyncExecutorIsSetWhenCfgPurgeSyncIsTrueOnStart() throws Exception {
        this.cfg.setPurgeSynchronously(Boolean.valueOf(true));
        this.cs.start();
        ExecutorService service = (ExecutorService)ReflectionUtil.getValue((Object)this.cs, (String)"purgerService");
        assert (service instanceof WithinThreadExecutor);
    }

    @Test
    void testAsyncExecutorIsDefaultOnStart() throws Exception {
        this.cs.start();
        ExecutorService service = (ExecutorService)ReflectionUtil.getValue((Object)this.cs, (String)"purgerService");
        assert (!(service instanceof WithinThreadExecutor));
    }
}

