/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.UnclosableObjectInputStream;
import org.infinispan.io.UnclosableObjectOutputStream;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.Util;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="loaders.BaseCacheStoreTest")
public abstract class BaseCacheStoreTest
extends AbstractInfinispanTest {
    protected CacheStore cs;
    protected TransactionFactory gtf = new TransactionFactory();

    protected abstract CacheStore createCacheStore() throws Exception;

    protected BaseCacheStoreTest() {
        this.gtf.init(false, false, true, false);
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        try {
            this.cs = this.createCacheStore();
            assert (this.cs.getCacheStoreConfig() == null || this.cs.getCacheStoreConfig().isPurgeSynchronously().booleanValue()) : "Cache store tests expect purgeSynchronously to be enabled";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheLoaderException {
        try {
            if (this.cs != null) {
                this.cs.clear();
                this.cs.stop();
            }
        }
        finally {
            this.cs = null;
        }
    }

    @AfterMethod(alwaysRun=false)
    public void assertNoLocksHeld(Method m) {
        if (this.cs instanceof LockSupportCacheStore) {
            int totalLockCount = ((LockSupportCacheStore)this.cs).getTotalLockCount();
            assert (totalLockCount == 0) : "Lock count for test method " + m.getName() + " is " + totalLockCount;
        }
    }

    protected Cache getCache() {
        Cache c = (Cache)Mockito.mock(Cache.class);
        Mockito.when((Object)c.getName()).thenReturn((Object)("mockCache-" + this.getClass().getName()));
        return c;
    }

    protected StreamingMarshaller getMarshaller() {
        return new TestObjectStreamMarshaller(false);
    }

    public void testLoadAndStoreImmortal() throws CacheLoaderException {
        assert (!this.cs.containsKey((Object)"k"));
        InternalCacheEntry se = TestInternalCacheEntryFactory.create("k", "v");
        this.cs.store(se);
        assert (this.cs.load((Object)"k").getValue().equals("v"));
        assert (this.cs.load((Object)"k").getLifespan() == -1L);
        assert (this.cs.load((Object)"k").getMaxIdle() == -1L);
        assert (!this.cs.load((Object)"k").isExpired(System.currentTimeMillis()));
        assert (this.cs.containsKey((Object)"k"));
        boolean removed = this.cs.remove((Object)"k2");
        assert (!removed);
    }

    public void testLoadAndStoreWithLifespan() throws Exception {
        assert (!this.cs.containsKey((Object)"k"));
        long lifespan = 120000L;
        InternalCacheEntry se = TestInternalCacheEntryFactory.create("k", "v", lifespan);
        this.cs.store(se);
        assert (this.cs.containsKey((Object)"k"));
        InternalCacheEntry ice = this.cs.load((Object)"k");
        this.assertCorrectExpiry(ice, "v", lifespan, -1L, false);
        ice = (InternalCacheEntry)this.cs.loadAll().iterator().next();
        this.assertCorrectExpiry(ice, "v", lifespan, -1L, false);
        lifespan = 1L;
        se = TestInternalCacheEntryFactory.create("k", "v", lifespan);
        this.cs.store(se);
        Thread.sleep(100L);
        this.purgeExpired();
        assert (se.isExpired(System.currentTimeMillis()));
        this.assertEventuallyExpires("k");
        assert (!this.cs.containsKey((Object)"k"));
        assert (this.cs.loadAll().isEmpty());
    }

    private void assertCorrectExpiry(InternalCacheEntry ice, String value, long lifespan, long maxIdle, boolean expired) {
        assert (ice != null) : "Cache entry is null";
        assert (Util.safeEquals((Object)ice.getValue(), (Object)value)) : ice.getValue() + " was not " + value;
        assert (ice.getLifespan() == lifespan) : ice.getLifespan() + " was not " + lifespan;
        assert (ice.getMaxIdle() == maxIdle) : ice.getMaxIdle() + " was not " + maxIdle;
        if (lifespan > -1L) assert (ice.getCreated() > -1L) : "Created is -1 when maxIdle is set";
        if (maxIdle > -1L) assert (ice.getLastUsed() > -1L) : "LastUsed is -1 when maxIdle is set";
        assert (expired == ice.isExpired(System.currentTimeMillis())) : "isExpired() is not " + expired;
    }

    public void testLoadAndStoreWithIdle() throws Exception {
        assert (!this.cs.containsKey((Object)"k"));
        long idle = 120000L;
        InternalCacheEntry se = TestInternalCacheEntryFactory.create("k", "v", -1L, idle);
        this.cs.store(se);
        assert (this.cs.containsKey((Object)"k"));
        InternalCacheEntry ice = this.cs.load((Object)"k");
        this.assertCorrectExpiry(ice, "v", -1L, idle, false);
        ice = (InternalCacheEntry)this.cs.loadAll().iterator().next();
        this.assertCorrectExpiry(ice, "v", -1L, idle, false);
        idle = 1L;
        se = TestInternalCacheEntryFactory.create("k", "v", -1L, idle);
        this.cs.store(se);
        Thread.sleep(100L);
        this.purgeExpired();
        assert (se.isExpired(System.currentTimeMillis()));
        this.assertEventuallyExpires("k");
        assert (!this.cs.containsKey((Object)"k"));
        assert (this.cs.loadAll().isEmpty());
    }

    protected void assertEventuallyExpires(String key) throws Exception {
        assert (this.cs.load((Object)key) == null);
    }

    protected void purgeExpired() throws CacheLoaderException {
        this.cs.purgeExpired();
    }

    public void testLoadAndStoreWithLifespanAndIdle() throws Exception {
        assert (!this.cs.containsKey((Object)"k"));
        long lifespan = 200000L;
        long idle = 120000L;
        InternalCacheEntry se = TestInternalCacheEntryFactory.create("k", "v", lifespan, idle);
        this.cs.store(se);
        assert (this.cs.containsKey((Object)"k"));
        InternalCacheEntry ice = this.cs.load((Object)"k");
        this.assertCorrectExpiry(ice, "v", lifespan, idle, false);
        ice = (InternalCacheEntry)this.cs.loadAll().iterator().next();
        this.assertCorrectExpiry(ice, "v", lifespan, idle, false);
        idle = 1L;
        se = TestInternalCacheEntryFactory.create("k", "v", lifespan, idle);
        this.cs.store(se);
        Thread.sleep(100L);
        this.purgeExpired();
        assert (se.isExpired(System.currentTimeMillis()));
        this.assertEventuallyExpires("k");
        assert (!this.cs.containsKey((Object)"k"));
        assert (this.cs.loadAll().isEmpty());
    }

    public void testStopStartDoesNotNukeValues() throws InterruptedException, CacheLoaderException {
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        long lifespan = 1L;
        long idle = 1L;
        InternalCacheEntry se1 = TestInternalCacheEntryFactory.create("k1", "v1", lifespan);
        InternalCacheEntry se2 = TestInternalCacheEntryFactory.create("k2", "v2");
        InternalCacheEntry se3 = TestInternalCacheEntryFactory.create("k3", "v3", -1L, idle);
        InternalCacheEntry se4 = TestInternalCacheEntryFactory.create("k4", "v4", lifespan, idle);
        this.cs.store(se1);
        this.cs.store(se2);
        this.cs.store(se3);
        this.cs.store(se4);
        this.sleepForStopStartTest();
        this.cs.stop();
        this.cs.start();
        assert (se1.isExpired(System.currentTimeMillis()));
        assert (this.cs.load((Object)"k1") == null);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (this.cs.load((Object)"k2") != null);
        assert (this.cs.containsKey((Object)"k2"));
        assert (this.cs.load((Object)"k2").getValue().equals("v2"));
        assert (se3.isExpired(System.currentTimeMillis()));
        assert (this.cs.load((Object)"k3") == null);
        assert (!this.cs.containsKey((Object)"k3"));
        assert (se3.isExpired(System.currentTimeMillis()));
        assert (this.cs.load((Object)"k3") == null);
        assert (!this.cs.containsKey((Object)"k3"));
    }

    protected void sleepForStopStartTest() throws InterruptedException {
        Thread.sleep(100L);
    }

    public void testOnePhaseCommit() throws CacheLoaderException {
        ArrayList<Object> mods = new ArrayList<Object>();
        mods.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2")));
        mods.add(new Remove((Object)"k1"));
        GlobalTransaction tx = this.gtf.newGlobalTransaction(null, true);
        this.cs.prepare(mods, tx, true);
        assert (this.cs.load((Object)"k2").getValue().equals("v2"));
        assert (!this.cs.containsKey((Object)"k1"));
        this.cs.clear();
        mods = new ArrayList();
        mods.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k3", "v3")));
        this.cs.prepare(mods, tx, true);
        assert (this.cs.containsKey((Object)"k1"));
        assert (this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"k3"));
    }

    public void testTwoPhaseCommit() throws CacheLoaderException {
        ArrayList<Object> mods = new ArrayList<Object>();
        mods.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2")));
        mods.add(new Remove((Object)"k1"));
        GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
        this.cs.prepare(mods, tx, false);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        this.cs.commit(tx);
        assert (this.cs.load((Object)"k2").getValue().equals("v2"));
        assert (!this.cs.containsKey((Object)"k1"));
        this.cs.clear();
        mods = new ArrayList();
        mods.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k3", "v3")));
        this.cs.prepare(mods, tx, false);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (!this.cs.containsKey((Object)"k3"));
        this.cs.commit(tx);
        assert (this.cs.containsKey((Object)"k1"));
        assert (this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"k3"));
    }

    public void testRollback() throws CacheLoaderException {
        this.cs.store(TestInternalCacheEntryFactory.create("old", "old"));
        ArrayList<Object> mods = new ArrayList<Object>();
        mods.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2")));
        mods.add(new Remove((Object)"k1"));
        mods.add(new Remove((Object)"old"));
        GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
        this.cs.prepare(mods, tx, false);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"old"));
        this.cs.rollback(tx);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"old"));
        mods = new ArrayList();
        mods.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2")));
        mods.add(new Clear());
        mods.add(new Store(TestInternalCacheEntryFactory.create("k3", "v3")));
        this.cs.prepare(mods, tx, false);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (!this.cs.containsKey((Object)"k3"));
        this.cs.rollback(tx);
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (!this.cs.containsKey((Object)"k3"));
        assert (this.cs.containsKey((Object)"old"));
    }

    public void testRollbackFromADifferentThreadReusingTransactionKey() throws CacheLoaderException, InterruptedException {
        this.cs.store(TestInternalCacheEntryFactory.create("old", "old"));
        ArrayList<Object> mods = new ArrayList<Object>();
        mods.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2")));
        mods.add(new Remove((Object)"k1"));
        mods.add(new Remove((Object)"old"));
        final GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
        this.cs.prepare(mods, tx, false);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                BaseCacheStoreTest.this.cs.rollback(tx);
            }
        });
        t.start();
        t.join();
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"old"));
        mods = new ArrayList();
        mods.add(new Store(TestInternalCacheEntryFactory.create("k1", "v1")));
        mods.add(new Store(TestInternalCacheEntryFactory.create("k2", "v2")));
        mods.add(new Clear());
        mods.add(new Store(TestInternalCacheEntryFactory.create("k3", "v3")));
        this.cs.prepare(mods, tx, false);
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                BaseCacheStoreTest.this.cs.rollback(tx);
            }
        });
        t2.start();
        t2.join();
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (!this.cs.containsKey((Object)"k3"));
        assert (this.cs.containsKey((Object)"old"));
    }

    public void testCommitAndRollbackWithoutPrepare() throws CacheLoaderException {
        this.cs.store(TestInternalCacheEntryFactory.create("old", "old"));
        GlobalTransaction tx = this.gtf.newGlobalTransaction(null, false);
        this.cs.commit(tx);
        this.cs.store(TestInternalCacheEntryFactory.create("old", "old"));
        this.cs.rollback(tx);
        assert (this.cs.containsKey((Object)"old"));
    }

    public void testPreload() throws Exception {
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        this.cs.store(TestInternalCacheEntryFactory.create("k3", "v3"));
        Set set = this.cs.loadAll();
        assert (set.size() == 3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    public void testPreloadWithMaxSize() throws CacheLoaderException {
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        this.cs.store(TestInternalCacheEntryFactory.create("k3", "v3"));
        Set set = this.cs.load(2);
        AssertJUnit.assertEquals((int)2, (int)set.size());
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.size() == 1);
    }

    public void testStoreAndRemoveAll() throws CacheLoaderException {
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        this.cs.store(TestInternalCacheEntryFactory.create("k3", "v3"));
        this.cs.store(TestInternalCacheEntryFactory.create("k4", "v4"));
        Set set = this.cs.loadAll();
        assert (set.size() == 4);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        expected.add("k4");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
        HashSet<String> toRemove = new HashSet<String>();
        toRemove.add("k1");
        toRemove.add("k2");
        toRemove.add("k3");
        this.cs.removeAll(toRemove);
        set = this.cs.loadAll();
        assert (set.size() == 1);
        set.remove("k4");
        assert (expected.isEmpty());
    }

    public void testPurgeExpired() throws Exception {
        long lifespan = 6000L;
        long idle = 4000L;
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1", lifespan));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v2", -1L, idle));
        this.cs.store(TestInternalCacheEntryFactory.create("k3", "v3", lifespan, idle));
        this.cs.store(TestInternalCacheEntryFactory.create("k4", "v4", -1L, -1L));
        this.cs.store(TestInternalCacheEntryFactory.create("k5", "v5", lifespan * 1000L, idle * 1000L));
        assert (this.cs.containsKey((Object)"k1"));
        assert (this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"k3"));
        assert (this.cs.containsKey((Object)"k4"));
        assert (this.cs.containsKey((Object)"k5"));
        Thread.sleep(lifespan + 10L);
        this.purgeExpired();
        assert (!this.cs.containsKey((Object)"k1"));
        assert (!this.cs.containsKey((Object)"k2"));
        assert (!this.cs.containsKey((Object)"k3"));
        assert (this.cs.containsKey((Object)"k4"));
        assert (this.cs.containsKey((Object)"k5"));
    }

    public void testLoadKeys() throws CacheLoaderException {
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v"));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v"));
        this.cs.store(TestInternalCacheEntryFactory.create("k3", "v"));
        this.cs.store(TestInternalCacheEntryFactory.create("k4", "v"));
        this.cs.store(TestInternalCacheEntryFactory.create("k5", "v"));
        Set s = this.cs.loadAllKeys(null);
        assert (s.size() == 5) : "Expected 5 keys, was " + s;
        s = this.cs.loadAllKeys(Collections.emptySet());
        assert (s.size() == 5) : "Expected 5 keys, was " + s;
        Set<String> excl = Collections.singleton("k3");
        s = this.cs.loadAllKeys(excl);
        assert (s.size() == 4) : "Expected 4 keys but was " + s;
        assert (!s.contains("k3"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamingAPI() throws IOException, CacheLoaderException {
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        this.cs.store(TestInternalCacheEntryFactory.create("k3", "v3"));
        StreamingMarshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false, 12);
        try {
            this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
            this.cs.clear();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            this.cs.fromStream((ObjectInput)new UnclosableObjectInputStream(oi));
        }
        finally {
            marshaller.finishObjectInput(oi);
            in.close();
        }
        Set set = this.cs.loadAll();
        assert (set.size() == 3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamingAPIReusingStreams() throws IOException, CacheLoaderException {
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1"));
        this.cs.store(TestInternalCacheEntryFactory.create("k2", "v2"));
        this.cs.store(TestInternalCacheEntryFactory.create("k3", "v3"));
        StreamingMarshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] dummyStartBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] dummyEndBytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false, 12);
        try {
            oo.write(dummyStartBytes);
            this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
            oo.flush();
            oo.write(dummyEndBytes);
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
            this.cs.clear();
        }
        byte[] dummy = new byte[8];
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            byte i;
            int bytesRead = oi.read(dummy, 0, 8);
            assert (bytesRead == 8);
            for (i = 1; i < 9; ++i) {
                assert (dummy[i - 1] == i) : "Start byte stream corrupted!";
            }
            this.cs.fromStream((ObjectInput)new UnclosableObjectInputStream(oi));
            bytesRead = oi.read(dummy, 0, 8);
            assert (bytesRead == 8);
            for (i = 8; i > 0; --i) {
                assert (dummy[8 - i] == i) : "Start byte stream corrupted!";
            }
        }
        finally {
            marshaller.finishObjectInput(oi);
            in.close();
        }
        Set set = this.cs.loadAll();
        assert (set.size() == 3);
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    public void testConfigFile() throws Exception {
        Class cfgClass = this.cs.getConfigurationClass();
        CacheLoaderConfig clc = (CacheLoaderConfig)Util.getInstance((Class)cfgClass);
        assert (clc.getCacheLoaderClassName().equals(this.cs.getClass().getName())) : "Cache loaders doesn't provide a proper configuration type that is capable of creating the loaders!";
    }

    public void testConcurrency() throws Exception {
        int i;
        int numThreads = 3;
        int loops = 500;
        final String[] keys = new String[10];
        final String[] values = new String[10];
        for (i = 0; i < 10; ++i) {
            keys[i] = "k" + i;
        }
        for (i = 0; i < 10; ++i) {
            values[i] = "v" + i;
        }
        final Random r = new Random();
        final LinkedList exceptions = new LinkedList();
        final Runnable store = new Runnable(){

            @Override
            public void run() {
                try {
                    int randomInt = r.nextInt(10);
                    BaseCacheStoreTest.this.cs.store(TestInternalCacheEntryFactory.create(keys[randomInt], values[randomInt]));
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        final Runnable remove = new Runnable(){

            @Override
            public void run() {
                try {
                    BaseCacheStoreTest.this.cs.remove((Object)keys[r.nextInt(10)]);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        final Runnable get = new Runnable(){

            @Override
            public void run() {
                try {
                    int randomInt = r.nextInt(10);
                    InternalCacheEntry se = BaseCacheStoreTest.this.cs.load((Object)keys[randomInt]);
                    assert (se == null || se.getValue().equals(values[randomInt]));
                    BaseCacheStoreTest.this.cs.loadAll();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        Thread[] threads = new Thread[numThreads];
        for (int i2 = 0; i2 < numThreads; ++i2) {
            threads[i2] = new Thread(this.getClass().getSimpleName() + "-" + i2){

                @Override
                public void run() {
                    for (int i = 0; i < 500; ++i) {
                        store.run();
                        remove.run();
                        get.run();
                    }
                }
            };
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        if (!exceptions.isEmpty()) {
            throw (Exception)exceptions.get(0);
        }
    }

    public void testReplaceExpiredEntry() throws Exception {
        InternalCacheEntry entry;
        long startTime = System.currentTimeMillis();
        long lifespan = 3000L;
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v1", 3000L));
        while (true) {
            entry = this.cs.load((Object)"k1");
            if (System.currentTimeMillis() >= startTime + 3000L) break;
            assert (entry.getValue().equals("v1"));
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 3000L + 20000L && this.cs.load((Object)"k1") != null) {
        }
        assert (null == this.cs.load((Object)"k1"));
        this.cs.store(TestInternalCacheEntryFactory.create("k1", "v2", 3000L));
        while (true) {
            entry = this.cs.load((Object)"k1");
            if (System.currentTimeMillis() >= startTime + 3000L) break;
            assert (entry.getValue().equals("v2"));
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 3000L + 20000L && this.cs.load((Object)"k1") != null) {
        }
        assert (null == this.cs.load((Object)"k1"));
    }

    public void testLoadAndStoreMarshalledValues() throws CacheLoaderException {
        MarshalledValue key = new MarshalledValue((Object)new Pojo().role("key"), true, this.getMarshaller());
        MarshalledValue key2 = new MarshalledValue((Object)new Pojo().role("key2"), true, this.getMarshaller());
        MarshalledValue value = new MarshalledValue((Object)new Pojo().role("value"), true, this.getMarshaller());
        assert (!this.cs.containsKey((Object)key));
        InternalCacheEntry se = TestInternalCacheEntryFactory.create(key, value);
        this.cs.store(se);
        assert (this.cs.load((Object)key).getValue().equals(value));
        assert (this.cs.load((Object)key).getLifespan() == -1L);
        assert (this.cs.load((Object)key).getMaxIdle() == -1L);
        assert (!this.cs.load((Object)key).isExpired(System.currentTimeMillis()));
        assert (this.cs.containsKey((Object)key));
        boolean removed = this.cs.remove((Object)key2);
        assert (!removed);
        assert (this.cs.remove((Object)key));
    }

    public static class Pojo
    implements Serializable {
        private String role;

        public Pojo role(String role) {
            this.role = role;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            return !(this.role != null ? !this.role.equals(pojo.role) : pojo.role != null);
        }

        public int hashCode() {
            return this.role != null ? this.role.hashCode() : 0;
        }
    }
}

