/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.HashMap;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.MainOwnerChangesLockTest")
@CleanupAfterMethod
public class MainOwnerChangesLockTest
extends MultipleCacheManagersTest {
    public static final int NUM_KEYS = 100;
    private ConfigurationBuilder dccc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dccc = MainOwnerChangesLockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.dccc.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.dccc.clustering().hash().l1().disable().onRehash(false).locking().lockAcquisitionTimeout(1000L);
        this.dccc.clustering().stateTransfer().fetchInMemoryState(true);
        this.createCluster(this.dccc, 2);
        this.waitForClusterToForm();
    }

    public void testLocalTxLockMigration() throws Exception {
        this.testLockMigration(0);
    }

    public void testRemoteTxLockMigration() throws Exception {
        this.testLockMigration(1);
    }

    private void testLockMigration(int nodeThatPuts) throws Exception {
        HashMap<Object, DummyTransaction> key2Tx = new HashMap<Object, DummyTransaction>();
        for (int i = 0; i < 100; ++i) {
            Object key = this.getKeyForCache(0);
            if (key2Tx.containsKey(key)) continue;
            this.dummyTm(nodeThatPuts).begin();
            this.cache(nodeThatPuts).put(key, key);
            DummyTransaction tx = this.dummyTm(nodeThatPuts).getTransaction();
            tx.runPrepare();
            this.dummyTm(nodeThatPuts).suspend();
            key2Tx.put(key, tx);
            this.assertLocked(0, key);
        }
        this.log.trace((Object)"Lock transfer happens here");
        this.addClusterEnabledCacheManager(this.dccc);
        this.waitForClusterToForm();
        Object migratedKey = null;
        ConsistentHash ch = this.advancedCache(2).getDistributionManager().getConsistentHash();
        for (Object key : key2Tx.keySet()) {
            if (!ch.locatePrimaryOwner(key).equals(this.address(2))) continue;
            migratedKey = key;
            break;
        }
        if (migratedKey == null) {
            this.log.trace((Object)"No key migrated to new owner.");
        } else {
            this.log.trace((Object)("migratedKey = " + migratedKey));
            this.dummyTm(2).begin();
            this.cache(2).put(migratedKey, (Object)"someValue");
            try {
                this.dummyTm(2).commit();
                AssertJUnit.fail((String)"RollbackException should have been thrown here.");
            }
            catch (RollbackException e) {
                // empty catch block
            }
        }
        this.log.trace((Object)"About to commit existing transactions.");
        this.log.trace((Object)"Committing the tx to the new node.");
        for (DummyTransaction tx : key2Tx.values()) {
            this.tm(nodeThatPuts).resume((Transaction)tx);
            this.dummyTm(nodeThatPuts).getTransaction().runCommitTx();
        }
        for (Object key : key2Tx.keySet()) {
            Object value = this.getValue(key);
            AssertJUnit.assertEquals(key, (Object)value);
        }
    }

    private Object getValue(Object key) {
        this.log.tracef("Checking key: %s", key);
        InternalCacheEntry d0 = this.advancedCache(0).getDataContainer().get(key);
        InternalCacheEntry d1 = this.advancedCache(1).getDataContainer().get(key);
        InternalCacheEntry d2 = this.advancedCache(2).getDataContainer().get(key);
        if (d0 == null) {
            assert (this.sameValue(d1, d2));
            return d1.getValue();
        }
        if (d1 == null) {
            assert (this.sameValue(d0, d2));
            return d0.getValue();
        }
        if (d2 == null) {
            assert (this.sameValue(d0, d1));
            return d0.getValue();
        }
        throw new RuntimeException();
    }

    private boolean sameValue(InternalCacheEntry d1, InternalCacheEntry d2) {
        return d1.getValue().equals(d2.getValue());
    }

    private DummyTransactionManager dummyTm(int cacheIndex) {
        return (DummyTransactionManager)this.tm(cacheIndex);
    }
}

