/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.pessimistic;

import javax.transaction.Transaction;
import org.infinispan.config.Configuration;
import org.infinispan.lock.singlelock.AbstractNoCrashTest;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.DummyTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.BasicSingleLockPessimisticTest")
public class BasicSingleLockPessimisticTest
extends AbstractNoCrashTest {
    public BasicSingleLockPessimisticTest() {
        super(Configuration.CacheMode.DIST_SYNC, LockingMode.PESSIMISTIC, false);
    }

    @Override
    protected void testTxAndLockOnDifferentNodes(AbstractNoCrashTest.Operation operation, boolean addFirst, boolean removed) throws Exception {
        Object k = this.getKeyForCache(1);
        if (addFirst) {
            this.cache(0).put(k, (Object)"v_initial");
        }
        this.assertNotLocked(k);
        this.tm(0).begin();
        operation.perform(k, 0);
        assert (!this.lockManager(0).isLocked(k));
        assert (this.lockManager(1).isLocked(k));
        assert (!this.lockManager(2).isLocked(k));
        this.tm(0).commit();
        this.assertNotLocked(k);
        this.assertValue(k, removed);
    }

    public void testMultipleLocksInSameTx() throws Exception {
        Object k1 = this.getKeyForCache(1);
        Object k2 = this.getKeyForCache(2);
        Assert.assertEquals(this.advancedCache(0).getDistributionManager().locate(k1).get(0), (Object)this.address(1));
        this.log.tracef("k1=%s, k2=%s", k1, k2);
        this.tm(0).begin();
        this.cache(0).put(k1, (Object)"v");
        this.cache(0).put(k2, (Object)"v");
        assert (!this.lockManager(0).isLocked(k1));
        assert (this.lockManager(1).isLocked(k1));
        assert (!this.lockManager(2).isLocked(k1));
        assert (!this.lockManager(0).isLocked(k2));
        assert (!this.lockManager(1).isLocked(k2));
        assert (this.lockManager(2).isLocked(k2));
        this.tm(0).commit();
        this.assertNotLocked(k1);
        this.assertNotLocked(k2);
        this.assertValue(k1, false);
        this.assertValue(k2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSecondTxCannotPrepare() throws Exception {
        Object k = this.getKeyForCache(0);
        Object k1 = this.getKeyForCache(1);
        this.tm(0).begin();
        this.cache(0).put(k, (Object)"v");
        DummyTransaction dtm = (DummyTransaction)this.tm(0).getTransaction();
        this.tm(0).suspend();
        assert (this.checkTxCount(0, 1, 0));
        assert (this.checkTxCount(1, 0, 0));
        assert (this.checkTxCount(2, 0, 0));
        this.tm(0).begin();
        this.cache(0).put(k1, (Object)"some");
        try {
            this.cache(0).put(k, (Object)"other");
        }
        catch (Throwable e) {
        }
        finally {
            this.tm(0).rollback();
        }
        this.assertNotLocked(k1);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockPessimisticTest.this.checkTxCount(0, 1, 0) && BasicSingleLockPessimisticTest.this.checkTxCount(1, 0, 0) && BasicSingleLockPessimisticTest.this.checkTxCount(2, 0, 0);
            }
        });
        this.log.info((Object)"Before second failure");
        this.tm(1).begin();
        this.cache(1).put(k1, (Object)"some");
        try {
            this.cache(1).put(k, (Object)"other");
            assert (false);
        }
        catch (Throwable e) {
        }
        finally {
            this.tm(1).rollback();
        }
        this.assertNotLocked(k1);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockPessimisticTest.this.checkTxCount(0, 1, 0) && BasicSingleLockPessimisticTest.this.checkTxCount(1, 0, 0) && BasicSingleLockPessimisticTest.this.checkTxCount(1, 0, 0);
            }
        });
        this.log.trace((Object)"about to commit transaction.");
        this.tm(0).resume((Transaction)dtm);
        dtm.runPrepare();
        dtm.runCommitTx();
        this.tm(0).suspend();
        this.assertValue(k, false);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return BasicSingleLockPessimisticTest.this.noPendingTransactions(0) && BasicSingleLockPessimisticTest.this.noPendingTransactions(1) && BasicSingleLockPessimisticTest.this.noPendingTransactions(2);
            }
        });
    }
}

