/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.MarshalledValueInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ObjectDuplicator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.MarshalledValueTest")
public class MarshalledValueTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(MarshalledValueTest.class);
    private MarshalledValueListenerInterceptor mvli;
    String k = "key";
    String v = "value";

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration replSync = MarshalledValueTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC).fluent().storeAsBinary().build();
        this.createClusteredCaches(2, "replSync", replSync);
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.assertMarshalledValueInterceptorPresent(cache1);
        this.assertMarshalledValueInterceptorPresent(cache2);
    }

    private void assertMarshalledValueInterceptorPresent(Cache c) {
        InterceptorChain ic1 = TestingUtil.extractComponent(c, InterceptorChain.class);
        assert (ic1.containsInterceptorType(MarshalledValueInterceptor.class));
    }

    @BeforeMethod
    public void addMarshalledValueInterceptor() {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        InterceptorChain chain = TestingUtil.extractComponent(cache1, InterceptorChain.class);
        chain.removeInterceptor(MarshalledValueListenerInterceptor.class);
        this.mvli = new MarshalledValueListenerInterceptor();
        chain.addInterceptorAfter((CommandInterceptor)this.mvli, MarshalledValueInterceptor.class);
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        Pojo.serializationCount = 0;
        Pojo.deserializationCount = 0;
    }

    private void assertOnlyOneRepresentationExists(MarshalledValue mv) {
        assert (mv.instance != null && mv.raw == null || mv.instance == null && mv.raw != null) : "Only instance or raw representations should exist in a MarshalledValue; never both";
    }

    private void assertSerialized(MarshalledValue mv) {
        assert (mv.raw != null) : "Should be serialized";
    }

    private void assertDeserialized(MarshalledValue mv) {
        assert (mv.instance != null) : "Should be deserialized";
    }

    private void assertSerializationCounts(int serializationCount, int deserializationCount) {
        assert (Pojo.serializationCount == serializationCount) : "Serialization count: expected " + serializationCount + " but was " + Pojo.serializationCount;
        assert (Pojo.deserializationCount == deserializationCount) : "Deserialization count: expected " + deserializationCount + " but was " + Pojo.deserializationCount;
    }

    public void testNonSerializable() {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        try {
            cache1.put((Object)"Hello", new Object());
            assert (false) : "Should have failed";
        }
        catch (CacheException expected) {
            // empty catch block
        }
        assert (this.mvli.invocationCount == 0) : "Call should not have gone beyond the MarshalledValueInterceptor";
        try {
            cache1.put(new Object(), (Object)"Hello");
            assert (false) : "Should have failed";
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        assert (this.mvli.invocationCount == 0) : "Call should not have gone beyond the MarshalledValueInterceptor";
    }

    public void testReleaseObjectValueReferences() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        assert (cache1.isEmpty());
        Pojo value = new Pojo();
        System.out.println(TestingUtil.extractComponent(cache1, InterceptorChain.class).toString());
        cache1.put((Object)"key", (Object)value);
        assert (cache1.containsKey((Object)"key"));
        this.assertSerializationCounts(1, 0);
        DataContainer dc1 = TestingUtil.extractComponent(cache1, DataContainer.class);
        InternalCacheEntry ice = dc1.get((Object)"key");
        Object o = ice.getValue();
        assert (o instanceof MarshalledValue);
        MarshalledValue mv = (MarshalledValue)o;
        this.assertDeserialized(mv);
        assert (cache1.get((Object)"key").equals(value));
        this.assertDeserialized(mv);
        this.assertSerializationCounts(1, 0);
        cache1.compact();
        this.assertSerializationCounts(2, 0);
        this.assertOnlyOneRepresentationExists(mv);
        this.assertSerialized(mv);
        DataContainer dc2 = TestingUtil.extractComponent(cache2, DataContainer.class);
        ice = dc2.get((Object)"key");
        o = ice.getValue();
        assert (o instanceof MarshalledValue);
        mv = (MarshalledValue)o;
        this.assertSerialized(mv);
        assert (cache2.get((Object)"key").equals(value));
        this.assertDeserialized(mv);
        this.assertSerializationCounts(2, 1);
        cache2.compact();
        this.assertSerializationCounts(2, 1);
        this.assertOnlyOneRepresentationExists(mv);
        this.assertSerialized(mv);
    }

    public void testReleaseObjectKeyReferences() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        Pojo key = new Pojo();
        cache1.put((Object)key, (Object)"value");
        this.assertSerializationCounts(1, 0);
        DataContainer dc1 = TestingUtil.extractComponent(cache1, DataContainer.class);
        Object o = dc1.keySet().iterator().next();
        assert (o instanceof MarshalledValue);
        MarshalledValue mv = (MarshalledValue)o;
        this.assertDeserialized(mv);
        assert (cache1.get((Object)key).equals("value"));
        this.assertDeserialized(mv);
        this.assertSerializationCounts(1, 0);
        cache1.compact();
        this.assertSerializationCounts(2, 0);
        this.assertOnlyOneRepresentationExists(mv);
        this.assertSerialized(mv);
        DataContainer dc2 = TestingUtil.extractComponent(cache2, DataContainer.class);
        o = dc2.keySet().iterator().next();
        assert (o instanceof MarshalledValue);
        mv = (MarshalledValue)o;
        this.assertSerialized(mv);
        assert (cache2.get((Object)key).equals("value"));
        this.assertSerializationCounts(2, 1);
        this.assertDeserialized(mv);
        cache2.compact();
        this.assertOnlyOneRepresentationExists(mv);
        this.assertSerialized(mv);
        this.assertSerializationCounts(2, 1);
    }

    public void testKeySetValuesEntrySetCollectionReferences() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        Pojo key1 = new Pojo(1);
        Pojo value1 = new Pojo(11);
        Pojo key2 = new Pojo(2);
        Pojo value2 = new Pojo(22);
        String key3 = "3";
        String value3 = "three";
        cache1.put((Object)key1, (Object)value1);
        cache1.put((Object)key2, (Object)value2);
        cache1.put((Object)key3, (Object)value3);
        HashSet<Object> expKeys = new HashSet<Object>();
        expKeys.add(key1);
        expKeys.add(key2);
        expKeys.add(key3);
        HashSet<Object> expValues = new HashSet<Object>();
        expValues.add(value1);
        expValues.add(value2);
        expValues.add(value3);
        Set expKeyEntries = ObjectDuplicator.duplicateSet(expKeys);
        Set expValueEntries = ObjectDuplicator.duplicateSet(expValues);
        Set keys = cache2.keySet();
        for (Object key : keys) {
            assert (expKeys.remove(key));
        }
        assert (expKeys.isEmpty()) : "Did not see keys " + expKeys + " in iterator!";
        Collection values = cache2.values();
        for (Object key : values) {
            assert (expValues.remove(key));
        }
        assert (expValues.isEmpty()) : "Did not see keys " + expValues + " in iterator!";
        Set entries = cache2.entrySet();
        for (Map.Entry entry : entries) {
            assert (expKeyEntries.remove(entry.getKey()));
            assert (expValueEntries.remove(entry.getValue()));
        }
        assert (expKeyEntries.isEmpty()) : "Did not see keys " + expKeyEntries + " in iterator!";
        assert (expValueEntries.isEmpty()) : "Did not see keys " + expValueEntries + " in iterator!";
        Collection[] collections = new Collection[]{keys, values, entries};
        Object newObj = new Object();
        ArrayList<Object> newObjCol = new ArrayList<Object>();
        newObjCol.add(newObj);
        for (Collection col : collections) {
            try {
                col.add(newObj);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.addAll(newObjCol);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.clear();
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.remove(key1);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.removeAll(newObjCol);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
            try {
                col.retainAll(newObjCol);
                if ($assertionsDisabled) continue;
                throw new AssertionError((Object)"Should have thrown a UnsupportedOperationException");
            }
            catch (UnsupportedOperationException uoe) {
                // empty catch block
            }
        }
        for (Map.Entry entry : entries) {
            try {
                entry.setValue(newObj);
                assert (false) : "Should have thrown a UnsupportedOperationException";
            }
            catch (UnsupportedOperationException uoe) {
            }
        }
    }

    public void testEqualsAndHashCode() throws Exception {
        Pojo pojo = new Pojo();
        MarshalledValue mv = new MarshalledValue((Object)pojo, true, (StreamingMarshaller)TestingUtil.extractCacheMarshaller(this.cache(0)));
        this.assertDeserialized(mv);
        int oldHashCode = mv.hashCode();
        mv.serialize();
        this.assertSerialized(mv);
        assert (oldHashCode == mv.hashCode());
        MarshalledValue mv2 = new MarshalledValue((Object)pojo, true, (StreamingMarshaller)TestingUtil.extractCacheMarshaller(this.cache(0)));
        this.assertSerialized(mv);
        this.assertDeserialized(mv2);
        assert (mv2.hashCode() == oldHashCode);
        assert (mv.equals((Object)mv2));
    }

    public void testMarshallValueWithCustomReadObjectMethod() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        CustomReadObjectMethod obj = new CustomReadObjectMethod();
        cache1.put((Object)"ab-key", (Object)obj);
        assert (cache2.get((Object)"ab-key").equals(obj));
        ObjectThatContainsACustomReadObjectMethod anotherObj = new ObjectThatContainsACustomReadObjectMethod();
        anotherObj.anObjectWithCustomReadObjectMethod = obj;
        cache1.put((Object)"cd-key", (Object)anotherObj);
        assert (cache2.get((Object)"cd-key").equals(anotherObj));
    }

    public void testCacheLoaders() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        this.tearDown();
        Configuration cacheCofig = MarshalledValueTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC);
        cacheCofig.setUseLazyDeserialization(true);
        CacheLoaderManagerConfig clmc = new CacheLoaderManagerConfig();
        DummyInMemoryCacheStore.Cfg clc = new DummyInMemoryCacheStore.Cfg();
        clc.setStoreName(this.getClass().getSimpleName());
        clmc.setCacheLoaderConfigs(Collections.singletonList(clc));
        cacheCofig.setCacheLoaderManagerConfig(clmc);
        this.defineConfigurationOnAllManagers("replSync2", cacheCofig);
        this.waitForClusterToForm("replSync2");
        cache1 = this.cache(0, "replSync2");
        cache2 = this.cache(1, "replSync2");
        Pojo pojo = new Pojo();
        cache1.put((Object)"key", (Object)pojo);
        this.assertMarshalledValueInterceptorPresent(cache1);
        this.assertMarshalledValueInterceptorPresent(cache2);
        this.assertSerializationCounts(2, 0);
        cache2.get((Object)"key");
        this.assertSerializationCounts(2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallbackValues() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        MockListener l = new MockListener();
        cache1.addListener((Object)l);
        try {
            Pojo pojo = new Pojo();
            cache1.put((Object)"key", (Object)pojo);
            assert (l.newValue instanceof Pojo) : "recieved " + l.newValue.getClass().getName();
            this.assertSerializationCounts(2, 0);
        }
        finally {
            cache1.removeListener((Object)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoteCallbackValues() throws Exception {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        MockListener l = new MockListener();
        cache2.addListener((Object)l);
        try {
            Pojo pojo = new Pojo();
            pojo.b = false;
            cache1.put((Object)"key", (Object)pojo);
            assert (l.newValue instanceof Pojo);
            this.assertSerializationCounts(1, 1);
        }
        finally {
            cache2.removeListener((Object)l);
        }
    }

    public void testEvictWithMarshalledValueKey() {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        Pojo pojo = new Pojo();
        cache1.put((Object)pojo, (Object)pojo);
        cache1.evict((Object)pojo);
        assert (!cache1.containsKey((Object)pojo));
    }

    public void testModificationsOnSameCustomKey() {
        Cache cache1 = this.cache(0, "replSync");
        Cache cache2 = this.cache(1, "replSync");
        Pojo key = new Pojo();
        cache1.put((Object)key, (Object)"1");
        cache2.put((Object)key, (Object)"2");
        this.assertSerializationCounts(4, 1);
    }

    public void testReturnValueDeserialization() {
        Cache cache1 = this.cache(0, "replSync");
        this.cache(1, "replSync");
        Pojo v1 = new Pojo(1);
        cache1.put((Object)"1", (Object)v1);
        Pojo previous = (Pojo)cache1.put((Object)"1", (Object)new Pojo(2));
        assert (previous.equals(v1));
    }

    public void testEquality() {
        byte[] prevBytes = TestingUtil.generateRandomString(1310).getBytes(Charset.forName("UTF-8"));
        String value = "galder";
        MarshalledValue mv = new MarshalledValue((Object)value, true, (StreamingMarshaller)TestingUtil.extractCacheMarshaller(this.cache(0, "replSync")));
        MarshalledValue mv2 = new MarshalledValue((Object)value, false, (StreamingMarshaller)TestingUtil.extractCacheMarshaller(this.cache(0, "replSync")));
        mv2.instance = prevBytes;
        mv2.serialize();
        mv2.instance = value;
        mv2.raw = null;
        mv2.serialize();
        mv2.instance = null;
        AssertJUnit.assertEquals((Object)mv, (Object)mv2);
    }

    public static class CustomReadObjectMethod
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String lastName;
        String ssn;
        transient boolean deserialized;

        public CustomReadObjectMethod() {
            this("Zamarreno", "234-567-8901");
        }

        public CustomReadObjectMethod(String lastName, String ssn) {
            this.lastName = lastName;
            this.ssn = ssn;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CustomReadObjectMethod)) {
                return false;
            }
            CustomReadObjectMethod pk = (CustomReadObjectMethod)obj;
            if (!this.lastName.equals(pk.lastName)) {
                return false;
            }
            return this.ssn.equals(pk.ssn);
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + this.lastName.hashCode();
            result = result * 31 + this.ssn.hashCode();
            return result;
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.deserialized = true;
        }
    }

    public static class ObjectThatContainsACustomReadObjectMethod
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public CustomReadObjectMethod anObjectWithCustomReadObjectMethod;
        Integer balance;

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ObjectThatContainsACustomReadObjectMethod)) {
                return false;
            }
            ObjectThatContainsACustomReadObjectMethod acct = (ObjectThatContainsACustomReadObjectMethod)obj;
            if (!ObjectThatContainsACustomReadObjectMethod.safeEquals(this.balance, acct.balance)) {
                return false;
            }
            return ObjectThatContainsACustomReadObjectMethod.safeEquals(this.anObjectWithCustomReadObjectMethod, acct.anObjectWithCustomReadObjectMethod);
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + ObjectThatContainsACustomReadObjectMethod.safeHashCode(this.balance);
            result = result * 31 + ObjectThatContainsACustomReadObjectMethod.safeHashCode(this.anObjectWithCustomReadObjectMethod);
            return result;
        }

        private static int safeHashCode(Object obj) {
            return obj == null ? 0 : obj.hashCode();
        }

        private static boolean safeEquals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }

    public static class Pojo
    implements Externalizable {
        public int i;
        boolean b = true;
        static int serializationCount;
        static int deserializationCount;
        final Log log = LogFactory.getLog(Pojo.class);
        private static final long serialVersionUID = -2888014339659501395L;

        public Pojo(int i) {
            this.i = i;
        }

        public Pojo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            if (this.b != pojo.b) {
                return false;
            }
            return this.i == pojo.i;
        }

        public int hashCode() {
            int result = this.i;
            result = 31 * result + (this.b ? 1 : 0);
            return result;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.i);
            out.writeBoolean(this.b);
            int serCount = this.updateSerializationCount();
            this.log.trace((Object)("serializationCount=" + serCount));
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.i = in.readInt();
            this.b = in.readBoolean();
            if (this.b) assert (!Thread.currentThread().getName().startsWith("OOB")) : "Transport (JGroups) thread is trying to deserialize stuff!!";
            int deserCount = this.updateDeserializationCount();
            this.log.trace((Object)("deserializationCount=" + deserCount));
        }

        public int updateSerializationCount() {
            return ++serializationCount;
        }

        public int updateDeserializationCount() {
            return ++deserializationCount;
        }
    }

    class MarshalledValueListenerInterceptor
    extends CommandInterceptor {
        int invocationCount = 0;

        MarshalledValueListenerInterceptor() {
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            Object retval;
            ++this.invocationCount;
            if (command.getKey() instanceof MarshalledValue) {
                MarshalledValueTest.this.assertOnlyOneRepresentationExists((MarshalledValue)command.getKey());
            }
            if (command.getValue() instanceof MarshalledValue) {
                MarshalledValueTest.this.assertOnlyOneRepresentationExists((MarshalledValue)command.getValue());
            }
            if ((retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command)) instanceof MarshalledValue) {
                MarshalledValueTest.this.assertOnlyOneRepresentationExists((MarshalledValue)retval);
            }
            return retval;
        }
    }

    @Listener
    public static class MockListener {
        Object newValue;

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent e) {
            if (!e.isPre()) {
                this.newValue = e.getValue();
            }
        }
    }
}

