/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.manager.CacheContainer;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.IsolationLevel;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheNotifierTxTest")
public class CacheNotifierTxTest
extends AbstractInfinispanTest {
    private Cache<Object, Object> cache;
    private TransactionManager tm;
    private CacheNotifier mockNotifier;
    private CacheNotifier origNotifier;
    private CacheContainer cm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.transaction().autoCommit(false).clustering().cacheMode(CacheMode.LOCAL).locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cm = TestCacheManagerFactory.createCacheManager(builder);
        this.cache = this.cm.getCache();
        this.tm = TestingUtil.getTransactionManager(this.cache);
        this.mockNotifier = (CacheNotifier)Mockito.mock(CacheNotifier.class);
        this.origNotifier = TestingUtil.replaceComponent(this.cache, CacheNotifier.class, this.mockNotifier, true);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.replaceComponent(this.cache, CacheNotifier.class, this.origNotifier, true);
        TestingUtil.killCaches(this.cache);
        this.cm.stop();
    }

    @AfterClass(alwaysRun=true)
    public void destroyManager() {
        TestingUtil.killCacheManagers(this.cache.getCacheManager());
    }

    private void initCacheData(Object key, Object value) {
        this.initCacheData(Collections.singletonMap(key, value));
    }

    private void initCacheData(Map<Object, Object> data) {
        try {
            this.tm.begin();
            this.cache.putAll(data);
            this.tm.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.expectTransactionBoundaries(true);
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.atLeastOnce())).notifyCacheEntryCreated(Matchers.anyObject(), Matchers.anyBoolean(), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier, (VerificationMode)Mockito.atLeastOnce())).notifyCacheEntryModified(Matchers.anyObject(), Matchers.anyObject(), Matchers.anyBoolean(), (InvocationContext)Matchers.isA(InvocationContext.class));
        Mockito.reset((Object[])new CacheNotifier[]{this.mockNotifier});
    }

    private void expectSingleEntryCreated(Object key, Object value) {
        CacheNotifierTxTest.expectSingleEntryCreated(key, value, this.mockNotifier);
    }

    private void expectSingleEntryOnlyPreCreated(Object key) {
        CacheNotifierTxTest.expectSingleEntryOnlyPreCreated(key, this.mockNotifier);
    }

    static void expectSingleEntryCreated(Object key, Object value, CacheNotifier mockNotifier) {
        ((CacheNotifier)Mockito.verify((Object)mockNotifier)).notifyCacheEntryCreated(Matchers.eq((Object)key), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)mockNotifier)).notifyCacheEntryCreated(Matchers.eq((Object)key), Matchers.eq((boolean)false), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)key), Matchers.isNull(), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)key), Matchers.eq((Object)value), Matchers.eq((boolean)false), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    static void expectSingleEntryOnlyPreCreated(Object key, CacheNotifier mockNotifier) {
        ((CacheNotifier)Mockito.verify((Object)mockNotifier)).notifyCacheEntryCreated(Matchers.eq((Object)key), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)key), Matchers.isNull(), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    private void expectTransactionBoundaries(boolean successful) {
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyTransactionRegistered((GlobalTransaction)Matchers.isA(GlobalTransaction.class), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyTransactionCompleted((GlobalTransaction)Matchers.isA(GlobalTransaction.class), Matchers.eq((boolean)successful), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    public void testTxNonexistentRemove() throws Exception {
        this.tm.begin();
        this.cache.remove((Object)"doesNotExist");
        this.tm.commit();
        this.expectTransactionBoundaries(true);
    }

    public void testTxCreationCommit() throws Exception {
        this.tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        this.tm.commit();
        this.expectTransactionBoundaries(true);
        this.expectSingleEntryCreated("key", "value");
    }

    public void testTxCreationRollback() throws Exception {
        this.tm.begin();
        this.cache.put((Object)"key", (Object)"value");
        this.tm.rollback();
        this.expectTransactionBoundaries(false);
        this.expectSingleEntryOnlyPreCreated("key");
    }

    public void testTxOnlyModification() throws Exception {
        this.initCacheData("key", "value");
        this.tm.begin();
        this.cache.put((Object)"key", (Object)"value2");
        this.tm.commit();
        this.expectTransactionBoundaries(true);
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)"key"), Matchers.eq((Object)"value"), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryModified(Matchers.eq((Object)"key"), Matchers.eq((Object)"value2"), Matchers.eq((boolean)false), (InvocationContext)Matchers.isA(InvocationContext.class));
    }

    public void testTxRemoveData() throws Exception {
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        data.put("key", "value");
        data.put("key2", "value2");
        this.initCacheData(data);
        this.tm.begin();
        this.cache.remove((Object)"key2");
        this.tm.commit();
        this.expectTransactionBoundaries(true);
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryRemoved(Matchers.eq((Object)"key2"), Matchers.eq((Object)"value2"), Matchers.eq((boolean)true), (InvocationContext)Matchers.isA(InvocationContext.class));
        ((CacheNotifier)Mockito.verify((Object)this.mockNotifier)).notifyCacheEntryRemoved(Matchers.eq((Object)"key2"), Matchers.isNull(), Matchers.eq((boolean)false), (InvocationContext)Matchers.isA(InvocationContext.class));
    }
}

