/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachemanagerlistener;

import java.util.Collections;
import java.util.List;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerListener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifierImpl;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachemanagerlistener.CacheManagerNotifierImplTest")
public class CacheManagerNotifierImplTest
extends AbstractInfinispanTest {
    CacheManagerNotifierImpl n;
    CacheManagerListener cl;

    @BeforeMethod
    public void setUp() {
        this.n = new CacheManagerNotifierImpl();
        this.cl = new CacheManagerListener();
        this.n.start();
        this.n.addListener((Object)this.cl);
    }

    public void testNotifyViewChanged() {
        Address a = (Address)Mockito.mock(Address.class);
        List addresses = Collections.emptyList();
        this.n.notifyViewChange(addresses, addresses, a, 100);
        assert (this.cl.invocationCount == 1);
        assert (((ViewChangedEvent)this.cl.getEvent()).getLocalAddress() == a);
        assert (((ViewChangedEvent)this.cl.getEvent()).getNewMembers() == addresses);
        assert (((ViewChangedEvent)this.cl.getEvent()).getViewId() == 100);
        assert (this.cl.getEvent().getType() == Event.Type.VIEW_CHANGED);
    }

    public void testNotifyCacheStarted() {
        this.n.notifyCacheStarted("cache");
        assert (this.cl.invocationCount == 1);
        assert (((CacheStartedEvent)this.cl.getEvent()).getCacheName().equals("cache"));
        assert (this.cl.getEvent().getType() == Event.Type.CACHE_STARTED);
    }

    public void testNotifyCacheStopped() {
        this.n.notifyCacheStopped("cache");
        assert (this.cl.invocationCount == 1);
        assert (((CacheStoppedEvent)this.cl.getEvent()).getCacheName().equals("cache"));
        assert (this.cl.getEvent().getType() == Event.Type.CACHE_STOPPED);
    }
}

