/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.interceptors.InvocationContextInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.InitialStateTransferCompletionTest")
@CleanupAfterMethod
public class InitialStateTransferCompletionTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder cacheConfigBuilder;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.cacheConfigBuilder = InitialStateTransferCompletionTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.cacheConfigBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).syncCommitPhase(true).syncRollbackPhase(true).lockingMode(LockingMode.PESSIMISTIC).clustering().hash().numOwners(10).stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(true);
        this.createCluster(this.cacheConfigBuilder, 2);
        this.waitForClusterToForm();
    }

    public void testStateTransferCompletion() throws Exception {
        int numKeys = 100;
        Cache cache0 = this.cache(0);
        for (int i = 0; i < 100; ++i) {
            cache0.put((Object)("k" + i), (Object)("v" + i));
        }
        final AtomicBoolean ignoreFurtherStateTransfer = new AtomicBoolean();
        final AtomicInteger transferredKeys = new AtomicInteger();
        this.cacheConfigBuilder.customInterceptors().addInterceptor().before(InvocationContextInterceptor.class).interceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                if (cmd instanceof PutKeyValueCommand && ((PutKeyValueCommand)cmd).hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
                    if (ignoreFurtherStateTransfer.get()) {
                        return null;
                    }
                    Object result = super.handleDefault(ctx, cmd);
                    transferredKeys.incrementAndGet();
                    return result;
                }
                return super.handleDefault(ctx, cmd);
            }
        });
        this.log.trace((Object)"Adding new member ...");
        this.addClusterEnabledCacheManager(this.cacheConfigBuilder);
        Cache cache2 = this.cache(2);
        ignoreFurtherStateTransfer.set(true);
        this.log.trace((Object)"Successfully added a new member");
        int actualTransferredKeys = transferredKeys.get();
        Assert.assertEquals((long)100L, (long)actualTransferredKeys);
        CacheTopology cacheTopology = cache2.getAdvancedCache().getComponentRegistry().getStateTransferManager().getCacheTopology();
        Assert.assertNull((Object)cacheTopology.getPendingCH());
        ConsistentHash readCh = cacheTopology.getReadConsistentHash();
        Assert.assertTrue((boolean)readCh.getMembers().contains(this.address(2)));
        DataContainer dc2 = this.cache(2).getAdvancedCache().getDataContainer();
        Assert.assertEquals((long)100L, (long)dc2.size());
        for (int i = 0; i < 100; ++i) {
            String key = "k" + i;
            String expectedValue = "v" + i;
            Assert.assertTrue((boolean)readCh.isKeyLocalToNode(this.address(2), (Object)key));
            InternalCacheEntry entry = dc2.get((Object)key);
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((Object)expectedValue, (Object)entry.getValue());
        }
    }
}

