/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.MergeOrViewChangeListener;
import org.infinispan.test.TestingUtil;

public class JoiningNode {
    private final EmbeddedCacheManager cm;
    private final CountDownLatch latch;
    private final MergeOrViewChangeListener listener;

    public JoiningNode(EmbeddedCacheManager cm) {
        this.cm = cm;
        this.latch = new CountDownLatch(1);
        this.listener = new MergeOrViewChangeListener(this.latch);
        cm.addListener((Object)this.listener);
    }

    public Cache getCache() {
        return this.cm.getCache();
    }

    public Cache getCache(String cacheName) {
        return this.cm.getCache(cacheName);
    }

    public void waitForJoin(long timeout, Cache ... caches) throws InterruptedException {
        this.latch.await(timeout, TimeUnit.MILLISECONDS);
        TestingUtil.waitForRehashToComplete(caches);
    }

    private boolean isStateTransferred() {
        return !this.listener.merged;
    }

    void verifyStateTransfer(Callable<Void> verify) throws Exception {
        if (this.isStateTransferred()) {
            verify.call();
        }
    }
}

