/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.DefaultConsistentHashFactory;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.StateConsumerImpl;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.statetransfer.TestKey;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateConsumerTest")
public class StateConsumerTest {
    private static final Log log = LogFactory.getLog(StateConsumerTest.class);

    public void test1() throws Exception {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().invocationBatching().enable().clustering().cacheMode(CacheMode.DIST_SYNC).clustering().stateTransfer().timeout(10000L).versioning().enable().scheme(VersioningScheme.SIMPLE).locking().lockAcquisitionTimeout(200L).writeSkewCheck(true).isolationLevel(IsolationLevel.REPEATABLE_READ);
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        GlobalConfiguration globalConfiguration = gcb.build();
        Configuration configuration = cb.build();
        Address[] addresses = new Address[10];
        for (int i = 0; i < 10; ++i) {
            addresses[i] = new TestAddress(i);
        }
        List<Address> members1 = Arrays.asList(addresses[0], addresses[1], addresses[2], addresses[3], addresses[4]);
        List<Address> members2 = Arrays.asList(addresses[0], addresses[1], addresses[2], addresses[3]);
        DefaultConsistentHashFactory chf = new DefaultConsistentHashFactory();
        DefaultConsistentHash ch1 = chf.create((Hash)new MurmurHash3(), 2, 4, members1);
        DefaultConsistentHash ch2 = chf.updateMembers(ch1, members2);
        DefaultConsistentHash ch3 = chf.rebalance(ch2);
        log.debug((Object)ch1);
        log.debug((Object)ch2);
        Cache cache = (Cache)Mockito.mock(Cache.class);
        Mockito.when((Object)cache.getName()).thenReturn((Object)"testCache");
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String name = "PooledExecutorThread-" + this.getClass().getSimpleName() + "-" + r.hashCode();
                return new Thread(r, name);
            }
        };
        ThreadPoolExecutor pooledExecutorService = new ThreadPoolExecutor(10, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        StateTransferManager stateTransferManager = (StateTransferManager)Mockito.mock(StateTransferManager.class);
        CacheNotifier cacheNotifier = (CacheNotifier)Mockito.mock(CacheNotifier.class);
        RpcManager rpcManager = (RpcManager)Mockito.mock(RpcManager.class);
        Transport transport = (Transport)Mockito.mock(Transport.class);
        CommandsFactory commandsFactory = (CommandsFactory)Mockito.mock(CommandsFactory.class);
        CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)Mockito.mock(CacheLoaderManager.class);
        DataContainer dataContainer = (DataContainer)Mockito.mock(DataContainer.class);
        TransactionTable transactionTable = (TransactionTable)Mockito.mock(TransactionTable.class);
        StateTransferLock stateTransferLock = (StateTransferLock)Mockito.mock(StateTransferLock.class);
        InterceptorChain interceptorChain = (InterceptorChain)Mockito.mock(InterceptorChain.class);
        InvocationContextContainer icc = (InvocationContextContainer)Mockito.mock(InvocationContextContainer.class);
        Mockito.when((Object)commandsFactory.buildStateRequestCommand((StateRequestCommand.Type)Matchers.any(StateRequestCommand.Type.class), (Address)Matchers.any(Address.class), Matchers.anyInt(), (Set)Matchers.any(Set.class))).thenAnswer((Answer)new Answer<StateRequestCommand>(){

            public StateRequestCommand answer(InvocationOnMock invocation) {
                return new StateRequestCommand("cache1", (StateRequestCommand.Type)invocation.getArguments()[0], (Address)invocation.getArguments()[1], ((Integer)invocation.getArguments()[2]).intValue(), (Set)invocation.getArguments()[3]);
            }
        });
        Mockito.when((Object)transport.getViewId()).thenReturn((Object)1);
        Mockito.when((Object)rpcManager.getAddress()).thenReturn((Object)new TestAddress(0));
        Mockito.when((Object)rpcManager.getTransport()).thenReturn((Object)transport);
        Mockito.when((Object)rpcManager.invokeRemotely((Collection)Matchers.any(Collection.class), (ReplicableCommand)Matchers.any(ReplicableCommand.class), (ResponseMode)Matchers.any(ResponseMode.class), Matchers.anyLong())).thenAnswer((Answer)new Answer<Map<Address, Response>>(){

            public Map<Address, Response> answer(InvocationOnMock invocation) {
                Collection recipients = (Collection)invocation.getArguments()[0];
                ReplicableCommand rpcCommand = (ReplicableCommand)invocation.getArguments()[1];
                if (rpcCommand instanceof StateRequestCommand) {
                    StateRequestCommand cmd = (StateRequestCommand)rpcCommand;
                    HashMap<Address, Response> results = new HashMap<Address, Response>();
                    if (cmd.getType().equals((Object)StateRequestCommand.Type.GET_TRANSACTIONS)) {
                        for (Address recipient : recipients) {
                            results.put(recipient, (Response)SuccessfulResponse.create(new ArrayList()));
                        }
                    } else if (cmd.getType().equals((Object)StateRequestCommand.Type.START_STATE_TRANSFER) || cmd.getType().equals((Object)StateRequestCommand.Type.CANCEL_STATE_TRANSFER)) {
                        for (Address recipient : recipients) {
                            results.put(recipient, (Response)SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE);
                        }
                    }
                    return results;
                }
                return Collections.emptyMap();
            }
        });
        StateConsumerImpl stateConsumer = new StateConsumerImpl();
        stateConsumer.init(cache, (ExecutorService)pooledExecutorService, stateTransferManager, interceptorChain, icc, configuration, rpcManager, null, commandsFactory, cacheLoaderManager, dataContainer, transactionTable, stateTransferLock, cacheNotifier);
        stateConsumer.start();
        final ArrayList<ImmortalCacheEntry> cacheEntries = new ArrayList<ImmortalCacheEntry>();
        TestKey key1 = new TestKey("key1", 0, (ConsistentHash)ch1);
        TestKey key2 = new TestKey("key2", 0, (ConsistentHash)ch1);
        cacheEntries.add(new ImmortalCacheEntry((Object)key1, (Object)"value1"));
        cacheEntries.add(new ImmortalCacheEntry((Object)key2, (Object)"value2"));
        Mockito.when((Object)dataContainer.iterator()).thenAnswer((Answer)new Answer<Iterator<InternalCacheEntry>>(){

            public Iterator<InternalCacheEntry> answer(InvocationOnMock invocation) {
                return cacheEntries.iterator();
            }
        });
        Mockito.when((Object)transactionTable.getLocalTransactions()).thenReturn(Collections.emptyList());
        Mockito.when((Object)transactionTable.getRemoteTransactions()).thenReturn(Collections.emptyList());
        HashSet<Integer> segments = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4));
        HashSet<Integer> seg = new HashSet<Integer>(Arrays.asList(0));
        Assert.assertFalse((boolean)stateConsumer.hasActiveTransfers());
        stateConsumer.onTopologyUpdate(new CacheTopology(1, (ConsistentHash)ch2, null), false);
        Assert.assertTrue((boolean)stateConsumer.hasActiveTransfers());
        stateConsumer.onTopologyUpdate(new CacheTopology(2, (ConsistentHash)ch2, (ConsistentHash)ch3), true);
        Assert.assertTrue((boolean)stateConsumer.hasActiveTransfers());
        stateConsumer.stop();
        Assert.assertFalse((boolean)stateConsumer.hasActiveTransfers());
    }
}

