/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.statetransfer.BigObject;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferLargeObjectTest")
public class StateTransferLargeObjectTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(StateTransferLargeObjectTest.class);
    private Cache<Integer, BigObject> c0;
    private Cache<Integer, BigObject> c1;
    private Cache<Integer, BigObject> c2;
    private Cache<Integer, BigObject> c3;
    private Map<Integer, BigObject> cache;
    private final Random rnd = new Random();

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).l1().disable().clustering().stateTransfer().fetchInMemoryState(true).locking().useLockStriping(false).clustering().hash().numOwners(3).numSegments(60);
        this.createCluster(builder, 4);
        this.c0 = this.cache(0);
        this.c1 = this.cache(1);
        this.c2 = this.cache(2);
        this.c3 = this.cache(3);
        this.waitForClusterToForm();
        log.info((Object)"Rehash is complete!");
        this.cache = new HashMap<Integer, BigObject>();
    }

    public void testForFailure() {
        int i;
        int num = 1000;
        for (i = 0; i < 1000; ++i) {
            BigObject bigObject = this.createBigObject(i, "prefix");
            this.cache.put(i, bigObject);
            this.c0.put((Object)i, (Object)bigObject);
        }
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)(this.c0.get((Object)i) instanceof BigObject));
            Assert.assertTrue((boolean)(this.c1.get((Object)i) instanceof BigObject));
            Assert.assertTrue((boolean)(this.c2.get((Object)i) instanceof BigObject));
            Assert.assertTrue((boolean)(this.c3.get((Object)i) instanceof BigObject));
        }
        log.info((Object)"Before stopping a cache!");
        this.fork(new Runnable(){

            @Override
            public void run() {
                log.info((Object)("About to stop " + StateTransferLargeObjectTest.this.c3.getAdvancedCache().getRpcManager().getAddress()));
                StateTransferLargeObjectTest.this.c3.stop();
                StateTransferLargeObjectTest.this.c3.getCacheManager().stop();
                log.info((Object)"Cache stopped async!");
            }
        }, false);
        int failureCount = 0;
        for (int i2 = 0; i2 < 1000; ++i2) {
            Object o;
            log.info((Object)("----Running a get on " + i2));
            try {
                o = this.c0.get((Object)i2);
                this.assertValue(i2, o);
            }
            catch (TimeoutException e) {
                log.error((Object)"Exception received", (Throwable)e);
                ++failureCount;
            }
            try {
                o = this.c1.get((Object)i2);
                this.assertValue(i2, o);
            }
            catch (TimeoutException e) {
                ++failureCount;
            }
            try {
                o = this.c2.get((Object)i2);
                this.assertValue(i2, o);
            }
            catch (TimeoutException e) {
                ++failureCount;
            }
            if (i2 % 100 != 0) continue;
            log.debug((Object)("i = " + i2));
        }
        log.info((Object)("failureCount = " + failureCount));
        log.info((Object)"Before stopping cache managers!");
        TestingUtil.killCacheManagers(this.manager(2));
        log.info((Object)"2 killed");
        TestingUtil.killCacheManagers(this.manager(1));
        log.info((Object)"1 killed");
        TestingUtil.killCacheManagers(this.manager(0));
        log.info((Object)"0 killed");
    }

    private void assertValue(int i, Object o) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof BigObject));
        Assert.assertEquals((Object)o, (Object)this.cache.get(i));
    }

    private BigObject createBigObject(int num, String prefix) {
        BigObject obj = new BigObject();
        obj.setName("[" + num + "|" + prefix + "|" + num * 3 + "|" + num * 7 + "]");
        obj.setValue(this.generateLargeString());
        obj.setValue2(this.generateLargeString());
        obj.setValue3(this.generateLargeString());
        obj.setValue4(this.generateLargeString());
        obj.setValue5(this.generateLargeString());
        obj.setValue6(this.generateLargeString());
        obj.setValue7(this.generateLargeString());
        obj.setValue8(this.generateLargeString());
        obj.setValue9(this.generateLargeString());
        obj.setValue10(this.generateLargeString());
        obj.setValue11(this.generateLargeString());
        obj.setValue12(this.generateLargeString());
        obj.setValue13(this.generateLargeString());
        obj.setValue14(this.generateLargeString());
        obj.setValue15(this.generateLargeString());
        obj.setValue16(this.generateLargeString());
        obj.setValue17(this.generateLargeString());
        obj.setValue18(this.generateLargeString());
        obj.setValue19(this.generateLargeString());
        obj.setValue20(this.generateLargeString());
        return obj;
    }

    private String generateLargeString() {
        byte[] bytes = new byte[100];
        this.rnd.nextBytes(bytes);
        return new String(bytes);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() {
    }
}

