/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.locks.LockManager;

public class AbstractCacheTest
extends AbstractInfinispanTest {
    protected CleanupPhase cleanup = CleanupPhase.AFTER_TEST;

    protected boolean cleanupAfterTest() {
        return this.getClass().getAnnotation(CleanupAfterTest.class) != null || this.getClass().getAnnotation(CleanupAfterMethod.class) == null && this.cleanup == CleanupPhase.AFTER_TEST;
    }

    protected boolean cleanupAfterMethod() {
        return this.getClass().getAnnotation(CleanupAfterMethod.class) != null || this.getClass().getAnnotation(CleanupAfterTest.class) == null && this.cleanup == CleanupPhase.AFTER_METHOD;
    }

    @Deprecated
    public void clearContent(EmbeddedCacheManager embeddedCacheManager) {
        TestingUtil.clearContent(embeddedCacheManager);
    }

    @Deprecated
    protected Set<Cache> getRunningCaches(EmbeddedCacheManager embeddedCacheManager) {
        return TestingUtil.getRunningCaches(embeddedCacheManager);
    }

    public static Configuration getDefaultClusteredConfig(Configuration.CacheMode mode) {
        return AbstractCacheTest.getDefaultClusteredConfig(mode, false);
    }

    public static Configuration getDefaultClusteredConfig(Configuration.CacheMode mode, boolean transactional) {
        if (mode.isSynchronous()) {
            return TestCacheManagerFactory.getDefaultConfiguration(transactional).fluent().mode(mode).clustering().sync().stateRetrieval().fetchInMemoryState(Boolean.valueOf(false)).transaction().syncCommitPhase(Boolean.valueOf(true)).syncRollbackPhase(Boolean.valueOf(true)).cacheStopTimeout(Integer.valueOf(0)).build();
        }
        return TestCacheManagerFactory.getDefaultConfiguration(transactional).fluent().mode(mode).clustering().async().stateRetrieval().fetchInMemoryState(Boolean.valueOf(false)).transaction().syncCommitPhase(Boolean.valueOf(true)).syncRollbackPhase(Boolean.valueOf(true)).cacheStopTimeout(Integer.valueOf(0)).build();
    }

    public static ConfigurationBuilder getDefaultClusteredCacheConfig(CacheMode mode, boolean transactional) {
        return AbstractCacheTest.getDefaultClusteredCacheConfig(mode, transactional, false);
    }

    public static ConfigurationBuilder getDefaultClusteredCacheConfig(CacheMode mode, boolean transactional, boolean useCustomTxLookup) {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(transactional, useCustomTxLookup);
        builder.clustering().cacheMode(mode).stateTransfer().fetchInMemoryState(false).transaction().syncCommitPhase(true).syncRollbackPhase(true).cacheStopTimeout(0L);
        if (mode.isSynchronous()) {
            builder.clustering().sync();
        } else {
            builder.clustering().async();
        }
        return builder;
    }

    protected boolean xor(boolean b1, boolean b2) {
        return !(!b1 && !b2 || b1 && b2);
    }

    protected void assertNotLocked(final Cache cache, final Object key) {
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return !AbstractCacheTest.this.checkLocked(cache, key);
            }
        });
    }

    protected void assertLocked(Cache cache, Object key) {
        assert (this.checkLocked(cache, key)) : "expected key '" + key + "' to be locked on cache " + cache + ", but it is not";
    }

    protected boolean checkLocked(Cache cache, Object key) {
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        return lockManager.isLocked(key);
    }

    public EmbeddedCacheManager manager(Cache c) {
        return c.getCacheManager();
    }

    public static enum CleanupPhase {
        AFTER_METHOD,
        AFTER_TEST;

    }
}

