/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.Marshaller;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.fwk.JBossTransactionsUtils;
import org.infinispan.test.fwk.JGroupsConfigBuilder;
import org.infinispan.test.fwk.TransactionSetup;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.LegacyKeySupportSystemProperties;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;

public class TestCacheManagerFactory {
    private static final int MAX_ASYNC_EXEC_THREADS = 6;
    public static final String MARSHALLER = LegacyKeySupportSystemProperties.getProperty((String)"infinispan.test.marshaller.class", (String)"infinispan.marshaller.class");
    private static final Log log = LogFactory.getLog(TestCacheManagerFactory.class);
    private static volatile boolean shuttingDown;
    private static CountDownLatch shutDownLatch;
    private static ThreadLocal<PerThreadCacheManagers> perThreadCacheManagers;

    private static DefaultCacheManager newDefaultCacheManager(boolean start, GlobalConfiguration gc, org.infinispan.config.Configuration c, boolean keepJmxDomain) {
        if (!keepJmxDomain) {
            gc.setJmxDomain("infinispan" + UUID.randomUUID());
        }
        return TestCacheManagerFactory.newDefaultCacheManager(start, gc, c);
    }

    private static DefaultCacheManager newDefaultCacheManager(boolean start, GlobalConfigurationBuilder gc, ConfigurationBuilder c, boolean keepJmxDomain) {
        if (!keepJmxDomain) {
            gc.globalJmxStatistics().jmxDomain("infinispan-" + UUID.randomUUID());
        }
        return TestCacheManagerFactory.newDefaultCacheManager(start, gc, c);
    }

    private static DefaultCacheManager newDefaultCacheManager(boolean start, ConfigurationBuilderHolder holder, boolean keepJmxDomain) {
        if (!keepJmxDomain) {
            holder.getGlobalConfigurationBuilder().globalJmxStatistics().jmxDomain("infinispan-" + UUID.randomUUID());
        }
        return TestCacheManagerFactory.newDefaultCacheManager(start, holder);
    }

    public static EmbeddedCacheManager fromXml(String xmlFile) throws IOException {
        return TestCacheManagerFactory.fromXml(xmlFile, false);
    }

    public static EmbeddedCacheManager fromXml(String xmlFile, boolean keepJmxDomainName) throws IOException {
        InputStream is = FileLookupFactory.newInstance().lookupFileStrict(xmlFile, Thread.currentThread().getContextClassLoader());
        return TestCacheManagerFactory.fromStream(is, keepJmxDomainName);
    }

    public static EmbeddedCacheManager fromXml(String globalXmlFile, String defaultXmlFile, String namedXmlFile) throws IOException {
        return new DefaultCacheManager(globalXmlFile, defaultXmlFile, namedXmlFile, true);
    }

    public static EmbeddedCacheManager fromStream(InputStream is) throws IOException {
        return TestCacheManagerFactory.fromStream(is, false);
    }

    public static EmbeddedCacheManager fromStream(InputStream is, boolean keepJmxDomainName) throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holder = parserRegistry.parse(is);
        return TestCacheManagerFactory.createClusteredCacheManager(holder, keepJmxDomainName);
    }

    public static EmbeddedCacheManager createLocalCacheManager(boolean transactional) {
        return TestCacheManagerFactory.createLocalCacheManager(transactional, -1L);
    }

    public static EmbeddedCacheManager createLocalCacheManager(boolean transactional, long lockAcquisitionTimeout) {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        globalConfiguration.setAllowDuplicateDomains(true);
        TestCacheManagerFactory.amendMarshaller(globalConfiguration);
        TestCacheManagerFactory.minimizeThreads(globalConfiguration);
        org.infinispan.config.Configuration c = new org.infinispan.config.Configuration();
        TestCacheManagerFactory.markAsTransactional(transactional, c);
        if (lockAcquisitionTimeout > -1L) {
            c.setLockAcquisitionTimeout(lockAcquisitionTimeout);
        }
        TestCacheManagerFactory.updateTransactionSupport(c);
        return TestCacheManagerFactory.newDefaultCacheManager(true, globalConfiguration, c, false);
    }

    @Deprecated
    private static void markAsTransactional(boolean transactional, org.infinispan.config.Configuration c) {
        c.fluent().transaction().transactionMode(transactional ? TransactionMode.TRANSACTIONAL : TransactionMode.NON_TRANSACTIONAL);
        if (transactional) {
            JBossTransactionsUtils.setVolatileStores();
        }
    }

    private static void markAsTransactional(boolean transactional, ConfigurationBuilder builder) {
        builder.transaction().transactionMode(transactional ? TransactionMode.TRANSACTIONAL : TransactionMode.NON_TRANSACTIONAL);
        if (transactional) {
            JBossTransactionsUtils.setVolatileStores();
        }
    }

    @Deprecated
    private static void updateTransactionSupport(org.infinispan.config.Configuration c) {
        if (c.isTransactionalCache()) {
            TestCacheManagerFactory.amendJTA(c);
        }
    }

    private static void updateTransactionSupport(boolean transactional, ConfigurationBuilder builder) {
        if (transactional) {
            TestCacheManagerFactory.amendJTA(builder);
        }
    }

    @Deprecated
    private static void amendJTA(org.infinispan.config.Configuration c) {
        if (c.isTransactionalCache() && c.getTransactionManagerLookupClass() == null && c.getTransactionManagerLookup() == null) {
            c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        }
    }

    private static void amendJTA(ConfigurationBuilder builder) {
        Configuration c = builder.build();
        if (c.transaction().transactionMode().equals((Object)TransactionMode.TRANSACTIONAL) && c.transaction().transactionManagerLookup() == null) {
            builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)TransactionSetup.getManagerLookup(), (ClassLoader)TestCacheManagerFactory.class.getClassLoader()));
        }
    }

    public static EmbeddedCacheManager createClusteredCacheManager() {
        return TestCacheManagerFactory.createClusteredCacheManager(new TransportFlags());
    }

    public static EmbeddedCacheManager createClusteredCacheManager(TransportFlags flags) {
        return TestCacheManagerFactory.createClusteredCacheManager(new org.infinispan.config.Configuration(), flags);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(org.infinispan.config.Configuration defaultCacheConfig) {
        return TestCacheManagerFactory.createClusteredCacheManager(defaultCacheConfig, new TransportFlags());
    }

    public static EmbeddedCacheManager createClusteredCacheManager(org.infinispan.config.Configuration defaultCacheConfig, TransportFlags flags) {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getClusteredDefault();
        TestCacheManagerFactory.amendMarshaller(globalConfiguration);
        TestCacheManagerFactory.minimizeThreads(globalConfiguration);
        TestCacheManagerFactory.amendTransport(globalConfiguration, flags);
        TestCacheManagerFactory.amendJTA(defaultCacheConfig);
        return TestCacheManagerFactory.newDefaultCacheManager(true, globalConfiguration, defaultCacheConfig, false);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(ConfigurationBuilder defaultCacheConfig, TransportFlags flags) {
        return TestCacheManagerFactory.createClusteredCacheManager(GlobalConfigurationBuilder.defaultClusteredBuilder(), defaultCacheConfig, flags);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(GlobalConfigurationBuilder gcb, ConfigurationBuilder defaultCacheConfig) {
        return TestCacheManagerFactory.createClusteredCacheManager(gcb, defaultCacheConfig, new TransportFlags());
    }

    public static EmbeddedCacheManager createClusteredCacheManager(ConfigurationBuilder defaultCacheConfig) {
        return TestCacheManagerFactory.createClusteredCacheManager(GlobalConfigurationBuilder.defaultClusteredBuilder(), defaultCacheConfig);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(ConfigurationBuilderHolder holder) {
        return TestCacheManagerFactory.createClusteredCacheManager(holder, false);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(ConfigurationBuilderHolder holder, boolean keepJmxDomainName) {
        TransportFlags flags = new TransportFlags();
        TestCacheManagerFactory.amendGlobalConfiguration(holder.getGlobalConfigurationBuilder(), flags);
        TestCacheManagerFactory.amendJTA(holder.getDefaultConfigurationBuilder());
        for (ConfigurationBuilder builder : holder.getNamedConfigurationBuilders().values()) {
            TestCacheManagerFactory.amendJTA(builder);
        }
        return TestCacheManagerFactory.newDefaultCacheManager(true, holder, keepJmxDomainName);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(GlobalConfigurationBuilder gcb, ConfigurationBuilder defaultCacheConfig, TransportFlags flags) {
        return TestCacheManagerFactory.createClusteredCacheManager(gcb, defaultCacheConfig, flags, false);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(GlobalConfigurationBuilder gcb, ConfigurationBuilder defaultCacheConfig, TransportFlags flags, boolean keepJmxDomainName) {
        TestCacheManagerFactory.amendGlobalConfiguration(gcb, flags);
        TestCacheManagerFactory.amendJTA(defaultCacheConfig);
        return TestCacheManagerFactory.newDefaultCacheManager(true, gcb, defaultCacheConfig, keepJmxDomainName);
    }

    public static void amendGlobalConfiguration(GlobalConfigurationBuilder gcb, TransportFlags flags) {
        TestCacheManagerFactory.amendMarshaller(gcb);
        TestCacheManagerFactory.minimizeThreads(gcb);
        TestCacheManagerFactory.amendTransport(gcb, flags);
    }

    public static EmbeddedCacheManager createCacheManager(ConfigurationBuilder builder) {
        return TestCacheManagerFactory.createCacheManager(new GlobalConfigurationBuilder().nonClusteredDefault(), builder);
    }

    public static EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder());
    }

    public static EmbeddedCacheManager createCacheManager(boolean start) {
        return TestCacheManagerFactory.newDefaultCacheManager(start, new GlobalConfigurationBuilder().nonClusteredDefault(), new ConfigurationBuilder(), false);
    }

    public static EmbeddedCacheManager createCacheManager(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder builder) {
        return TestCacheManagerFactory.newDefaultCacheManager(true, globalBuilder, builder, false);
    }

    public static EmbeddedCacheManager createCacheManager(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder builder, boolean keepJmxDomain) {
        return TestCacheManagerFactory.newDefaultCacheManager(true, globalBuilder, builder, keepJmxDomain);
    }

    public static EmbeddedCacheManager createCacheManager(GlobalConfiguration configuration) {
        return TestCacheManagerFactory.internalCreateJmxDomain(true, configuration, false);
    }

    public static EmbeddedCacheManager createCacheManager(boolean start, GlobalConfiguration configuration) {
        return TestCacheManagerFactory.internalCreateJmxDomain(start, configuration, false);
    }

    public static EmbeddedCacheManager createCacheManagerEnforceJmxDomain(GlobalConfiguration configuration) {
        return TestCacheManagerFactory.internalCreateJmxDomain(true, configuration, true);
    }

    private static EmbeddedCacheManager internalCreateJmxDomain(boolean start, GlobalConfiguration configuration, boolean enforceJmxDomain) {
        TestCacheManagerFactory.amendMarshaller(configuration);
        TestCacheManagerFactory.minimizeThreads(configuration);
        TestCacheManagerFactory.amendTransport(configuration);
        return TestCacheManagerFactory.newDefaultCacheManager(start, configuration, new org.infinispan.config.Configuration(), enforceJmxDomain);
    }

    public static EmbeddedCacheManager createCacheManager(CacheMode mode, boolean indexing) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(mode).indexing().enabled(indexing).addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        if (mode.isClustered()) {
            return TestCacheManagerFactory.createClusteredCacheManager(builder);
        }
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public static EmbeddedCacheManager createCacheManager(org.infinispan.config.Configuration defaultCacheConfig) {
        GlobalConfiguration globalConfiguration;
        if (defaultCacheConfig.getCacheMode().isClustered()) {
            globalConfiguration = GlobalConfiguration.getClusteredDefault();
            TestCacheManagerFactory.amendTransport(globalConfiguration);
        } else {
            globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        }
        globalConfiguration.setAllowDuplicateDomains(true);
        TestCacheManagerFactory.amendMarshaller(globalConfiguration);
        TestCacheManagerFactory.minimizeThreads(globalConfiguration);
        TestCacheManagerFactory.updateTransactionSupport(defaultCacheConfig);
        defaultCacheConfig.fluent().cacheStopTimeout(Integer.valueOf(1000));
        return TestCacheManagerFactory.newDefaultCacheManager(true, globalConfiguration, defaultCacheConfig, false);
    }

    public static EmbeddedCacheManager createCacheManager(GlobalConfiguration configuration, org.infinispan.config.Configuration defaultCfg) {
        TestCacheManagerFactory.minimizeThreads(configuration);
        TestCacheManagerFactory.amendMarshaller(configuration);
        TestCacheManagerFactory.amendTransport(configuration);
        TestCacheManagerFactory.updateTransactionSupport(defaultCfg);
        return TestCacheManagerFactory.newDefaultCacheManager(true, configuration, defaultCfg, false);
    }

    public static EmbeddedCacheManager createCacheManager(GlobalConfiguration configuration, org.infinispan.config.Configuration defaultCfg, boolean keepJmxDomainName) {
        return TestCacheManagerFactory.createCacheManager(configuration, defaultCfg, keepJmxDomainName, false);
    }

    public static EmbeddedCacheManager createCacheManager(GlobalConfiguration configuration, org.infinispan.config.Configuration defaultCfg, boolean keepJmxDomainName, boolean dontFixTransport) {
        TestCacheManagerFactory.minimizeThreads(configuration);
        TestCacheManagerFactory.amendMarshaller(configuration);
        if (!dontFixTransport) {
            TestCacheManagerFactory.amendTransport(configuration);
        }
        TestCacheManagerFactory.updateTransactionSupport(defaultCfg);
        return TestCacheManagerFactory.newDefaultCacheManager(true, configuration, defaultCfg, keepJmxDomainName);
    }

    public static EmbeddedCacheManager createCacheManagerEnforceJmxDomain(String jmxDomain) {
        return TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(jmxDomain, true, true);
    }

    public static EmbeddedCacheManager createClusteredCacheManagerEnforceJmxDomain(String jmxDomain, ConfigurationBuilder builder) {
        return TestCacheManagerFactory.createClusteredCacheManagerEnforceJmxDomain(jmxDomain, true, builder);
    }

    public static EmbeddedCacheManager createClusteredCacheManagerEnforceJmxDomain(String jmxDomain, boolean exposeGlobalJmx, ConfigurationBuilder builder) {
        return TestCacheManagerFactory.createClusteredCacheManagerEnforceJmxDomain(jmxDomain, exposeGlobalJmx, builder, new PerThreadMBeanServerLookup());
    }

    public static EmbeddedCacheManager createClusteredCacheManagerEnforceJmxDomain(String jmxDomain, boolean exposeGlobalJmx, ConfigurationBuilder builder, MBeanServerLookup mBeanServerLookup) {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.amendGlobalConfiguration(globalBuilder, new TransportFlags());
        globalBuilder.globalJmxStatistics().jmxDomain(jmxDomain).mBeanServerLookup(mBeanServerLookup).enabled(exposeGlobalJmx);
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder, true);
    }

    public static EmbeddedCacheManager createCacheManagerEnforceJmxDomain(String jmxDomain, boolean exposeGlobalJmx, boolean exposeCacheJmx) {
        return TestCacheManagerFactory.createCacheManagerEnforceJmxDomain(jmxDomain, null, exposeGlobalJmx, exposeCacheJmx);
    }

    public static EmbeddedCacheManager createCacheManagerEnforceJmxDomain(String jmxDomain, String cacheManagerName, boolean exposeGlobalJmx, boolean exposeCacheJmx) {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.getNonClusteredDefault();
        globalConfiguration.setJmxDomain(jmxDomain);
        if (cacheManagerName != null) {
            globalConfiguration.setCacheManagerName(cacheManagerName);
        }
        globalConfiguration.setMBeanServerLookup(PerThreadMBeanServerLookup.class.getName());
        globalConfiguration.setExposeGlobalJmxStatistics(exposeGlobalJmx);
        org.infinispan.config.Configuration configuration = new org.infinispan.config.Configuration();
        configuration.setExposeJmxStatistics(exposeCacheJmx);
        return TestCacheManagerFactory.createCacheManager(globalConfiguration, configuration, true);
    }

    public static org.infinispan.config.Configuration getDefaultConfiguration(boolean transactional) {
        org.infinispan.config.Configuration c = new org.infinispan.config.Configuration();
        TestCacheManagerFactory.markAsTransactional(transactional, c);
        TestCacheManagerFactory.updateTransactionSupport(c);
        return c;
    }

    public static ConfigurationBuilder getDefaultCacheConfiguration(boolean transactional) {
        return TestCacheManagerFactory.getDefaultCacheConfiguration(transactional, false);
    }

    public static ConfigurationBuilder getDefaultCacheConfiguration(boolean transactional, boolean useCustomTxLookup) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        TestCacheManagerFactory.markAsTransactional(transactional, builder);
        if (useCustomTxLookup) {
            TestCacheManagerFactory.updateTransactionSupport(transactional, builder);
        }
        return builder;
    }

    public static org.infinispan.config.Configuration getDefaultConfiguration(boolean transactional, Configuration.CacheMode cacheMode) {
        org.infinispan.config.Configuration c = new org.infinispan.config.Configuration();
        TestCacheManagerFactory.markAsTransactional(transactional, c);
        TestCacheManagerFactory.updateTransactionSupport(c);
        c.setCacheMode(cacheMode);
        if (cacheMode.isClustered()) {
            c.setSyncRollbackPhase(true);
            c.setSyncCommitPhase(true);
        }
        return c;
    }

    public static void amendTransport(GlobalConfiguration cfg) {
        TestCacheManagerFactory.amendTransport(cfg, new TransportFlags());
    }

    private static void amendTransport(GlobalConfiguration configuration, TransportFlags flags) {
        if (configuration.getTransportClass() != null) {
            Properties newTransportProps = new Properties();
            Properties previousSettings = configuration.getTransportProperties();
            if (previousSettings != null) {
                newTransportProps.putAll((Map<?, ?>)previousSettings);
            }
            String fullTestName = TestCacheManagerFactory.perThreadCacheManagers.get().fullTestName;
            String nextCacheName = perThreadCacheManagers.get().getNextCacheName();
            TestCacheManagerFactory.checkTestName(fullTestName);
            newTransportProps.put("configurationString", JGroupsConfigBuilder.getJGroupsConfig(fullTestName, flags));
            configuration.setTransportProperties(newTransportProps);
            configuration.setTransportNodeName(nextCacheName);
        }
    }

    private static void amendTransport(GlobalConfigurationBuilder builder, TransportFlags flags) {
        org.infinispan.configuration.global.GlobalConfiguration gc = builder.build();
        if (gc.transport().transport() != null) {
            String fullTestName = TestCacheManagerFactory.perThreadCacheManagers.get().fullTestName;
            String nextCacheName = perThreadCacheManagers.get().getNextCacheName();
            TestCacheManagerFactory.checkTestName(fullTestName);
            builder.transport().removeProperty("configurationFile");
            builder.transport().addProperty("configurationString", JGroupsConfigBuilder.getJGroupsConfig(fullTestName, flags)).nodeName(nextCacheName);
        }
    }

    private static void checkTestName(String fullTestName) {
        String pattern;
        String threadName;
        if (fullTestName == null && (threadName = Thread.currentThread().getName()).startsWith(pattern = "TestNGInvoker-")) {
            throw new RuntimeException("Test name is not set! Please call TestCacheManagerFactory.backgroundTestStarted(this) in your test method!");
        }
    }

    public static void minimizeThreads(GlobalConfiguration gc) {
        Properties p = new Properties();
        p.setProperty("maxThreads", String.valueOf(6));
        gc.setAsyncTransportExecutorProperties(p);
    }

    public static void minimizeThreads(GlobalConfigurationBuilder builder) {
        builder.asyncTransportExecutor().addProperty("maxThreads", String.valueOf(6));
    }

    public static void amendMarshaller(GlobalConfiguration configuration) {
        if (MARSHALLER != null) {
            try {
                Util.loadClassStrict((String)MARSHALLER, (ClassLoader)Thread.currentThread().getContextClassLoader());
                configuration.setMarshallerClass(MARSHALLER);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void amendMarshaller(GlobalConfigurationBuilder builder) {
        if (MARSHALLER != null) {
            try {
                Marshaller marshaller = (Marshaller)Util.getInstanceStrict((String)MARSHALLER, (ClassLoader)Thread.currentThread().getContextClassLoader());
                builder.serialization().marshaller(marshaller);
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static DefaultCacheManager newDefaultCacheManager(boolean start, GlobalConfiguration gc, org.infinispan.config.Configuration c) {
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager(gc, c, start);
        return TestCacheManagerFactory.addThreadCacheManager(defaultCacheManager);
    }

    private static DefaultCacheManager newDefaultCacheManager(boolean start, GlobalConfigurationBuilder gc, ConfigurationBuilder c) {
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager(gc.build(), c.build(), start);
        return TestCacheManagerFactory.addThreadCacheManager(defaultCacheManager);
    }

    private static DefaultCacheManager newDefaultCacheManager(boolean start, ConfigurationBuilderHolder holder) {
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager(holder, start);
        return TestCacheManagerFactory.addThreadCacheManager(defaultCacheManager);
    }

    private static DefaultCacheManager addThreadCacheManager(DefaultCacheManager cm) {
        if (shuttingDown) {
            try {
                shutDownLatch.await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        PerThreadCacheManagers threadCacheManagers = perThreadCacheManagers.get();
        String methodName = TestCacheManagerFactory.extractMethodName();
        if (cm.getAddress() != null) {
            String uuid = ((org.jgroups.util.UUID)((JGroupsAddress)cm.getAddress()).getJGroupsAddress()).toStringLong();
            log.debugf("Started cache manager %s, UUID is %s", (Object)cm.getAddress(), (Object)uuid);
        }
        log.trace((Object)("Adding DCM (" + cm.getCacheManagerConfiguration().transport().nodeName() + ") for method: '" + methodName + "'"));
        threadCacheManagers.add(methodName, cm);
        return cm;
    }

    private static String extractMethodName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length == 0) {
            return null;
        }
        for (int i = stack.length - 1; i > 0; --i) {
            StackTraceElement e = stack[i];
            String className = e.getClassName();
            if (className.indexOf("org.infinispan") == -1 || className.indexOf("org.infinispan.test") >= 0) continue;
            return e.toString();
        }
        return null;
    }

    public static void backgroundTestStarted(Object testInstance) {
        String fullName = testInstance.getClass().getName();
        String testName = testInstance.getClass().getSimpleName();
        TestCacheManagerFactory.testStarted(testName, fullName);
    }

    static void testStarted(String testName, String fullName) {
        perThreadCacheManagers.get().setTestName(testName, fullName);
    }

    static void testFinished(String testName) {
        perThreadCacheManagers.get().checkManagersClosed(testName);
        perThreadCacheManagers.get().unsetTestName();
    }

    public static ConfigurationBuilderHolder buildAggregateHolder(String ... xmls) throws XMLStreamException, FactoryConfigurationError {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        XMLMapper xmlMapper = XMLMapper.Factory.create();
        ServiceLoader<ConfigurationParser> parsers = ServiceLoader.load(ConfigurationParser.class, cl);
        for (ConfigurationParser parser : parsers) {
            for (Namespace ns : parser.getSupportedNamespaces()) {
                xmlMapper.registerRootElement(new QName(ns.getUri(), ns.getRootElement()), (XMLElementReader)parser);
            }
        }
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder(cl);
        for (int i = 0; i < xmls.length; ++i) {
            BufferedInputStream input = new BufferedInputStream(new ByteArrayInputStream(xmls[i].getBytes()));
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            xmlMapper.parseDocument((Object)holder, streamReader);
        }
        return holder;
    }

    static {
        shutDownLatch = new CountDownLatch(1);
        perThreadCacheManagers = new ThreadLocal<PerThreadCacheManagers>(){

            @Override
            protected PerThreadCacheManagers initialValue() {
                return new PerThreadCacheManagers();
            }
        };
    }

    private static class PerThreadCacheManagers {
        String testName = null;
        private String oldThreadName;
        HashMap<EmbeddedCacheManager, String> cacheManagers = new HashMap();
        String fullTestName;

        private PerThreadCacheManagers() {
        }

        public void checkManagersClosed(String testName) {
            for (Map.Entry<EmbeddedCacheManager, String> cmEntry : this.cacheManagers.entrySet()) {
                if (!cmEntry.getKey().getStatus().allowInvocations()) continue;
                String thName = Thread.currentThread().getName();
                String errorMessage = "\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n!!!!!! (" + thName + ") Exiting because " + testName + " has NOT shut down all the cache managers it has started !!!!!!!\n" + "!!!!!! (" + thName + ") The still-running cacheManager was created here: " + cmEntry.getValue() + " !!!!!!!\n" + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
                log.error((Object)errorMessage);
                shuttingDown = true;
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.err.println(errorMessage);
                System.exit(9);
            }
            this.cacheManagers.clear();
        }

        public String getNextCacheName() {
            int index = this.cacheManagers.size();
            return (this.testName != null ? this.testName + "-" : "") + "Node" + this.getNameForIndex(index);
        }

        private String getNameForIndex(int i) {
            int k = 26;
            String c = String.valueOf((char)(65 + i % 26));
            int q = i / 26;
            return q == 0 ? c : this.getNameForIndex(q - 1) + c;
        }

        public void add(String methodName, DefaultCacheManager cm) {
            this.cacheManagers.put((EmbeddedCacheManager)cm, methodName);
        }

        public void setTestName(String testName, String fullTestName) {
            this.testName = testName;
            this.fullTestName = fullTestName;
            this.oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("testng-" + testName);
        }

        public void unsetTestName() {
            this.testName = null;
            Thread.currentThread().setName(this.oldThreadName);
            this.oldThreadName = null;
        }
    }
}

