/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionTable;
import org.testng.annotations.Test;

@Test(testName="tx.ReadOnlyTxCleanupTest", groups={"functional"})
@CleanupAfterMethod
public class ReadOnlyTxCleanupTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = TestCacheManagerFactory.getDefaultConfiguration(true);
        return TestCacheManagerFactory.createCacheManager(c);
    }

    public void testReadOnlyTx() throws SystemException, RollbackException, HeuristicRollbackException, HeuristicMixedException, NotSupportedException {
        Cache c1 = this.cacheManager.getCache();
        Cache c2 = this.cacheManager.getCache("two");
        c1.put((Object)"c1", (Object)"c1");
        c2.put((Object)"c2", (Object)"c2");
        TransactionManager tm1 = this.tm();
        tm1.begin();
        c1.get((Object)"c1");
        c2.get((Object)"c2");
        tm1.commit();
        TransactionTable tt1 = TestingUtil.extractComponent(c1, TransactionTable.class);
        TransactionTable tt2 = TestingUtil.extractComponent(c2, TransactionTable.class);
        assert (tt1.getLocalTxCount() == 0);
        assert (tt2.getLocalTxCount() == 0);
    }
}

