/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.CountDownLatch;
import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="tx.RollbackBeforePrepareTest", groups={"functional"})
public class RollbackBeforePrepareTest
extends MultipleCacheManagersTest {
    public static final long REPL_TIMEOUT = 1000L;
    public static final long LOCK_TIMEOUT = 500L;
    private FailPrepareInterceptor failPrepareInterceptor;
    protected CacheMode cacheMode;
    protected int numOwners;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.cacheMode = CacheMode.REPL_SYNC;
        ConfigurationBuilder config = RollbackBeforePrepareTest.getDefaultClusteredCacheConfig(this.cacheMode, true);
        this.numOwners = 3;
        config.locking().lockAcquisitionTimeout(500L).clustering().sync().replTimeout(1000L).clustering().hash().numOwners(this.numOwners).transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).transaction().completedTxTimeout(3600000L);
        this.createCluster(config, 3);
        this.waitForClusterToForm();
        this.failPrepareInterceptor = new FailPrepareInterceptor();
        this.advancedCache(2).addInterceptor((CommandInterceptor)this.failPrepareInterceptor, 1);
    }

    public void testCommitNotSentBeforeAllPrepareAreAck() throws Exception {
        ControlledCommandFactory ccf = ControlledCommandFactory.registerControlledCommandFactory(this.cache(1), PrepareCommand.class);
        ccf.gate.close();
        try {
            this.cache(0).put((Object)"k", (Object)"v");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RollbackBeforePrepareTest.allowRollbackToRun();
        ccf.gate.open();
        Thread.sleep(3000L);
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                int remoteTxCount0 = TestingUtil.getTransactionTable((Cache<Object, Object>)RollbackBeforePrepareTest.this.cache(0)).getRemoteTxCount();
                int remoteTxCount1 = TestingUtil.getTransactionTable((Cache<Object, Object>)RollbackBeforePrepareTest.this.cache(1)).getRemoteTxCount();
                int remoteTxCount2 = TestingUtil.getTransactionTable((Cache<Object, Object>)RollbackBeforePrepareTest.this.cache(2)).getRemoteTxCount();
                RollbackBeforePrepareTest.this.log.tracef("remote0=%s, remote1=%s, remote2=%s", (Object)remoteTxCount0, (Object)remoteTxCount1, (Object)remoteTxCount2);
                return remoteTxCount0 == 0 && remoteTxCount1 == 0 && remoteTxCount2 == 0;
            }
        });
        Assert.assertNull((Object)this.cache(0).get((Object)"k"));
        Assert.assertNull((Object)this.cache(1).get((Object)"k"));
        Assert.assertNull((Object)this.cache(2).get((Object)"k"));
        this.assertNotLocked("k");
    }

    private static void allowRollbackToRun() throws InterruptedException {
        Thread.sleep(15000L);
    }

    public static class FailPrepareInterceptor
    extends CommandInterceptor {
        CountDownLatch failureFinish = new CountDownLatch(1);

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            try {
                throw new TimeoutException("Induced!");
            }
            catch (Throwable throwable) {
                this.failureFinish.countDown();
                throw throwable;
            }
        }
    }
}

