/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.dld;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ControlledRpcManager
implements RpcManager {
    private static final Log log = LogFactory.getLog(ControlledRpcManager.class);
    private final ReclosableLatch replicationLatch = new ReclosableLatch(true);
    private final ReclosableLatch blockingLatch = new ReclosableLatch(true);
    private volatile Set<Class> blockBeforeFilter = Collections.emptySet();
    private volatile Set<Class> blockAfterFilter = Collections.emptySet();
    private volatile Set<Class> failFilter = Collections.emptySet();
    protected RpcManager realOne;

    public ControlledRpcManager(RpcManager realOne) {
        this.realOne = realOne;
    }

    public void failFor(Class ... filter) {
        this.failFilter = new HashSet<Class>(Arrays.asList(filter));
    }

    public void stopFailing() {
        this.failFilter = Collections.emptySet();
    }

    public void blockBefore(Class ... filter) {
        this.blockBeforeFilter = new HashSet<Class>(Arrays.asList(filter));
        this.replicationLatch.close();
    }

    public void blockAfter(Class ... filter) {
        this.blockAfterFilter = new HashSet<Class>(Arrays.asList(filter));
        this.replicationLatch.close();
    }

    public void stopBlocking() {
        this.blockBeforeFilter = Collections.emptySet();
        this.blockAfterFilter = Collections.emptySet();
        this.replicationLatch.open();
    }

    public void waitForCommandToBlock() throws InterruptedException {
        this.blockingLatch.await();
    }

    protected void waitBefore(ReplicableCommand rpcCommand) {
        this.waitForReplicationLatch(rpcCommand, this.blockBeforeFilter);
    }

    protected void waitAfter(ReplicableCommand rpcCommand) {
        this.waitForReplicationLatch(rpcCommand, this.blockAfterFilter);
    }

    protected void waitForReplicationLatch(ReplicableCommand rpcCommand, Set<Class> filter) {
        Class cmdClass = this.getActualClass(rpcCommand);
        if (!filter.contains(cmdClass)) {
            return;
        }
        try {
            log.debugf("Replication trigger called, waiting for latch to open.", new Object[0]);
            this.replicationLatch.await();
            log.trace((Object)"Replication latch opened, continuing.");
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception!", e);
        }
    }

    private Class getActualClass(ReplicableCommand rpcCommand) {
        Class<?> cmdClass = rpcCommand.getClass();
        if (cmdClass.equals(SingleRpcCommand.class)) {
            cmdClass = ((SingleRpcCommand)rpcCommand).getCommand().getClass();
        }
        return cmdClass;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) {
        log.trace((Object)"invokeRemotely1");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        Map responseMap = this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
        this.waitAfter(rpcCommand);
        return responseMap;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue) {
        log.trace((Object)"invokeRemotely2");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        Map responseMap = this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue);
        this.waitAfter(rpcCommand);
        return responseMap;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout) {
        log.trace((Object)"invokeRemotely3");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        Map responseMap = this.realOne.invokeRemotely(recipients, rpcCommand, mode, timeout);
        this.waitAfter(rpcCommand);
        return responseMap;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean sync) throws RpcException {
        log.trace((Object)"invokeRemotely4");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        Map responseMap = this.realOne.invokeRemotely(recipients, rpcCommand, sync);
        this.waitAfter(rpcCommand);
        return responseMap;
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean sync, boolean usePriorityQueue) throws RpcException {
        log.trace((Object)"invokeRemotely5");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        Map responses = this.realOne.invokeRemotely(recipients, rpcCommand, sync, usePriorityQueue);
        this.waitAfter(rpcCommand);
        return responses;
    }

    public void broadcastRpcCommand(ReplicableCommand rpcCommand, boolean sync) throws RpcException {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommand1");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        this.realOne.broadcastRpcCommand(rpcCommand, sync);
        this.waitAfter(rpcCommand);
    }

    public void broadcastRpcCommand(ReplicableCommand rpcCommand, boolean sync, boolean usePriorityQueue) throws RpcException {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommand2");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        this.realOne.broadcastRpcCommand(rpcCommand, sync, usePriorityQueue);
        this.waitAfter(rpcCommand);
    }

    public void broadcastRpcCommandInFuture(ReplicableCommand rpcCommand, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture1");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        this.realOne.broadcastRpcCommandInFuture(rpcCommand, future);
        this.waitAfter(rpcCommand);
    }

    public void broadcastRpcCommandInFuture(ReplicableCommand rpcCommand, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.broadcastRpcCommandInFuture2");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        this.realOne.broadcastRpcCommandInFuture(rpcCommand, usePriorityQueue, future);
        this.waitAfter(rpcCommand);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpcCommand, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture1");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        this.realOne.invokeRemotelyInFuture(recipients, rpcCommand, future);
        this.waitAfter(rpcCommand);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture2");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        this.realOne.invokeRemotelyInFuture(recipients, rpcCommand, usePriorityQueue, future);
        this.waitAfter(rpcCommand);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture3");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        this.realOne.invokeRemotelyInFuture(recipients, rpcCommand, usePriorityQueue, future, timeout);
        this.waitAfter(rpcCommand);
    }

    public void invokeRemotelyInFuture(Collection<Address> recipients, ReplicableCommand rpcCommand, boolean usePriorityQueue, NotifyingNotifiableFuture<Object> future, long timeout, boolean ignoreLeavers) {
        log.trace((Object)"ControlledRpcManager.invokeRemotelyInFuture4");
        this.failIfNeeded(rpcCommand);
        this.waitBefore(rpcCommand);
        this.realOne.invokeRemotelyInFuture(recipients, rpcCommand, usePriorityQueue, future, timeout, ignoreLeavers);
        this.waitAfter(rpcCommand);
    }

    public Transport getTransport() {
        return this.realOne.getTransport();
    }

    public Address getAddress() {
        return this.realOne.getAddress();
    }

    public void failIfNeeded(ReplicableCommand rpcCommand) {
        if (this.failFilter.contains(this.getActualClass(rpcCommand))) {
            throw new IllegalStateException("Induced failure!");
        }
    }

    public int getTopologyId() {
        return this.realOne.getTopologyId();
    }

    public List<Address> getMembers() {
        return this.realOne.getMembers();
    }
}

